/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.templateprovider;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.webtemplate.templateprovider.TemplateProvider;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;

public class FileBasedTemplateProvider
implements TemplateProvider {
    public static final PathMatcher OPT_FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.opt");
    private final Map<String, Path> pathMap = new HashMap<String, Path>();
    private final Path templateDirectory;

    public FileBasedTemplateProvider(Path templateDirectory) {
        this.templateDirectory = templateDirectory;
        this.snyc(templateDirectory);
    }

    private void snyc(Path templateDirectory) {
        try (Stream<Path> walk = Files.walk(templateDirectory, new FileVisitOption[0]);){
            walk.filter(p -> p.toFile().isFile()).filter(OPT_FILE_MATCHER::matches).filter(p -> !this.pathMap.containsValue(p)).forEach(p -> this.pathMap.put(this.extractTemplateId((Path)p), (Path)p));
        }
        catch (IOException e) {
            throw new SdkException(e.getMessage(), (Throwable)e);
        }
    }

    private String extractTemplateId(Path path) {
        return this.readTemplate(path).getTemplateId().getValue();
    }

    private OPERATIONALTEMPLATE readTemplate(Path path) {
        OPERATIONALTEMPLATE oPERATIONALTEMPLATE;
        FileInputStream in = new FileInputStream(path.toFile());
        try {
            TemplateDocument document = TemplateDocument.Factory.parse((InputStream)in);
            oPERATIONALTEMPLATE = document.getTemplate();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XmlException e) {
                throw new SdkException(e.getMessage(), e);
            }
        }
        ((InputStream)in).close();
        return oPERATIONALTEMPLATE;
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> find(String templateId) {
        if (!this.pathMap.containsKey(templateId)) {
            this.snyc(this.templateDirectory);
        }
        return Optional.ofNullable(this.pathMap.get(templateId)).map(this::readTemplate);
    }
}

