/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.ehr.encode.rawjson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import org.ehrbase.ehr.encode.EncodeUtilArchie;
import org.ehrbase.ehr.encode.wrappers.json.I_DvTypeAdapter;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.ArchieCompositionProlog;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.CompositionRoot;

public class LightRawJsonEncoder {
    private String jsonbOrigin;

    public LightRawJsonEncoder(String jsonbOrigin) {
        this.jsonbOrigin = jsonbOrigin;
    }

    public String encodeContentAsString(String root) {
        Object contentMap;
        Map<String, Object> fromDB = this.db2map(root != null && root.equals("value"));
        GsonBuilder gsonRaw = EncodeUtilArchie.getGsonBuilderInstance(I_DvTypeAdapter.AdapterType.DBJSON2RAWJSON);
        String raw = root != null ? ((contentMap = fromDB.get(root)) instanceof LinkedTreeMap && ((LinkedTreeMap)contentMap).size() == 0 ? this.encodeNullContent() : gsonRaw.create().toJson(fromDB.get(root))) : gsonRaw.create().toJson(fromDB);
        return raw;
    }

    private String encodeNullContent() {
        Hashtable nullContentMap = new Hashtable();
        nullContentMap.put("content", new ArrayList());
        return new GsonBuilder().create().toJson(nullContentMap);
    }

    public JsonElement encodeContentAsJson(String root) {
        GsonBuilder gsonRaw = EncodeUtilArchie.getGsonBuilderInstance(I_DvTypeAdapter.AdapterType.DBJSON2RAWJSON);
        JsonElement jsonElement = gsonRaw.create().toJsonTree(this.db2map(root != null && root.equals("value")));
        if (root != null) {
            jsonElement = jsonElement.getAsJsonObject().get(root);
        }
        return jsonElement;
    }

    public String encodeCompositionAsString() {
        String root = new CompositionRoot(this.jsonbOrigin).toString();
        String converted = this.encodeContentAsString(root);
        return converted.replaceFirst(Pattern.quote("{"), new ArchieCompositionProlog(root).toString());
    }

    private Map<String, Object> db2map(boolean isValue) {
        Object contents;
        Map fromDB;
        GsonBuilder gsondb = EncodeUtilArchie.getGsonBuilderInstance();
        if (this.jsonbOrigin.startsWith("[")) {
            this.jsonbOrigin = isValue ? this.jsonbOrigin.trim().substring(1, this.jsonbOrigin.length() - 1) : "{\"items\":" + this.jsonbOrigin + "}";
        }
        if ((fromDB = (Map)gsondb.create().fromJson(this.jsonbOrigin, Map.class)).containsKey("content") && (contents = fromDB.get("content")) instanceof LinkedTreeMap) {
            for (Object contentItem : ((LinkedTreeMap)contents).entrySet()) {
                if (!(contentItem instanceof Map.Entry)) continue;
                fromDB.put(((Map.Entry)contentItem).getKey().toString(), ((Map.Entry)contentItem).getValue());
            }
            fromDB.remove("content");
        }
        return fromDB;
    }
}

