/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.ehr.encode.wrappers.json.writer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import java.io.IOException;
import java.util.Optional;
import org.ehrbase.ehr.encode.wrappers.ObjectSnakeCase;
import org.ehrbase.ehr.encode.wrappers.json.I_DvTypeAdapter;
import org.ehrbase.ehr.encode.wrappers.json.writer.CodePhraseAdapter;
import org.ehrbase.ehr.encode.wrappers.json.writer.DvTypeAdapter;
import org.ehrbase.ehr.encode.wrappers.json.writer.TermMappingAdapter;

public class DvCodedTextAdapter
extends DvTypeAdapter<DvCodedText> {
    private Gson gson;

    public DvCodedTextAdapter(I_DvTypeAdapter.AdapterType adapterType) {
        super(adapterType);
        this.gson = new GsonBuilder().registerTypeAdapter(CodePhrase.class, (Object)new CodePhraseAdapter(adapterType)).setPrettyPrinting().create();
    }

    public DvCodedTextAdapter() {
    }

    @Override
    public DvCodedText read(JsonReader arg0) throws IOException {
        return null;
    }

    @Override
    public void write(JsonWriter writer, DvCodedText dvalue) throws IOException {
        if (!Optional.ofNullable(dvalue).map(DvCodedText::getDefiningCode).map(CodePhrase::getCodeString).isPresent()) {
            writer.nullValue();
            return;
        }
        TermMappingAdapter termMappingAdapter = new TermMappingAdapter();
        if (this.adapterType == I_DvTypeAdapter.AdapterType.PG_JSONB) {
            writer.beginObject();
            writer.name("value").value(dvalue.getValue());
            writer.name("definingCode");
            writer.beginObject();
            writer.name("codeString").value(dvalue.getDefiningCode().getCodeString());
            writer.name("terminologyId");
            writer.beginObject();
            writer.name("name").value(dvalue.getDefiningCode().getTerminologyId().getValue());
            writer.name("value").value(dvalue.getDefiningCode().getTerminologyId().getValue());
            writer.endObject();
            writer.endObject();
            termMappingAdapter.write(writer, dvalue.getMappings());
            writer.endObject();
        } else if (this.adapterType == I_DvTypeAdapter.AdapterType.RAW_JSON) {
            writer.beginObject();
            writer.name("_type").value(new ObjectSnakeCase(dvalue).camelToUpperSnake());
            writer.name("value").value(dvalue.getValue());
            CodePhrase codePhrase = dvalue.getDefiningCode();
            writer.name("defining_code").value(this.gson.toJson((Object)codePhrase));
            writer.endObject();
        }
    }
}

