/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw;

import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nedap.archie.rm.datavalues.encapsulated.DvMultimedia;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.ehrbase.ehr.encode.wrappers.SnakeCase;
import org.ehrbase.ehr.encode.wrappers.json.I_DvTypeAdapter;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.ArrayClosure;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.ArrayListAdapter;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.Children;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.ElementType;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.NodeId;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.PathAttribute;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.RawJsonKey;

public class LinkedTreeMapAdapter
extends TypeAdapter<LinkedTreeMap>
implements I_DvTypeAdapter {
    private String[] structuralClasses = new String[]{"PointEvent", "Instruction", "Evaluation", "Observation", "Action", "AdminEntry", "IntervalEvent"};
    protected I_DvTypeAdapter.AdapterType adapterType;
    private boolean isRoot;

    public LinkedTreeMapAdapter(I_DvTypeAdapter.AdapterType adapterType) {
        this.adapterType = adapterType;
        this.isRoot = true;
    }

    public LinkedTreeMapAdapter() {
        this.adapterType = I_DvTypeAdapter.AdapterType.DBJSON2RAWJSON;
        this.isRoot = false;
    }

    public LinkedTreeMap read(JsonReader arg0) {
        return null;
    }

    private void writeInternal(JsonWriter writer, LinkedTreeMap<String, Object> map) throws IOException {
        boolean isItemsOnly = new Children(map).isItemsOnly();
        boolean isMultiEvents = new Children(map).isEvents();
        boolean isMultiContent = new Children(map).isMultiContent();
        String parentItemsArchetypeNodeId = null;
        String parentItemsType = null;
        if (isItemsOnly || isMultiEvents) {
            if (map.containsKey((Object)"archetype_node_id")) {
                parentItemsArchetypeNodeId = (String)map.get((Object)"archetype_node_id");
                map.remove((Object)"archetype_node_id");
            }
            if (map.containsKey((Object)"_type")) {
                parentItemsType = (String)map.get((Object)"_type");
                map.remove((Object)"_type");
            }
            if (map.containsKey((Object)"/$CLASS$")) {
                parentItemsType = new SnakeCase((String)((ArrayList)map.get((Object)"/$CLASS$")).get(0)).camelToUpperSnake();
                map.remove((Object)"/$CLASS$");
            }
        } else if (isMultiContent && map.containsKey((Object)"archetype_node_id")) {
            parentItemsArchetypeNodeId = (String)map.get((Object)"archetype_node_id");
            map.remove((Object)"archetype_node_id");
        }
        if (isItemsOnly) {
            ArrayList items = new Children(map).items();
            if (map.containsKey((Object)"/name")) {
                if (map.get((Object)"/name") instanceof ArrayList) {
                    this.writeNameAsValue(writer, (ArrayList)map.get((Object)"/name"));
                } else if (map.get((Object)"/name") instanceof String) {
                    this.writeNameAsValue(writer, (String)map.get((Object)"/name"));
                }
            }
            this.writeItemInArray("items", items, writer, parentItemsArchetypeNodeId, parentItemsType);
        } else if (isMultiEvents) {
            ArrayList events = new Children(map).events();
            this.writeItemInArray("events", events, writer, parentItemsArchetypeNodeId, parentItemsType);
        } else if (isMultiContent) {
            while (map.keySet().iterator().hasNext()) {
                String key = (String)map.keySet().iterator().next();
                if (!key.startsWith("/content")) {
                    if (map.get((Object)key) instanceof LinkedTreeMap) {
                        writer.name(key);
                        writer.beginObject();
                        this.writeNode((LinkedTreeMap)map.get((Object)key), writer);
                        writer.endObject();
                    } else {
                        writer.name(key).value((String)map.get((Object)key));
                    }
                    map.remove((Object)key);
                } else {
                    if (this.isNodePredicate(key)) {
                        for (Object entry : map.entrySet()) {
                            if (!(entry instanceof Map.Entry)) continue;
                            Map.Entry kv = (Map.Entry)entry;
                            for (Object valueMap : (ArrayList)kv.getValue()) {
                                if (!(valueMap instanceof LinkedTreeMap)) continue;
                                LinkedTreeMap vm = (LinkedTreeMap)valueMap;
                                vm.put((Object)"/archetype_node_id", (Object)new PathAttribute((String)kv.getKey()).archetypeNodeId());
                            }
                        }
                    }
                    Children children = new Children(map);
                    ArrayList contents = children.contents();
                    this.writeContent(contents, writer);
                    map = children.removeContents();
                }
                if (map.size() != 0) continue;
                return;
            }
        } else {
            this.writeNode(map, writer);
        }
    }

    private LinkedTreeMap reformatEmbeddedValue(LinkedTreeMap instructionMap, String tag) {
        LinkedTreeMap narrative;
        LinkedTreeMap narrativeValue;
        if (instructionMap.containsKey((Object)tag) && (narrativeValue = (LinkedTreeMap)(narrative = (LinkedTreeMap)instructionMap.get((Object)tag)).get((Object)"/value")) != null) {
            narrative.replace((Object)"/value", narrativeValue.get((Object)"value"));
        }
        return instructionMap;
    }

    private LinkedTreeMap promoteActivities(LinkedTreeMap<String, Object> instructionMap) {
        if (instructionMap.containsKey((Object)"/activities")) {
            LinkedTreeMap activities = (LinkedTreeMap)instructionMap.get((Object)"/activities");
            for (Map.Entry activityItem : activities.entrySet()) {
                if (!((String)activityItem.getKey()).startsWith("/activities")) continue;
                instructionMap.put((Object)((String)activityItem.getKey()), activityItem.getValue());
            }
            instructionMap.remove((Object)"/activities");
        }
        return instructionMap;
    }

    private LinkedTreeMap reformatMapForCanonical(LinkedTreeMap map) {
        if (map.containsKey((Object)"/activities")) {
            this.promoteActivities((LinkedTreeMap<String, Object>)map);
        }
        if (map.containsKey((Object)"/narrative")) {
            this.reformatEmbeddedValue(map, "/narrative");
        }
        if (map.containsKey((Object)"/math_function")) {
            this.reformatEmbeddedValue(map, "/math_function");
        }
        if (map.containsKey((Object)"/width")) {
            this.reformatEmbeddedValue(map, "/width");
        }
        if (map.containsKey((Object)"/uid")) {
            this.reformatEmbeddedValue(map, "/uid");
        }
        return map;
    }

    public void write(JsonWriter writer, LinkedTreeMap map) throws IOException {
        if (map.isEmpty()) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        this.writeInternal(writer, (LinkedTreeMap<String, Object>)map);
        writer.endObject();
    }

    private void writeNameAsValue(JsonWriter writer, String value) throws IOException {
        if (value == null || value.isEmpty()) {
            return;
        }
        writer.name("name");
        writer.beginObject();
        writer.name("value").value(value);
        writer.endObject();
    }

    private void writeNameAsValue(JsonWriter writer, ArrayList value) throws IOException {
        if (value == null) {
            return;
        }
        Object nameDefinition = ((Map)value.get(0)).get("value");
        if (nameDefinition != null) {
            this.writeNameAsValue(writer, nameDefinition.toString());
        }
    }

    private boolean isNodePredicate(String key) {
        return key.startsWith("/") && key.contains("[") && key.contains("]");
    }

    private LinkedTreeMap compactTimeMap(LinkedTreeMap<String, Object> valueMap) {
        LinkedTreeMap compactMap = new LinkedTreeMap();
        for (Object item : valueMap.entrySet()) {
            String key = (String)((Map.Entry)item).getKey();
            if (key.equals("/value")) {
                String value = (String)((LinkedTreeMap)((Map.Entry)item).getValue()).get((Object)"value");
                compactMap.put((Object)"/value", (Object)value);
                continue;
            }
            compactMap.put(((Map.Entry)item).getKey(), ((Map.Entry)item).getValue());
        }
        return compactMap;
    }

    private void writeItemInArray(String heading, ArrayList value, JsonWriter writer, String parentItemsArchetypeNodeId, String parentItemsType) throws IOException {
        new ArrayClosure(writer, parentItemsArchetypeNodeId, parentItemsType).start();
        if (value.isEmpty()) {
            return;
        }
        for (int cursor = 0; cursor < value.size(); ++cursor) {
            if (cursor == 0) {
                writer.name(heading);
                writer.beginArray();
            }
            if (value.get(cursor) instanceof ArrayList) {
                new ArrayListAdapter().write(writer, (ArrayList)value.get(cursor));
                continue;
            }
            new LinkedTreeMapAdapter().write(writer, (LinkedTreeMap)value.get(cursor));
        }
        writer.endArray();
    }

    private void writeContent(ArrayList value, JsonWriter writer) throws IOException {
        for (int cursor = 0; cursor < value.size(); ++cursor) {
            if (cursor == 0) {
                writer.name("content");
                writer.beginArray();
            }
            if (value.get(cursor) instanceof ArrayList) {
                new ArrayListAdapter().write(writer, (ArrayList)value.get(cursor));
                continue;
            }
            new LinkedTreeMapAdapter().write(writer, (LinkedTreeMap)value.get(cursor));
        }
        writer.endArray();
    }

    private void writeNode(LinkedTreeMap map, JsonWriter writer) throws IOException {
        this.reformatMapForCanonical(map);
        block10: for (Object entry : map.entrySet()) {
            Object value = ((Map.Entry)entry).getValue();
            if (value == null) continue;
            Double[] key = (Double[])((Map.Entry)entry).getKey();
            String jsonKey = new RawJsonKey((String)key).toRawJson();
            String archetypeNodeId = new NodeId((String)key).predicate();
            if (value instanceof ArrayList && key.equals("data") && map.get((Object)"_type").equals(ArchieRMInfoLookup.getInstance().getTypeInfo(DvMultimedia.class).getRmName())) {
                Double[] dataStore = new Double[((ArrayList)value).size()];
                value = ((ArrayList)value).toArray(dataStore);
            }
            if (value instanceof ArrayList) {
                if (key.equals("/name")) {
                    ArrayList nodeNameValue = (ArrayList)value;
                    this.writeNameAsValue(writer, nodeNameValue);
                    continue;
                }
                if (key.equals("/$CLASS$")) {
                    writer.name("_type").value(new SnakeCase((String)((ArrayList)value).get(0)).camelToUpperSnake());
                    continue;
                }
                writer.name(jsonKey);
                writer.beginArray();
                if (this.isNodePredicate((String)key)) {
                    ((ArrayList)value).stream().filter(o -> Map.class.isAssignableFrom(o.getClass())).forEach(m -> ((Map)m).put("archetype_node_id", archetypeNodeId));
                }
                new ArrayListAdapter().write(writer, (ArrayList)value);
                writer.endArray();
                continue;
            }
            if (value instanceof LinkedTreeMap) {
                String type;
                LinkedTreeMap timingValueMap;
                LinkedTreeMap valueMap = (LinkedTreeMap)value;
                String elementType = new ElementType((Map)valueMap).type();
                if (elementType.equals("History")) {
                    LinkedTreeMap eventMap = (LinkedTreeMap)valueMap.get((Object)"/events");
                    valueMap.remove((Object)"/events");
                    valueMap.putAll((Map)eventMap);
                } else if (archetypeNodeId.equals("/timing") && elementType.equals("DvParsable") && (timingValueMap = (LinkedTreeMap)valueMap.get((Object)"/value")) != null) {
                    valueMap.put((Object)"/value", timingValueMap.get("value"));
                    valueMap.put((Object)"/formalism", timingValueMap.get("formalism"));
                }
                if (key.equals("/value") && (type = (String)map.get((Object)"/$CLASS$")) != null && !type.isEmpty()) {
                    valueMap.put((Object)"_type", (Object)new SnakeCase(type).camelToUpperSnake());
                }
                if (valueMap.containsKey((Object)"/$CLASS$")) {
                    valueMap.put((Object)"_type", (Object)new SnakeCase(elementType).camelToUpperSnake());
                    valueMap.remove((Object)"/$CLASS$");
                    if (key.contains("/time")) {
                        valueMap.remove((Object)"/name");
                    }
                }
                if (this.isNodePredicate((String)key)) {
                    valueMap.put((Object)"archetype_node_id", (Object)archetypeNodeId);
                } else if (key.equals("/origin") || key.equals("/time")) {
                    valueMap = this.compactTimeMap((LinkedTreeMap<String, Object>)valueMap);
                }
                writer.name(jsonKey);
                new LinkedTreeMapAdapter().write(writer, valueMap);
                continue;
            }
            if (value instanceof String) {
                switch (key) {
                    case "/$CLASS$": {
                        if (!Arrays.asList(this.structuralClasses).contains(value)) continue block10;
                        writer.name("_type").value(new SnakeCase((String)value).camelToUpperSnake());
                        break;
                    }
                    case "/$PATH$": {
                        String archetypeNodeId2 = new PathAttribute((String)value).archetypeNodeId();
                        if (archetypeNodeId2 == null) continue block10;
                        writer.name("_type").value("ELEMENT");
                        break;
                    }
                    case "/name": {
                        this.writeNameAsValue(writer, value.toString());
                        break;
                    }
                    default: {
                        writer.name(jsonKey).value((String)value);
                        break;
                    }
                }
                continue;
            }
            if (value instanceof Double) {
                writer.name(new SnakeCase((String)key).camelToSnake()).value((Number)((Double)value));
                continue;
            }
            if (value instanceof Long) {
                writer.name(new SnakeCase((String)key).camelToSnake()).value((Number)((Long)value));
                continue;
            }
            if (value instanceof Number) {
                writer.name(new SnakeCase((String)key).camelToSnake()).value((Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                writer.name(new SnakeCase((String)key).camelToSnake()).value((Boolean)value);
                continue;
            }
            if (value instanceof Double[]) {
                writer.name(new SnakeCase((String)key).camelToSnake());
                writer.beginArray();
                for (Double pix : (Double[])value) {
                    writer.value((long)pix.byteValue());
                }
                writer.endArray();
                continue;
            }
            throw new IllegalArgumentException("Could not handle value type for key:" + (String)key + ", value:" + value);
        }
    }
}

