/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PathAttribute {
    public static final String AND_NAME_VALUE = "and name/value='";
    String path;

    public PathAttribute(String path) {
        this.path = path;
    }

    public PathAttribute() {
    }

    String nodeNameFromPath(String key) {
        String namePart = AND_NAME_VALUE;
        int startAt = -1;
        if (key.indexOf("]") >= 0) {
            startAt = this.path.indexOf(key.substring(0, key.indexOf("]")));
        }
        if (startAt >= 0) {
            return this.path.substring(this.path.indexOf(namePart, startAt) + namePart.length(), this.path.indexOf("]", startAt) - 1);
        }
        return null;
    }

    String parentArchetypeNodeId(String key) {
        if (this.path == null) {
            return null;
        }
        List<String> pathSegments = PathAttribute.dividePathIntoSegments(this.path);
        String compareKey = key.trim();
        if (key.startsWith("/")) {
            compareKey = compareKey.substring(1);
        }
        if (compareKey.endsWith("]")) {
            compareKey = compareKey.substring(0, compareKey.length() - 1);
        }
        for (int i = 0; i < pathSegments.size(); ++i) {
            String pathNode = pathSegments.get(i);
            if (!pathNode.startsWith(compareKey)) continue;
            if (i > 0) {
                String parentNode = pathSegments.get(i - 1);
                String parentArchetypeNodeId = parentNode.contains(AND_NAME_VALUE) ? parentNode.substring(parentNode.indexOf("[") + 1, parentNode.indexOf(AND_NAME_VALUE)).trim() : parentNode.substring(parentNode.indexOf("[") + 1, parentNode.indexOf("]")).trim();
                return parentArchetypeNodeId;
            }
            return null;
        }
        return null;
    }

    String parentNodeName(String key) {
        if (this.path == null) {
            return null;
        }
        List<String> pathSegments = PathAttribute.dividePathIntoSegments(this.path);
        String compareKey = key.trim();
        if (key.startsWith("/")) {
            compareKey = compareKey.substring(1);
        }
        if (compareKey.endsWith("]")) {
            compareKey = compareKey.substring(0, compareKey.length() - 1);
        }
        for (int i = 0; i < pathSegments.size(); ++i) {
            String pathNode = pathSegments.get(i);
            if (!pathNode.startsWith(compareKey)) continue;
            if (i > 0) {
                String parentNode = pathSegments.get(i - 1);
                String parentArchetypeNodeId = null;
                if (parentNode.contains(AND_NAME_VALUE)) {
                    parentArchetypeNodeId = parentNode.substring(parentNode.indexOf(AND_NAME_VALUE) + AND_NAME_VALUE.length(), parentNode.indexOf("]") - 1).trim();
                }
                return parentArchetypeNodeId;
            }
            return null;
        }
        return null;
    }

    String structuralNodeKey(LinkedTreeMap map) {
        for (Object entry : map.entrySet()) {
            String key = (String)((Map.Entry)entry).getKey();
            if (!key.matches("/(content|protocol|events|data|description|instruction|items|activities|activity|composition|entry|evaluation|observation|action|at)\\[([(0-9)|(A-Z)|(a-z)|\\-|_|\\.]*)\\]")) continue;
            return key;
        }
        return null;
    }

    String findPath(Object value) {
        String foundPath = null;
        if (value instanceof List) {
            for (Object listItem : (List)value) {
                String path = this.findPath(listItem);
                if (path == null) continue;
                return path;
            }
        } else {
            return this.usePath(foundPath, (LinkedTreeMap)value);
        }
        return null;
    }

    String usePath(String path, LinkedTreeMap linkedTreeMap) {
        if (path != null) {
            return path;
        }
        if (linkedTreeMap.containsKey((Object)"/$PATH$")) {
            return linkedTreeMap.get((Object)"/$PATH$").toString();
        }
        for (Object object : linkedTreeMap.entrySet()) {
            Iterator iterator;
            Map.Entry entry = (Map.Entry)object;
            String key = (String)entry.getKey();
            if (!key.matches("/(content|protocol|events|data|description|instruction|items|activities|activity|composition|entry|evaluation|observation|action|at)\\[([(0-9)|(A-Z)|(a-z)|\\-|_|\\.]*)\\]")) continue;
            if (entry.getValue() instanceof List && (iterator = ((List)entry.getValue()).iterator()).hasNext()) {
                Object item = iterator.next();
                return this.usePath(path, (LinkedTreeMap)item);
            }
            if (entry.getValue() instanceof LinkedTreeMap) {
                return this.usePath(path, (LinkedTreeMap)entry.getValue());
            }
            if (!entry.getKey().equals("/$PATH$")) continue;
            return entry.getValue().toString();
        }
        return null;
    }

    String archetypeNodeId() {
        if (this.path == null) {
            return null;
        }
        List<String> pathSegments = PathAttribute.dividePathIntoSegments(this.path);
        String lastSegment = pathSegments.get(pathSegments.size() - 1);
        if (!lastSegment.contains("[")) {
            return null;
        }
        String archetypeNodeId = lastSegment.contains(AND_NAME_VALUE) ? lastSegment.substring(lastSegment.indexOf("[") + 1, lastSegment.indexOf(AND_NAME_VALUE)).trim() : lastSegment.substring(lastSegment.indexOf("[") + 1, lastSegment.indexOf("]")).trim();
        return archetypeNodeId;
    }

    public static List<String> dividePathIntoSegments(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens()) {
            Object next = tokens.nextToken();
            if (((String)next).matches(".+\\[.+[^\\]]$")) {
                while (!((String)(next = (String)next + "/" + tokens.nextToken())).matches(".*]$")) {
                }
            }
            segments.add((String)next);
        }
        return segments;
    }
}

