/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.composition.AdminEntry;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.ContentItem;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.InstructionDetails;
import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.composition.Section;
import com.nedap.archie.rm.datastructures.Cluster;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.IntervalEvent;
import com.nedap.archie.rm.datastructures.Item;
import com.nedap.archie.rm.datastructures.ItemList;
import com.nedap.archie.rm.datastructures.ItemSingle;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datastructures.ItemTable;
import com.nedap.archie.rm.datastructures.ItemTree;
import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.encapsulated.DvParsable;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.integration.GenericEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.collections.map.PredicatedMap;
import org.ehrbase.ehr.encode.EncodeUtilArchie;
import org.ehrbase.ehr.encode.ItemStack;
import org.ehrbase.serialisation.MarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositionSerializer {
    private static final String INITIAL_DUMMY_PREFIX = "$*>";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, Object> ctree;
    private String treeRootClass;
    private String treeRootArchetype;
    private final WalkerOutputMode tag_mode;
    private final boolean allElements;
    public static final String TAG_META = "/meta";
    public static final String TAG_CONTENT = "/content";
    public static final String TAG_PROTOCOL = "/protocol";
    public static final String TAG_DATA = "/data";
    public static final String TAG_STATE = "/state";
    public static final String TAG_DESCRIPTION = "/description";
    public static final String TAG_TIME = "/time";
    public static final String TAG_WIDTH = "/width";
    public static final String TAG_MATH_FUNCTION = "/math_function";
    public static final String TAG_INSTRUCTION = "/instruction";
    public static final String TAG_NARRATIVE = "/narrative";
    public static final String TAG_ITEMS = "/items";
    public static final String TAG_OTHER_CONTEXT = "/context/other_context";
    public static final String TAG_ACTIVITIES = "/activities";
    public static final String TAG_ACTIVITY = "/activity";
    public static final String TAG_VALUE = "/value";
    public static final String TAG_NULL_FLAVOUR = "/null_flavour";
    public static final String TAG_FEEDER_AUDIT = "/feeder_audit";
    public static final String TAG_EVENTS = "/events";
    public static final String TAG_ORIGIN = "/origin";
    public static final String TAG_SUMMARY = "/summary";
    public static final String TAG_TIMING = "/timing";
    public static final String TAG_COMPOSITION = "/composition";
    public static final String TAG_ENTRY = "/entry";
    public static final String TAG_EVALUATION = "/evaluation";
    public static final String TAG_OBSERVATION = "/observation";
    public static final String TAG_ACTION = "/action";
    public static final String TAG_SUBJECT = "/subject";
    public static final String TAG_ISM_TRANSITION = "/ism_transition";
    public static final String TAG_CURRENT_STATE = "/current_state";
    public static final String TAG_CAREFLOW_STEP = "/careflow_step";
    public static final String TAG_TRANSITION = "/transition";
    public static final String TAG_WORKFLOW_ID = "/workflow_id";
    public static final String TAG_GUIDELINE_ID = "/guideline_id";
    public static final String TAG_OTHER_PARTICIPATIONS = "/other_participations";
    public static final String TAG_PROVIDER = "/provider";
    public static final String TAG_UID = "/uid";
    public static final String TAG_OTHER_DETAILS = "/other_details";
    public static final String TAG_INSTRUCTION_DETAILS = "/instruction_details";
    public static final String TAG_ACTIVITY_ID = "/action_id";
    public static final String TAG_INSTRUCTION_ID = "/instruction_id";
    public static final String TAG_PATH = "/$PATH$";
    public static final String TAG_CLASS = "/$CLASS$";
    public static final String TAG_NAME = "/name";
    public static final String TAG_DEFINING_CODE = "/defining_code";
    public static final String INNER_CLASS_LIST = "$INNER_CLASS_LIST$";
    public static final String TAG_ACTION_ARCHETYPE_ID = "/action_archetype_id";
    public static final String TAG_ARCHETYPE_NODE_ID = "/archetype_node_id";
    public static final String DEFAULT_NARRATIVE = "DEFAULT_NARRATIVE";
    protected ItemStack itemStack = new ItemStack();

    protected CompositionSerializer() {
        this.allElements = false;
        this.tag_mode = WalkerOutputMode.PATH;
    }

    private Map<String, Object> newPathMap() {
        return MapUtils.predicatedMap(new TreeMap(), (Predicate)PredicateUtils.uniquePredicate(), null);
    }

    private Map<String, Object> newMultiMap() {
        return new MultiValueMap();
    }

    private Map<String, Object> mapName(DvText aName) {
        HashMap<String, Object> nameMap = new HashMap<String, Object>();
        if (aName instanceof DvCodedText) {
            nameMap.put("defining_code", ((DvCodedText)aName).getDefiningCode());
        }
        if (aName != null) {
            nameMap.put("value", aName.getValue());
        }
        return nameMap;
    }

    private Map<String, Object> mapName(String aName) {
        HashMap<String, Object> nameMap = new HashMap<String, Object>();
        nameMap.put("value", new DvText(aName));
        return nameMap;
    }

    private Map<String, List> nameAsValueList(Map map, Map nameValues) {
        ArrayList<Map> nameListMap = new ArrayList<Map>();
        nameListMap.add(nameValues);
        map.put(TAG_NAME, nameListMap);
        return map;
    }

    private Object putObject(String clazz, Object node, Map<String, Object> map, String key, Object addStructure) {
        if (addStructure == null) {
            return null;
        }
        if (addStructure instanceof Map && ((Map)addStructure).size() == 0 && !clazz.equals("Composition")) {
            return null;
        }
        if (key.equals(TAG_NAME)) {
            if (addStructure instanceof Map) {
                return this.nameAsValueList(map, (Map)addStructure);
            }
            throw new IllegalStateException("INTERNAL: addStructure is not a map, found:" + addStructure.getClass());
        }
        try {
            map.put(key, addStructure);
            if (node instanceof Locatable && map instanceof PredicatedMap && !map.containsKey(TAG_NAME)) {
                this.nameAsValueList(map, this.mapName(((Locatable)node).getName()));
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error("Ignoring duplicate key in path detected:" + key + " path:" + this.itemStack.pathStackDump() + " Exception:" + e);
        }
        if (clazz != null && !key.equals(TAG_PATH) && !map.containsKey(TAG_CLASS)) {
            map.put(TAG_CLASS, clazz);
        } else {
            this.log.debug(map.containsKey(TAG_CLASS) ? "duplicate TAG_CLASS" : "null clazz");
        }
        return map;
    }

    private String getNodeTag(String prefix, Locatable node, Object container) {
        switch (this.tag_mode) {
            case PATH: {
                String name;
                if (node == null) {
                    return prefix;
                }
                String path = prefix + "[" + node.getArchetypeNodeId() + "]";
                if (!container.getClass().equals(MultiValueMap.class) && !path.startsWith(TAG_DESCRIPTION) && (path.contains("[openEHR-") || path.contains(TAG_ACTIVITIES) || path.contains(TAG_ITEMS) || path.contains(TAG_EVENTS)) && (name = node.getName().getValue()) != null) {
                    path = path.substring(0, path.lastIndexOf("]")) + " and name/value='" + name + "']";
                }
                return path;
            }
            case NAMED: 
            case EXPANDED: 
            case RAW: {
                if (prefix.equals(TAG_ORIGIN) || prefix.equals(TAG_TIME) || prefix.equals(TAG_TIMING) || prefix.equals(TAG_EVENTS) && node == null) {
                    return "[" + prefix.substring(1) + "]";
                }
                if (node == null) {
                    return "!!!INVALID NAMED for " + prefix + " !!!";
                }
                return node.getArchetypeNodeId();
            }
        }
        return "*INVALID MODE*";
    }

    private String extractNodeTag(String prefix, Locatable node, Object container) {
        switch (this.tag_mode) {
            case PATH: {
                String name;
                if (node == null) {
                    return prefix;
                }
                String path = prefix + "[" + node.getArchetypeNodeId() + "]";
                if (!container.getClass().equals(MultiValueMap.class) && !path.startsWith(TAG_DESCRIPTION) && (path.contains("[openEHR-") || path.contains(TAG_ACTIVITIES) || path.contains(TAG_ITEMS) || path.contains(TAG_EVENTS)) && (name = node.getName().getValue()) != null) {
                    path = path.substring(0, path.lastIndexOf("]")) + " and name/value='" + name + "']";
                }
                return path;
            }
            case NAMED: 
            case EXPANDED: 
            case RAW: {
                if (prefix.equals(TAG_ORIGIN) || prefix.equals(TAG_TIME) || prefix.equals(TAG_TIMING) || prefix.equals(TAG_EVENTS) && node == null) {
                    return "[" + prefix.substring(1) + "]";
                }
                if (node == null) {
                    return "!!!INVALID NAMED for " + prefix + " !!!";
                }
                return node.getArchetypeNodeId();
            }
        }
        return "*INVALID MODE*";
    }

    private void encodePathItem(Map<String, Object> map, String tag) {
        switch (this.tag_mode) {
            case PATH: {
                this.putObject(null, null, map, TAG_PATH, tag == null ? this.itemStack.pathStackDump() : this.itemStack.pathStackDump() + tag);
                break;
            }
            case NAMED: {
                this.putObject(null, null, map, TAG_PATH, tag == null ? this.itemStack.namedStackDump() : this.itemStack.namedStackDump() + tag.substring(1));
                break;
            }
            case EXPANDED: {
                this.putObject(null, null, map, TAG_PATH, tag == null ? this.itemStack.expandedStackDump() : this.itemStack.expandedStackDump() + tag.substring(1));
                break;
            }
            case RAW: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tagging mode!");
            }
        }
    }

    private void encodeNodeAttribute(Map<String, Object> map, String tag, Object value, DvText name) {
        Map<String, Object> valuemap = this.newPathMap();
        if (name != null) {
            this.putObject(null, value, valuemap, TAG_NAME, this.mapName(name));
        }
        if (value != null) {
            this.putObject(this.className(value), value, valuemap, TAG_VALUE, value);
            this.encodePathItem(valuemap, tag);
            this.putObject(null, value, map, tag, valuemap);
        }
    }

    private void encodeNodeMetaData(Map<String, Object> map, Locatable locatable) {
    }

    private Map<String, Object> objectAttributes(RMObject object, String name) {
        Map<String, Object> valuemap = this.newPathMap();
        if (object instanceof PartyIdentified) {
            valuemap.put("name", name);
        } else {
            this.putObject(this.className(object), object, valuemap, TAG_NAME, this.mapName(name));
        }
        if (object instanceof Participation) {
            Participation participation = (Participation)object;
            valuemap.put(TAG_CLASS, this.className(participation));
            valuemap.put("function", participation.getFunction());
            valuemap.put("mode", participation.getMode());
            valuemap.put("time", participation.getTime());
            valuemap.put("performer", participation.getPerformer());
        } else {
            this.putObject(this.className(object), object, valuemap, TAG_VALUE, object);
        }
        return valuemap;
    }

    private Map<String, Object> mapRmObjectAttributes(RMObject object, String name) {
        Map<String, Object> valuemap = this.objectAttributes(object, name);
        if (object instanceof Participation) {
            this.encodePathItem(valuemap, TAG_OTHER_PARTICIPATIONS);
        } else {
            this.encodePathItem(valuemap, null);
        }
        return valuemap;
    }

    private Map<String, Object> mapRmObjectAttributes(RMObject object, String name, String tag) {
        Map<String, Object> valuemap = this.objectAttributes(object, name);
        this.encodePathItem(valuemap, tag);
        return valuemap;
    }

    private Map<String, Object> process(Composition composition) {
        this.ctree = this.newPathMap();
        if (composition == null) {
            return null;
        }
        Map<String, Object> ltree = this.newMultiMap();
        if (composition.getContent() != null && !composition.getContent().isEmpty()) {
            for (ContentItem item : composition.getContent()) {
                Map<String, Object> contentMap = this.traverse(item, TAG_CONTENT);
                if (contentMap != null && !contentMap.containsKey(TAG_NAME)) {
                    contentMap.put(TAG_NAME, this.mapName(item.getName()));
                }
                this.putObject(null, item, ltree, this.getNodeTag(TAG_CONTENT, (Locatable)item, ltree), contentMap);
            }
        }
        this.log.debug(ltree.toString());
        this.itemStack.popStacks();
        this.putObject(this.className(composition), composition, this.ctree, this.getNodeTag(TAG_COMPOSITION, (Locatable)composition, this.ctree), ltree);
        if (this.ctree.size() > 0) {
            String path = (String)this.ctree.keySet().toArray()[0];
            this.treeRootArchetype = ItemStack.normalizeLabel(path);
            this.treeRootClass = ItemStack.getLabelType(path);
        }
        return this.ctree;
    }

    private Map<String, Object> processItem(Locatable locatable) {
        if (locatable instanceof Item) {
            return this.traverse((Item)locatable, TAG_ITEMS);
        }
        if (locatable instanceof ItemStructure) {
            return this.traverse((ItemStructure)locatable, TAG_ITEMS);
        }
        throw new IllegalArgumentException("locatable is not an Item or ItemStructure instance...");
    }

    private Map<String, Object> traverse(ContentItem item, String tag) {
        Map<String, Object> retmap = null;
        if (item == null) {
            return null;
        }
        this.log.debug("traverse element of class:" + item.getClass() + ", tag:" + tag + ", nodeid:" + item.getArchetypeNodeId());
        if (item.getArchetypeNodeId() == null || item.getArchetypeNodeId().isEmpty()) {
            throw new IllegalArgumentException("ContentItem mandatory attribute archetype_node_id null or empty, item:" + item);
        }
        if (item.getName() == null || item.getName().getValue().isEmpty()) {
            throw new IllegalArgumentException("ContentItem mandatory attribute name is null or empty, item:" + item.getArchetypeNodeId());
        }
        this.itemStack.pushStacks(tag + "[" + item.getArchetypeNodeId() + "]", item.getName().getValue());
        if (item instanceof Observation) {
            Observation observation = (Observation)item;
            Map<String, Object> ltree = this.newPathMap();
            if (observation.getName() != null) {
                this.encodeNodeMetaData(ltree, (Locatable)observation);
            }
            if (observation.getProtocol() != null) {
                this.putObject(this.className(observation), observation, ltree, this.getNodeTag(TAG_PROTOCOL, (Locatable)observation.getProtocol(), ltree), this.traverse(observation.getProtocol(), TAG_PROTOCOL));
            }
            if (observation.getData() != null) {
                this.putObject(this.className(observation), observation, ltree, this.getNodeTag(TAG_DATA, (Locatable)observation.getData(), ltree), this.traverse(observation.getData(), TAG_DATA));
            }
            if (observation.getState() != null) {
                this.putObject(this.className(observation), observation, ltree, this.getNodeTag(TAG_STATE, (Locatable)observation.getState(), ltree), this.traverse(observation.getState(), TAG_STATE));
            }
            if (observation.getWorkflowId() != null) {
                this.encodeNodeAttribute(ltree, TAG_WORKFLOW_ID, observation.getWorkflowId(), observation.getName());
            }
            if (observation.getGuidelineId() != null) {
                this.encodeNodeAttribute(ltree, TAG_GUIDELINE_ID, observation.getGuidelineId(), observation.getName());
            }
            if (observation.getUid() != null) {
                this.encodeNodeAttribute(ltree, TAG_UID, observation.getUid(), observation.getName());
            }
            if (observation.getSubject() != null) {
                this.encodeNodeAttribute(ltree, TAG_SUBJECT, observation.getSubject(), observation.getName());
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof Evaluation) {
            Evaluation evaluation = (Evaluation)item;
            Map<String, Object> ltree = this.newPathMap();
            if (evaluation.getProtocol() != null) {
                this.putObject(this.className(evaluation), evaluation, ltree, this.getNodeTag(TAG_PROTOCOL, (Locatable)evaluation.getProtocol(), ltree), this.traverse(evaluation.getProtocol(), TAG_PROTOCOL));
            }
            if (evaluation.getData() != null) {
                this.putObject(this.className(evaluation), evaluation, ltree, this.getNodeTag(TAG_DATA, (Locatable)evaluation.getData(), ltree), this.traverse(evaluation.getData(), TAG_DATA));
            }
            if (evaluation.getWorkflowId() != null) {
                this.encodeNodeAttribute(ltree, TAG_WORKFLOW_ID, evaluation.getWorkflowId(), evaluation.getName());
            }
            if (evaluation.getGuidelineId() != null) {
                this.encodeNodeAttribute(ltree, TAG_GUIDELINE_ID, evaluation.getGuidelineId(), evaluation.getName());
            }
            if (evaluation.getUid() != null) {
                this.encodeNodeAttribute(ltree, TAG_UID, evaluation.getUid(), evaluation.getName());
            }
            if (evaluation.getName() != null) {
                this.encodeNodeMetaData(ltree, (Locatable)evaluation);
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof Instruction) {
            Map<String, Object> ltree = this.newPathMap();
            Instruction instruction = (Instruction)item;
            if (instruction.getProtocol() != null) {
                this.putObject(this.className(instruction), instruction, ltree, this.getNodeTag(TAG_PROTOCOL, (Locatable)((Instruction)item).getProtocol(), ltree), this.traverse(instruction.getProtocol(), TAG_PROTOCOL));
            }
            if (instruction.getNarrative() != null && (this.allElements || !instruction.getNarrative().equals((Object)new DvText(DEFAULT_NARRATIVE)))) {
                this.encodeNodeAttribute(ltree, TAG_NARRATIVE, instruction.getNarrative(), instruction.getName());
            }
            if (instruction.getWorkflowId() != null) {
                this.encodeNodeAttribute(ltree, TAG_WORKFLOW_ID, instruction.getWorkflowId(), instruction.getName());
            }
            if (instruction.getGuidelineId() != null) {
                this.encodeNodeAttribute(ltree, TAG_GUIDELINE_ID, instruction.getGuidelineId(), instruction.getName());
            }
            if (instruction.getUid() != null) {
                this.encodeNodeAttribute(ltree, TAG_UID, instruction.getUid(), new DvText(instruction.getUid().getValue()));
            }
            if (instruction.getActivities() != null) {
                Map<String, Object> activities = this.newMultiMap();
                for (Activity activity : instruction.getActivities()) {
                    this.itemStack.pushStacks("/activities[" + activity.getArchetypeNodeId() + "]", activity.getName().getValue());
                    this.putObject(this.className(activity), activity, activities, this.getNodeTag(TAG_ACTIVITIES, (Locatable)activity, activities), this.traverse(activity, TAG_DESCRIPTION));
                    this.itemStack.popStacks();
                }
                this.putObject(this.className(instruction), instruction, ltree, TAG_ACTIVITIES, activities);
            }
            if (instruction.getName() != null) {
                this.encodeNodeMetaData(ltree, (Locatable)instruction);
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof Action) {
            IsmTransition ismTransition;
            Map<String, Object> description;
            Map<String, Object> protocol;
            Map<String, Object> ltree = this.newPathMap();
            Action action = (Action)item;
            boolean hasActiveContent = false;
            if (action.getProtocol() != null && (protocol = this.traverse(action.getProtocol(), TAG_PROTOCOL)) != null) {
                this.putObject(this.className(action), action, ltree, this.getNodeTag(TAG_PROTOCOL, (Locatable)action.getProtocol(), ltree), this.traverse(action.getProtocol(), TAG_PROTOCOL));
                hasActiveContent = true;
            }
            if (action.getDescription() != null && (description = this.traverse(action.getDescription(), TAG_DESCRIPTION)) != null) {
                this.putObject(this.className(action), action, ltree, this.getNodeTag(TAG_DESCRIPTION, (Locatable)action.getDescription(), ltree), this.traverse(action.getDescription(), TAG_DESCRIPTION));
                hasActiveContent = true;
            }
            if (action.getWorkflowId() != null) {
                this.encodeNodeAttribute(ltree, TAG_WORKFLOW_ID, action.getWorkflowId(), action.getName());
            }
            if (action.getGuidelineId() != null) {
                this.encodeNodeAttribute(ltree, TAG_GUIDELINE_ID, action.getGuidelineId(), action.getName());
            }
            if (action.getTime() != null && (this.allElements || !action.getTime().equals((Object)new DvDateTime()))) {
                this.encodeNodeAttribute(ltree, TAG_TIME, action.getTime(), action.getName());
            }
            if (action.getInstructionDetails() != null) {
                InstructionDetails instructionDetails = action.getInstructionDetails();
                this.encodeNodeAttribute(ltree, "/instruction_details/action_id", instructionDetails.getActivityId(), action.getName());
                this.encodeNodeAttribute(ltree, "/instruction_details/instruction_id", instructionDetails.getInstructionId(), action.getName());
            }
            if (action.getIsmTransition() != null && (ismTransition = action.getIsmTransition()) != null && ismTransition.getCareflowStep() != null && (this.allElements || !ismTransition.getCareflowStep().getValue().equals("DUMMY"))) {
                if (ismTransition.getCurrentState() != null) {
                    this.encodeNodeAttribute(ltree, "/ism_transition/current_state", ismTransition.getCurrentState(), action.getName());
                }
                if (ismTransition.getTransition() != null) {
                    this.encodeNodeAttribute(ltree, "/ism_transition/transition", ismTransition.getTransition(), action.getName());
                }
                if (ismTransition.getCareflowStep() != null) {
                    this.encodeNodeAttribute(ltree, "/ism_transition/careflow_step", ismTransition.getCareflowStep(), action.getName());
                }
            }
            if (action.getName() != null) {
                this.encodeNodeMetaData(ltree, (Locatable)action);
            }
            retmap = hasActiveContent ? ltree : null;
        } else if (item instanceof Section) {
            Map<String, Object> ltree = this.newMultiMap();
            for (ContentItem contentItem : ((Section)item).getItems()) {
                this.putObject(this.className(item), contentItem, ltree, this.getNodeTag(TAG_ITEMS, (Locatable)contentItem, ltree), this.traverse(contentItem, TAG_ITEMS));
            }
            Section section = (Section)item;
            if (section.getName() != null) {
                this.encodeNodeAttribute(ltree, null, null, section.getName());
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof AdminEntry) {
            AdminEntry adminEntry = (AdminEntry)item;
            Map<String, Object> ltree = this.newPathMap();
            if (adminEntry.getName() != null) {
                this.encodeNodeMetaData(ltree, (Locatable)adminEntry);
            }
            if (adminEntry.getData() != null) {
                this.putObject(this.className(adminEntry), adminEntry, ltree, this.getNodeTag(TAG_DATA, (Locatable)adminEntry.getData(), ltree), this.traverse(adminEntry.getData(), TAG_DATA));
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof GenericEntry) {
            Map<String, Object> ltree = this.newPathMap();
            GenericEntry genericEntry = (GenericEntry)item;
            if (genericEntry.getName() != null) {
                this.encodeNodeMetaData(ltree, (Locatable)genericEntry);
            }
            this.putObject(this.className(genericEntry), genericEntry, ltree, this.getNodeTag(TAG_DATA, (Locatable)genericEntry.getData(), ltree), this.traverse((ItemStructure)genericEntry.getData(), TAG_DATA));
            retmap = ltree.size() > 0 ? ltree : null;
        } else {
            this.log.warn("This item is not handled!" + item.getNameAsString());
        }
        if (item instanceof Entry) {
            this.putEntryMetaData(retmap, (Entry)item);
        }
        this.itemStack.popStacks();
        return retmap;
    }

    private void putEntryMetaData(Map<String, Object> map, Entry item) {
        List participations = item.getOtherParticipations();
        if (participations != null && !participations.isEmpty()) {
            ArrayList<Map<String, Object>> sublist = new ArrayList<Map<String, Object>>();
            for (Participation participation : participations) {
                sublist.add(this.mapRmObjectAttributes((RMObject)participation, "other participation"));
            }
            map.put(TAG_OTHER_PARTICIPATIONS, sublist);
        }
        if (item.getProvider() != null) {
            PartyIdentified provider = (PartyIdentified)item.getProvider();
            map.put(TAG_PROVIDER, this.mapRmObjectAttributes((RMObject)provider, provider.getName(), TAG_PROVIDER));
        }
    }

    private Map<String, Object> traverse(Activity activity, String tag) {
        if (activity == null) {
            return null;
        }
        this.log.debug("traverse activity:" + activity);
        if (activity.getDescription() == null) {
            throw new IllegalArgumentException("Invalid activity, no description found:" + activity.getNameAsString());
        }
        Map<String, Object> ltree = this.newPathMap();
        if (activity.getTiming() != null && (this.allElements || !activity.getTiming().equals((Object)new DvParsable()))) {
            this.encodeNodeAttribute(ltree, TAG_TIMING, activity.getTiming(), null);
        }
        this.encodeNodeAttribute(ltree, TAG_NAME, null, activity.getName());
        this.itemStack.pushStacks(tag + "[" + activity.getDescription().getArchetypeNodeId() + "]", activity.getDescription().getName().getValue());
        this.log.debug(this.itemStack.pathStackDump() + "/description[" + activity.getArchetypeNodeId() + "]=" + activity.getDescription().toString());
        this.putObject(this.className(activity), activity, ltree, this.getNodeTag(TAG_DESCRIPTION, (Locatable)activity.getDescription(), ltree), this.traverse(activity.getDescription(), null));
        if (activity.getActionArchetypeId() != null) {
            this.putObject(this.className(activity.getActionArchetypeId()), activity, ltree, TAG_ACTION_ARCHETYPE_ID, activity.getActionArchetypeId().trim());
        }
        this.itemStack.popStacks();
        return ltree;
    }

    private Map<String, Object> traverse(History<?> item, String tag) {
        if (item == null) {
            return null;
        }
        this.log.debug("traverse history:" + item);
        this.itemStack.pushStacks(tag + "[" + item.getArchetypeNodeId() + "]", item.getName().getValue());
        Map<String, Object> ltree = this.newPathMap();
        History<?> history = item;
        if (history.getName() != null) {
            this.encodeNodeMetaData(ltree, (Locatable)history);
        }
        this.log.debug(this.itemStack.pathStackDump() + "/origin[" + item.getArchetypeNodeId() + "]=" + item.getOrigin());
        if (item.getOrigin() != null && (this.allElements || !item.getOrigin().equals((Object)new DvDateTime()))) {
            this.encodeNodeAttribute(ltree, TAG_ORIGIN, item.getOrigin(), item.getName());
        }
        if (item.getSummary() != null) {
            this.putObject(this.className(history), history, ltree, this.getNodeTag(TAG_SUMMARY, (Locatable)item, ltree), this.traverse(item.getSummary(), TAG_SUMMARY));
        }
        if (item.getEvents() != null) {
            Map<String, Object> eventtree = this.newMultiMap();
            for (Event event : item.getEvents()) {
                this.itemStack.pushStacks("/events[" + event.getArchetypeNodeId() + "]", event.getName().getValue());
                Map<String, Object> subtree = this.newPathMap();
                this.log.debug(this.itemStack.pathStackDump() + "/time[" + event.getArchetypeNodeId() + "]=" + event.getTime());
                if (event instanceof IntervalEvent) {
                    IntervalEvent intervalEvent = (IntervalEvent)event;
                    if (intervalEvent.getWidth() != null) {
                        this.encodeNodeAttribute(subtree, TAG_WIDTH, intervalEvent.getWidth(), event.getName());
                    }
                    if (intervalEvent.getMathFunction() != null) {
                        this.encodeNodeAttribute(subtree, TAG_MATH_FUNCTION, intervalEvent.getMathFunction(), event.getName());
                    }
                }
                if (event.getTime() != null && (!this.allElements || event.getTime().equals((Object)new DvDateTime()))) {
                    this.encodeNodeAttribute(subtree, TAG_TIME, event.getTime(), event.getName());
                }
                if (event.getData() != null) {
                    this.putObject(this.className(event), event, subtree, this.getNodeTag(TAG_DATA, (Locatable)event.getData(), subtree), this.traverse(event.getData(), TAG_DATA));
                }
                if (event.getState() != null) {
                    this.putObject(this.className(event), event, subtree, this.getNodeTag(TAG_STATE, (Locatable)event.getState(), subtree), this.traverse(event.getState(), TAG_STATE));
                }
                this.itemStack.popStacks();
                this.putObject(null, event, eventtree, this.getNodeTag(TAG_EVENTS, (Locatable)event, eventtree), subtree);
            }
            this.putObject(History.class.getSimpleName(), history, ltree, this.getNodeTag(TAG_EVENTS, null, ltree), eventtree);
        }
        this.itemStack.popStacks();
        return ltree;
    }

    private void compactEntry(Object node, Map<String, Object> target, String key, Map<String, Object> entry) {
        if (entry != null) {
            if (entry.keySet().size() == 1 && entry.get(TAG_VALUE) != null) {
                Object o = entry.get(TAG_VALUE);
                this.putObject(null, null, target, key, o);
            } else {
                this.putObject(this.className(node), null, target, key, entry);
            }
        }
    }

    private Map<String, Object> traverse(ItemStructure item, String uppertag) {
        Map<String, Object> retmap = null;
        this.log.debug("traverse itemstructure:" + item);
        if (item == null) {
            return null;
        }
        if (uppertag != null) {
            this.itemStack.pushStacks(uppertag + "[" + item.getArchetypeNodeId() + "]", item.getNameAsString());
        }
        if (item instanceof ItemSingle) {
            Map<String, Object> ltree = this.newPathMap();
            ItemSingle itemSingle = (ItemSingle)item;
            if (itemSingle.getItem() != null) {
                this.compactEntry(itemSingle, ltree, this.getNodeTag(TAG_ITEMS, (Locatable)itemSingle, ltree), this.traverse((Item)itemSingle.getItem(), TAG_ITEMS));
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof ItemList) {
            Map<String, Object> ltree = this.newMultiMap();
            ItemList list = (ItemList)item;
            if (list.getItems() != null) {
                for (Item listItem : list.getItems()) {
                    if (ltree.containsKey(this.extractNodeTag(TAG_ITEMS, (Locatable)item, ltree))) {
                        this.log.warn("ItemList: Overwriting entry for key:/items[" + item.getArchetypeNodeId() + "]");
                    }
                    this.compactEntry(listItem, ltree, this.getNodeTag(TAG_ITEMS, (Locatable)listItem, ltree), this.traverse(listItem, TAG_ITEMS));
                }
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof ItemTree) {
            Map<String, Object> ltree = this.newMultiMap();
            ItemTree tree = (ItemTree)item;
            if (tree.getItems() != null) {
                for (Item subItem : tree.getItems()) {
                    if (ltree.containsKey(this.extractNodeTag(TAG_ITEMS, (Locatable)item, ltree))) {
                        this.log.warn("ItemTree: Overwriting entry for key:/items[" + item.getArchetypeNodeId() + "]");
                    }
                    this.compactEntry(subItem, ltree, this.getNodeTag(TAG_ITEMS, (Locatable)subItem, ltree), this.traverse(subItem, TAG_ITEMS));
                }
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof ItemTable) {
            Map<String, Object> ltree = this.newMultiMap();
            ItemTable table = (ItemTable)item;
            if (table.getName() != null) {
                this.putObject(this.className(table.getName()), null, ltree, TAG_NAME, this.mapName(table.getName()));
            }
            if (table.getRows() != null) {
                for (Item subItem : table.getRows()) {
                    if (ltree.containsKey(this.getNodeTag(TAG_ITEMS, (Locatable)item, ltree))) {
                        this.log.warn("ItemTable: Overwriting entry for key:/items[" + item.getArchetypeNodeId() + "]");
                    }
                    this.compactEntry(subItem, ltree, this.getNodeTag(TAG_ITEMS, (Locatable)subItem, ltree), this.traverse(subItem, TAG_ITEMS));
                }
            }
            retmap = ltree.size() > 0 ? ltree : null;
        }
        if (uppertag != null) {
            this.itemStack.popStacks();
        }
        if (retmap != null && retmap.containsKey(TAG_CLASS)) {
            retmap.remove(TAG_CLASS);
        }
        if (retmap != null) {
            retmap.put(TAG_CLASS, this.className(item));
        }
        return retmap;
    }

    private String getCompositeClassName(DataValue dataValue) {
        String classname = this.className(dataValue);
        if ("DvInterval".equals(classname)) {
            String upperClassName;
            DvInterval interval = (DvInterval)dataValue;
            String lowerClassName = this.className(interval.getLower());
            if (!lowerClassName.equals(upperClassName = this.className(interval.getUpper()))) {
                throw new IllegalArgumentException("Lower and Upper classnames do not match:" + lowerClassName + " vs." + upperClassName);
            }
            return classname + "<" + lowerClassName + ">";
        }
        return classname;
    }

    private Map<String, Object> setElementAttributesMap(Element element) {
        Map<String, Object> ltree = this.newPathMap();
        if (element.getName().getValue().startsWith(INITIAL_DUMMY_PREFIX)) {
            if (this.allElements) {
                DvText elementName = element.getName();
                elementName.setValue(elementName.getValue().substring(INITIAL_DUMMY_PREFIX.length()));
                element.setName(elementName);
            } else {
                return ltree;
            }
        }
        if (element.getValue() != null && !element.getValue().toString().isEmpty()) {
            this.log.debug(this.itemStack.pathStackDump() + "=" + element.getValue());
            Map<String, Object> valuemap = this.newPathMap();
            if (element.getName() != null) {
                this.putObject(null, element, valuemap, TAG_NAME, this.mapName(element.getName()));
            }
            if (element.getValue() != null && !element.getValue().toString().isEmpty()) {
                this.putObject(this.getCompositeClassName(element.getValue()), element, valuemap, TAG_VALUE, element.getValue());
            }
            this.encodePathItem(valuemap, null);
            ltree.put(TAG_VALUE, valuemap);
        }
        return ltree;
    }

    private String className(Object object) {
        return object.getClass().getSimpleName();
    }

    private Map<String, Object> traverse(Item item, String tag) {
        Map<String, Object> retmap = null;
        this.log.debug("traverse item:" + item);
        if (item == null) {
            return null;
        }
        if (item instanceof Element) {
            this.itemStack.pushStacks(tag + "[" + item.getArchetypeNodeId() + "]", null);
            retmap = this.setElementAttributesMap((Element)item);
            this.itemStack.popStacks();
        } else if (item instanceof Cluster) {
            Map<String, Object> ltree = this.newMultiMap();
            this.itemStack.pushStacks(tag + "[" + item.getArchetypeNodeId() + "]", item.getNameAsString());
            Cluster cluster = (Cluster)item;
            boolean hasContent = false;
            if (cluster.getItems() != null) {
                for (Object itemInList : cluster.getItems()) {
                    if (itemInList instanceof Item) {
                        Item clusterItem = (Item)itemInList;
                        Map<String, Object> clusterItems = this.traverse(clusterItem, TAG_ITEMS);
                        if (clusterItems == null) continue;
                        if (clusterItems.containsKey(TAG_CLASS)) {
                            clusterItems.put(TAG_CLASS, item.getClass().getSimpleName());
                        }
                        ltree.put(this.getNodeTag(TAG_ITEMS, (Locatable)clusterItem, ltree), clusterItems.getOrDefault(TAG_VALUE, clusterItems));
                        continue;
                    }
                    throw new IllegalArgumentException("Found non item in cluster");
                }
                if (ltree.size() > 0) {
                    hasContent = true;
                }
                if (cluster.getName() != null) {
                    ltree.put(TAG_NAME, this.mapName(item.getName()));
                }
                if (!ltree.containsKey(TAG_CLASS)) {
                    ltree.put(TAG_CLASS, Cluster.class.getSimpleName());
                }
            }
            retmap = hasContent ? ltree : null;
            this.itemStack.popStacks();
        }
        return retmap;
    }

    public String dbEncode(RMObject rmObject) {
        Map<String, Object> stringObjectMap;
        if (rmObject instanceof Composition) {
            stringObjectMap = this.process((Composition)rmObject);
        } else if (rmObject instanceof Item) {
            stringObjectMap = this.traverse((Item)rmObject, TAG_ITEMS);
        } else if (rmObject instanceof ItemStructure) {
            stringObjectMap = this.traverse((ItemStructure)rmObject, TAG_ITEMS);
        } else {
            throw new MarshalException(String.format("Class %s not supported ", rmObject.getClass()), null);
        }
        GsonBuilder builder = EncodeUtilArchie.getGsonBuilderInstance();
        Gson gson = builder.setPrettyPrinting().create();
        return gson.toJson(stringObjectMap);
    }

    public Map<String, String> getLtreeMap() {
        return this.itemStack.getLtreeMap();
    }

    public static enum WalkerOutputMode {
        PATH,
        NAMED,
        EXPANDED,
        RAW;

    }
}

