/*
 * Copyright (c) 2019 Vitasystems GmbH and Hannover Medical School.
 *
 * This file is part of project EHRbase
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw;

import com.google.gson.internal.LinkedTreeMap;
import org.ehrbase.serialisation.CompositionSerializer;

import java.util.ArrayList;

/**
 * Created by christian on 3/12/2018.
 */
public class ArrayChildren {

    ArrayList arrayList;

    public ArrayChildren(ArrayList value) {
        this.arrayList = value;
    }

    public boolean hasElement() {
        for (Object entry : arrayList) {
            if (entry instanceof LinkedTreeMap) {
                LinkedTreeMap itemMap = (LinkedTreeMap) entry;
                if (itemMap.containsKey(CompositionSerializer.TAG_PATH))
                    return true;
            }
        }
        return false;
    }
}
