/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ehrbase.ehr.encode.wrappers.json.writer.translator_db2raw.NodeId;

public class Children {
    LinkedTreeMap<String, Object> linkedTreeMap;

    public Children(LinkedTreeMap<String, Object> linkedTreeMap) {
        this.linkedTreeMap = linkedTreeMap;
    }

    public boolean isItemsOnly() {
        boolean isItems = true;
        for (String key : this.linkedTreeMap.keySet()) {
            if (key.startsWith("/items") || key.startsWith("/name") || key.equals("archetype_node_id") || key.equals("_type") || key.equals("/$CLASS$")) continue;
            isItems = false;
        }
        return isItems;
    }

    public int itemsCount() {
        int count = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/items")) continue;
            ++count;
        }
        return count;
    }

    public int eventsCount() {
        int count = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/events")) continue;
            ++count;
        }
        return count;
    }

    public boolean isMultiContent() {
        int contents = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/content")) continue;
            ++contents;
        }
        return contents > 1;
    }

    public int contentCount() {
        int contents = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/content")) continue;
            ++contents;
        }
        return contents;
    }

    public boolean isMultiData() {
        int data = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/data")) continue;
            ++data;
        }
        return data > 1;
    }

    public boolean isEvents() {
        int isEvents = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/events")) continue;
            ++isEvents;
        }
        return isEvents > 1;
    }

    public String type() {
        if (this.linkedTreeMap.containsKey((Object)"/$CLASS$")) {
            return (String)this.linkedTreeMap.get((Object)"/$CLASS$");
        }
        return "*UNDEF*";
    }

    public ArrayList items() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/items")) continue;
            String archetypeNodeId = new NodeId(key).predicate();
            Object e = this.linkedTreeMap.get((Object)key);
            if (List.class.isAssignableFrom(e.getClass())) {
                ((List)e).stream().filter(o -> Map.class.isAssignableFrom(o.getClass())).forEach(m -> ((Map)m).put("archetype_node_id", archetypeNodeId));
            } else if (Map.class.isAssignableFrom(e.getClass())) {
                ((Map)e).put("archetype_node_id", archetypeNodeId);
            }
            items.add(e);
        }
        return items;
    }

    public ArrayList events() {
        ArrayList<Object> events = new ArrayList<Object>();
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/events")) continue;
            events.add(this.linkedTreeMap.get((Object)key));
        }
        return events;
    }

    public ArrayList contents() {
        ArrayList<Object> contents = new ArrayList<Object>();
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/content")) continue;
            contents.add(this.linkedTreeMap.get((Object)key));
        }
        return contents;
    }

    public LinkedTreeMap removeContents() {
        String key = (String)this.linkedTreeMap.keySet().iterator().next();
        while (key != null) {
            if (key.startsWith("/content")) {
                this.linkedTreeMap.remove((Object)key);
            }
            if (this.linkedTreeMap.keySet().size() == 0) break;
            key = (String)this.linkedTreeMap.keySet().iterator().next();
        }
        return this.linkedTreeMap;
    }
}

