/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.rm.ehr.EhrStatus;
import java.io.IOException;
import org.ehrbase.serialisation.OpenEHRTypeNaming;

public class JacksonUtil {
    private static volatile ObjectMapper objectMapper;

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            JacksonUtil.configureObjectMapper(objectMapper, true);
        }
        return objectMapper;
    }

    public static void configureObjectMapper(ObjectMapper objectMapper, boolean withCustomizers) {
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.enable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        objectMapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.enable(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.enable(new MapperFeature[]{MapperFeature.USE_BASE_TYPE_AS_DEFAULT_IMPL});
        StdTypeResolverBuilder typeResolverBuilder = new ArchieTypeResolverBuilder().init(JsonTypeInfo.Id.NAME, (TypeIdResolver)new OpenEHRTypeNaming()).typeProperty("_type").typeIdVisibility(true).inclusion(JsonTypeInfo.As.PROPERTY);
        objectMapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
                if (propertyName.equalsIgnoreCase("_type")) {
                    return true;
                }
                return super.handleUnknownProperty(ctxt, p, deserializer, beanOrClass, propertyName);
            }
        });
        objectMapper.setDefaultTyping((TypeResolverBuilder)typeResolverBuilder);
        if (withCustomizers) {
            SimpleModule module = new SimpleModule();
            module.addDeserializer(EhrStatus.class, (JsonDeserializer)new EhrStatusDeserializer(EhrStatus.class));
            objectMapper.registerModule((Module)module);
        }
    }

    public static class EhrStatusDeserializer
    extends StdDeserializer<EhrStatus> {
        protected EhrStatusDeserializer(Class<?> vc) {
            super(vc);
        }

        public EhrStatus deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String IS_MODIFIABLE = "is_modifiable";
            String IS_QUERYABLE = "is_queryable";
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node.has("is_modifiable")) {
                if (!node.get("is_modifiable").isBoolean()) {
                    ((ObjectNode)node).put("is_modifiable", true);
                }
            } else {
                ((ObjectNode)node).put("is_modifiable", true);
            }
            if (node.has("is_queryable")) {
                if (!node.get("is_queryable").isBoolean()) {
                    ((ObjectNode)node).put("is_queryable", true);
                }
            } else {
                ((ObjectNode)node).put("is_queryable", true);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            JacksonUtil.configureObjectMapper(objectMapper, false);
            return (EhrStatus)objectMapper.readValue(node.toString(), EhrStatus.class);
        }
    }

    static class ArchieTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        public ArchieTypeResolverBuilder() {
            super(ObjectMapper.DefaultTyping.NON_FINAL);
        }

        public boolean useForType(JavaType t) {
            return OpenEHRBase.class.isAssignableFrom(t.getRawClass());
        }
    }
}

