/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.aql.containment.AstContainment;
import org.ehrbase.aql.containment.AtomicContainment;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.containment.ContainmentSet;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.definition.FromEhrDefinition;
import org.ehrbase.aql.definition.FromForeignDataDefinition;
import org.ehrbase.aql.definition.I_FromEntityDefinition;
import org.ehrbase.aql.parser.AqlBaseListener;
import org.ehrbase.aql.parser.AqlParser;

public class QueryCompilerPass1
extends AqlBaseListener {
    private Logger logger = LogManager.getLogger(QueryCompilerPass1.class);
    private static int serial = 0;
    private static int fieldId = 0;
    private IdentifierMapper identifierMapper = new IdentifierMapper();
    private Containment currentContainment = null;
    private AstContainment astContainment = null;
    private Deque<ContainmentSet> containmentStack = new ArrayDeque<ContainmentSet>();
    private ContainmentSet rootContainmentSet;
    private List<ContainmentSet> closedSetList = new ArrayList<ContainmentSet>();
    private int setLevel = 0;
    private Boolean inContainedSet = false;
    private int containLevel = 0;

    @Override
    public void exitFromEHR(AqlParser.FromEHRContext context) {
        FromEhrDefinition fromEhrDefinition = new FromEhrDefinition();
        if (context.IDENTIFIER() != null) {
            this.visitFromExpressionChildren(fromEhrDefinition, context.children);
            String identifier = context.IDENTIFIER().getText();
            fromEhrDefinition.setIdentifier(identifier);
            if (!fromEhrDefinition.getEhrPredicates().isEmpty()) {
                fromEhrDefinition.getEhrPredicates().get(0).setIdentifier(identifier);
                this.identifierMapper.add(fromEhrDefinition.getEhrPredicates().get(0));
            } else {
                this.identifierMapper.add(new FromEhrDefinition.EhrPredicate(identifier));
            }
        }
        if (context.EHR() != null) {
            fromEhrDefinition.setIsEHR(true);
        }
        this.logger.debug("FromEHR");
    }

    private void visitFromExpressionChildren(I_FromEntityDefinition fromEntityDefinition, List<ParseTree> children) {
        if (children.isEmpty()) {
            return;
        }
        for (ParseTree node : children) {
            AqlParser.StandardPredicateContext equalityContext;
            if (node.getText().equals("[") || node.getText().equals("]") || !(node instanceof AqlParser.StandardPredicateContext) || (equalityContext = (AqlParser.StandardPredicateContext)node).getChildCount() <= 0 || equalityContext.getChildCount() != 3) continue;
            AqlParser.PredicateExprContext predicateExprContext = (AqlParser.PredicateExprContext)equalityContext.getChild(1);
            AqlParser.PredicateAndContext predicateAndContext = (AqlParser.PredicateAndContext)predicateExprContext.getChild(0);
            AqlParser.PredicateEqualityContext predicateEqualityContext = (AqlParser.PredicateEqualityContext)predicateAndContext.getChild(0);
            if (predicateEqualityContext.getChildCount() != 3) {
                throw new IllegalArgumentException("Could not handle predicateEqualityContext:" + predicateAndContext.getText());
            }
            fromEntityDefinition.add(predicateEqualityContext.getChild(0).getText(), predicateEqualityContext.getChild(2).getText(), predicateEqualityContext.getChild(1).getText());
        }
    }

    private void visitJoinExpressionChildren(I_FromEntityDefinition fromEntityDefinition, List<ParseTree> children) {
        if (children.isEmpty()) {
            return;
        }
        for (ParseTree node : children) {
            AqlParser.JoinPredicateContext joinContext;
            if (node.getText().equals("[") || node.getText().equals("]") || !(node instanceof AqlParser.JoinPredicateContext) || (joinContext = (AqlParser.JoinPredicateContext)node).getChildCount() <= 0 || joinContext.getChildCount() != 4) continue;
            AqlParser.PredicateEqualityContext predicateEqualityContext = (AqlParser.PredicateEqualityContext)joinContext.getChild(2);
            if (predicateEqualityContext.getChildCount() != 3) {
                throw new IllegalArgumentException("Could not handle predicateEqualityContext:" + predicateEqualityContext.getText());
            }
            fromEntityDefinition.add(predicateEqualityContext.getChild(0).getText(), predicateEqualityContext.getChild(2).getText(), predicateEqualityContext.getChild(1).getText());
        }
    }

    @Override
    public void exitFromForeignData(AqlParser.FromForeignDataContext context) {
        FromForeignDataDefinition fromForeignDataDefinition = new FromForeignDataDefinition(context.getChild(0).getText());
        if (context.IDENTIFIER() != null) {
            this.visitJoinExpressionChildren(fromForeignDataDefinition, context.children);
            String identifier = context.IDENTIFIER().getText();
            fromForeignDataDefinition.setIdentifier(identifier);
            if (!fromForeignDataDefinition.getFDPredicates().isEmpty()) {
                fromForeignDataDefinition.getFDPredicates().get(0).setIdentifier(identifier);
                this.identifierMapper.add(fromForeignDataDefinition.getFDPredicates().get(0));
            } else {
                this.identifierMapper.add(new FromForeignDataDefinition.NodePredicate(identifier));
            }
        }
        this.logger.debug("exitFromForeignData");
    }

    @Override
    public void exitStandardPredicate(AqlParser.StandardPredicateContext standardPredicateContext) {
        this.logger.debug("StandardPredicate");
    }

    @Override
    public void enterFromEHR(AqlParser.FromEHRContext context) {
        this.logger.debug("ENTER FromEHR");
    }

    @Override
    public void exitArchetypedClassExpr(AqlParser.ArchetypedClassExprContext archetypedClassExprContext) {
        AstContainment astEnclosing;
        String className = archetypedClassExprContext.IDENTIFIER(0).getSymbol().getText().toUpperCase();
        String symbol = archetypedClassExprContext.IDENTIFIER(1).getSymbol().getText();
        String archetypeId = archetypedClassExprContext.ARCHETYPEID().getText();
        Containment containment = new Containment(className, symbol, archetypeId);
        this.identifierMapper.add(containment);
        if (this.inContainedSet.booleanValue() && this.containLevel > 0) {
            containment.setEnclosingContainment(this.currentContainment);
            this.inContainedSet = false;
        } else {
            containment.setEnclosingContainment(this.currentContainment.getEnclosingContainment());
        }
        this.astContainment = new AtomicContainment(containment, this.astContainment);
        if (this.astContainment.getEnclosing() != null && (astEnclosing = this.astContainment.getEnclosing()) instanceof AtomicContainment) {
            ((AtomicContainment)astEnclosing).setChild(this.astContainment);
        }
        this.currentContainment = this.addContainment(containment);
        this.logger.debug(containment.toString());
        if (this.currentContainment.getEnclosingContainment() != null) {
            this.logger.debug("<-----" + this.currentContainment.getEnclosingContainment().toString());
        }
    }

    @Override
    public void enterContainExpressionBool(AqlParser.ContainExpressionBoolContext containExpressionBoolContext) {
        if (containExpressionBoolContext.OPEN_PAR() != null) {
            ++this.setLevel;
            ContainmentSet containmentSet = new ContainmentSet(serial++, this.currentContainment);
            this.containmentStack.push(containmentSet);
            this.logger.debug("---- START GROUP:" + this.setLevel + " contained in:" + this.currentContainment);
            this.inContainedSet = true;
        }
    }

    @Override
    public void exitContainExpressionBool(AqlParser.ContainExpressionBoolContext containExpressionBoolContext) {
        if (containExpressionBoolContext.CLOSE_PAR() != null) {
            this.logger.debug("---- CLOSING GROUP:" + this.setLevel);
            --this.setLevel;
            if (!this.containmentStack.isEmpty()) {
                ContainmentSet closedContainmentSet = this.containmentStack.pop();
                if (!this.containmentStack.isEmpty()) {
                    closedContainmentSet.setParentSet(this.containmentStack.getFirst());
                } else {
                    closedContainmentSet.setParentSet(this.rootContainmentSet);
                }
                this.closedSetList.add(closedContainmentSet);
            } else if (this.rootContainmentSet != null) {
                this.rootContainmentSet.add(this.astContainment.getContainment());
                this.closedSetList.add(this.rootContainmentSet);
            } else {
                throw new IllegalArgumentException("Invalid condition in boolean expression parsing");
            }
        }
    }

    @Override
    public void exitContainsExpression(AqlParser.ContainsExpressionContext containsExpressionContext) {
        if (this.currentContainment != null) {
            this.currentContainment = this.currentContainment.getEnclosingContainment();
        }
        if (containsExpressionContext.AND() != null || containsExpressionContext.OR() != null || containsExpressionContext.XOR() != null) {
            String operator = containsExpressionContext.AND() != null ? "AND" : (containsExpressionContext.OR() != null ? "OR" : (containsExpressionContext.XOR() != null ? "XOR" : "*undef*"));
            this.logger.debug(operator);
            if (!this.containmentStack.isEmpty()) {
                ContainmentSet current = this.containmentStack.getFirst();
                if (current.size() > 0) {
                    current.setOperator(operator);
                } else {
                    this.logger.debug("Orphan operator:" + operator);
                    if (this.rootContainmentSet == null) {
                        this.rootContainmentSet = new ContainmentSet(serial++, null);
                    }
                    this.rootContainmentSet.add(operator);
                }
            } else if (this.rootContainmentSet != null) {
                this.rootContainmentSet.setOperator(operator);
            }
        }
    }

    @Override
    public void enterContainsExpression(AqlParser.ContainsExpressionContext containsExpressionContext) {
        if (this.currentContainment == null) {
            this.currentContainment = new Containment(null);
        }
    }

    @Override
    public void exitSimpleClassExpr(AqlParser.SimpleClassExprContext simpleClassExprContext) {
        this.logger.debug("from exitSimpleClassExpr: ENTER");
        if (!simpleClassExprContext.IDENTIFIER().isEmpty()) {
            String className = simpleClassExprContext.IDENTIFIER(0).getSymbol().getText().toUpperCase();
            Object symbol = !simpleClassExprContext.IDENTIFIER().isEmpty() && simpleClassExprContext.IDENTIFIER(1) != null ? simpleClassExprContext.IDENTIFIER(1).getSymbol().getText() : className + "_" + ++fieldId;
            Containment containment = new Containment(className, (String)symbol, "");
            if (this.containLevel > 0) {
                containment.setEnclosingContainment(this.currentContainment);
            }
            this.currentContainment = this.addContainment(containment);
            this.identifierMapper.add(this.currentContainment);
            this.logger.debug(containment.toString());
            if (this.currentContainment.getEnclosingContainment() != null) {
                this.logger.debug("<-----" + this.currentContainment.getEnclosingContainment().toString());
            }
            ++this.containLevel;
        }
    }

    @Override
    public void exitContains(AqlParser.ContainsContext containsContext) {
        if (containsContext.CONTAINS() != null) {
            this.logger.debug(containsContext.CONTAINS().getSymbol().getText());
        }
    }

    @Override
    public void enterContains(AqlParser.ContainsContext containsContext) {
        if (containsContext.CONTAINS() != null) {
            this.logger.debug("ENTER:" + containsContext.CONTAINS().getSymbol().getText());
            if (!this.inContainedSet.booleanValue()) {
                this.inContainedSet = true;
                this.containLevel = 0;
            }
        }
    }

    @Override
    public void exitQuery(AqlParser.QueryContext queryContext) {
        this.closedSetList.add(this.rootContainmentSet);
    }

    public List<ContainmentSet> getClosedSetList() {
        return this.closedSetList;
    }

    private Containment addContainment(Containment containment) {
        if (!this.containmentStack.isEmpty()) {
            ContainmentSet containmentSet = this.containmentStack.getFirst();
            containmentSet.add(containment);
        } else if (this.rootContainmentSet != null) {
            this.rootContainmentSet.add(containment);
        } else {
            this.rootContainmentSet = new ContainmentSet(serial++, null);
            this.rootContainmentSet.add(containment);
        }
        if (this.rootContainmentSet == null && this.setLevel == 0) {
            this.rootContainmentSet = new ContainmentSet(serial++, null);
            this.rootContainmentSet.add(containment);
        }
        ++this.containLevel;
        return containment;
    }

    public IdentifierMapper getIdentifierMapper() {
        return this.identifierMapper;
    }
}

