/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Random;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.aql.compiler.OrderAttribute;
import org.ehrbase.aql.compiler.TopAttributes;
import org.ehrbase.aql.definition.ExtensionDefinition;
import org.ehrbase.aql.definition.FuncParameter;
import org.ehrbase.aql.definition.FuncParameterType;
import org.ehrbase.aql.definition.FunctionDefinition;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.IdentifiedPathVariable;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.parser.AqlBaseListener;
import org.ehrbase.aql.parser.AqlParser;

public class QueryCompilerPass2
extends AqlBaseListener {
    private Logger logger = LogManager.getLogger(QueryCompilerPass2.class);
    private Deque<I_VariableDefinition> variableStack = new ArrayDeque<I_VariableDefinition>();
    private Deque<OrderAttribute> orderAttributes = null;
    private Integer limitAttribute = null;
    private Integer offsetAttribute = null;
    private TopAttributes topAttributes = null;

    @Override
    public void exitObjectPath(AqlParser.ObjectPathContext objectPathContext) {
        this.logger.debug("Object Path->");
    }

    @Override
    public void exitSelectExpr(AqlParser.SelectExprContext selectExprContext) {
        boolean isDistinct = false;
        AqlParser.IdentifiedPathContext identifiedPathContext = selectExprContext.identifiedPath();
        if (selectExprContext.DISTINCT() != null) {
            isDistinct = true;
        }
        if (identifiedPathContext != null) {
            VariableDefinition variableDefinition = new IdentifiedPathVariable(identifiedPathContext, selectExprContext, isDistinct).definition();
            this.pushVariableDefinition(variableDefinition);
        } else if (selectExprContext.stdExpression() != null) {
            String alias;
            this.logger.debug("Found standard expression");
            if (selectExprContext.stdExpression().function() != null) {
                this.logger.debug("Found function");
                AqlParser.FunctionContext functionContext = selectExprContext.stdExpression().function();
                String name = functionContext.FUNCTION_IDENTIFIER().getText();
                ArrayList<FuncParameter> parameters = new ArrayList<FuncParameter>();
                for (ParseTree pathTree : functionContext.children) {
                    if (pathTree instanceof AqlParser.IdentifiedPathContext) {
                        AqlParser.IdentifiedPathContext pathContext = (AqlParser.IdentifiedPathContext)pathTree;
                        VariableDefinition variableDefinition = new IdentifiedPathVariable(pathContext, selectExprContext, false).definition();
                        this.pushVariableDefinition(variableDefinition);
                        parameters.add(new FuncParameter(FuncParameterType.VARIABLE, variableDefinition.getAlias()));
                        continue;
                    }
                    if (pathTree instanceof AqlParser.OperandContext) {
                        parameters.add(new FuncParameter(FuncParameterType.OPERAND, pathTree.getText()));
                        continue;
                    }
                    if (!(pathTree instanceof TerminalNode)) continue;
                    parameters.add(new FuncParameter(FuncParameterType.IDENTIFIER, pathTree.getText()));
                }
                alias = selectExprContext.IDENTIFIER() == null ? name : selectExprContext.IDENTIFIER().getText();
                String path = functionContext.getText();
                FunctionDefinition definition = new FunctionDefinition(name, alias, path, parameters);
                this.pushVariableDefinition(definition);
            }
            if (selectExprContext.stdExpression().extension() != null) {
                this.logger.debug("Found extension");
                AqlParser.ExtensionContext extensionContext = selectExprContext.stdExpression().extension();
                String context = extensionContext.getChild(2).getText();
                String parsableExpression = extensionContext.getChild(4).getText();
                alias = selectExprContext.IDENTIFIER() == null ? "_alias_" + Math.abs(new Random().nextLong()) : selectExprContext.IDENTIFIER().getText();
                ExtensionDefinition definition = new ExtensionDefinition(context, parsableExpression, alias);
                this.pushVariableDefinition(definition);
            }
        } else {
            throw new IllegalArgumentException("Could not interpret select context");
        }
    }

    private void pushVariableDefinition(I_VariableDefinition variableDefinition) {
        this.isUnique(variableDefinition);
        this.variableStack.push(variableDefinition);
    }

    private void isUnique(I_VariableDefinition variableDefinition) {
        if (variableDefinition.isFunction()) {
            return;
        }
        String alias = variableDefinition.getAlias();
        for (I_VariableDefinition stackedVariableDefinition : this.variableStack) {
            if (StringUtils.isEmpty((CharSequence)stackedVariableDefinition.getAlias()) || !stackedVariableDefinition.getAlias().equals(alias)) continue;
            throw new IllegalArgumentException("Duplicated alias detected:" + alias);
        }
    }

    @Override
    public void exitTopExpr(AqlParser.TopExprContext context) {
        Integer window = null;
        TopAttributes.TopDirection direction = null;
        if (context.TOP() != null) {
            window = new Integer(context.INTEGER().getText());
            if (context.BACKWARD() != null) {
                direction = TopAttributes.TopDirection.BACKWARD;
            } else if (context.FORWARD() != null) {
                direction = TopAttributes.TopDirection.FORWARD;
            }
        }
        this.topAttributes = new TopAttributes(window, direction);
    }

    @Override
    public void exitOrderBySeq(AqlParser.OrderBySeqContext context) {
        if (this.orderAttributes == null) {
            this.orderAttributes = new ArrayDeque<OrderAttribute>();
        }
        for (ParseTree tree : context.children) {
            if (!(tree instanceof AqlParser.OrderByExprContext)) continue;
            AqlParser.OrderByExprContext context1 = (AqlParser.OrderByExprContext)tree;
            AqlParser.IdentifiedPathContext identifiedPathContext = context1.identifiedPath();
            String path = identifiedPathContext.objectPath() != null ? identifiedPathContext.objectPath().getText() : null;
            String identifier = identifiedPathContext.IDENTIFIER().getText();
            OrderAttribute orderAttribute = path == null ? new OrderAttribute(new VariableDefinition(path, identifier, null, false)) : new OrderAttribute(new VariableDefinition(path, null, identifier, false));
            if (context1.ASC() != null || context1.ASCENDING() != null) {
                orderAttribute.setDirection(OrderAttribute.OrderDirection.ASC);
            } else if (context1.DESC() != null || context1.DESCENDING() != null) {
                orderAttribute.setDirection(OrderAttribute.OrderDirection.DESC);
            }
            this.orderAttributes.push(orderAttribute);
        }
    }

    @Override
    public void exitOffset(AqlParser.OffsetContext ctx) {
        this.offsetAttribute = new Integer(ctx.INTEGER().getText());
    }

    @Override
    public void exitLimit(AqlParser.LimitContext ctx) {
        this.limitAttribute = new Integer(ctx.INTEGER().getText());
    }

    @Override
    public void exitFunction(AqlParser.FunctionContext functionContext) {
        this.logger.debug("in function");
    }

    public List<I_VariableDefinition> getVariables() {
        return new ArrayList<I_VariableDefinition>(this.variableStack);
    }

    TopAttributes getTopAttributes() {
        return this.topAttributes;
    }

    List<OrderAttribute> getOrderAttributes() {
        if (this.orderAttributes == null) {
            return null;
        }
        return new ArrayList<OrderAttribute>(this.orderAttributes);
    }

    Integer getLimitAttribute() {
        return this.limitAttribute;
    }

    Integer getOffsetAttribute() {
        return this.offsetAttribute;
    }
}

