/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.ehrbase.aql.compiler.OrderAttribute;
import org.ehrbase.aql.compiler.QueryCompilerPass2;
import org.ehrbase.aql.compiler.TopAttributes;
import org.ehrbase.aql.compiler.WhereVisitor;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.definition.FromEhrDefinition;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.sql.binding.VariableDefinitions;

public class Statements {
    private ParseTree parseTree;
    private List<Object> whereClause;
    private List<I_VariableDefinition> variables;
    private TopAttributes topAttributes;
    private List<OrderAttribute> orderAttributes;
    private IdentifierMapper identifierMapper;
    private Integer limitAttribute;
    private Integer offsetAttribute;

    public Statements(ParseTree parseTree, IdentifierMapper identifierMapper) {
        this.parseTree = parseTree;
        this.identifierMapper = identifierMapper;
    }

    public Statements process() {
        QueryCompilerPass2 queryCompilerPass2 = new QueryCompilerPass2();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)queryCompilerPass2, this.parseTree);
        this.variables = queryCompilerPass2.getVariables();
        this.whereClause = this.visitWhere();
        if (this.identifierMapper.hasEhrContainer()) {
            this.appendEhrPredicate(this.identifierMapper.getEhrContainer());
        }
        this.topAttributes = queryCompilerPass2.getTopAttributes();
        this.orderAttributes = queryCompilerPass2.getOrderAttributes();
        this.limitAttribute = queryCompilerPass2.getLimitAttribute();
        this.offsetAttribute = queryCompilerPass2.getOffsetAttribute();
        return this;
    }

    private List visitWhere() {
        WhereVisitor whereVisitor = new WhereVisitor();
        whereVisitor.visit(this.parseTree);
        return whereVisitor.getWhereExpression();
    }

    private void appendEhrPredicate(FromEhrDefinition.EhrPredicate ehrPredicate) {
        if (ehrPredicate == null) {
            return;
        }
        if (!this.whereClause.isEmpty()) {
            this.whereClause.add("and");
        }
        this.whereClause.add(new VariableDefinition(ehrPredicate.getField(), null, ehrPredicate.getIdentifier(), false));
        this.whereClause.add(ehrPredicate.getOperator());
        this.whereClause.add(ehrPredicate.getValue());
    }

    public List getWhereClause() {
        return this.whereClause;
    }

    public VariableDefinitions getVariables() {
        return new VariableDefinitions(this.variables);
    }

    public TopAttributes getTopAttributes() {
        return this.topAttributes;
    }

    public List<OrderAttribute> getOrderAttributes() {
        return this.orderAttributes;
    }

    public Integer getLimitAttribute() {
        return this.limitAttribute;
    }

    public Integer getOffsetAttribute() {
        return this.offsetAttribute;
    }

    public void put(I_VariableDefinition variableDefinition) {
        this.variables.add(variableDefinition);
    }
}

