/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler.tsclient.fhir;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.ArrayList;
import java.util.List;
import org.ehrbase.aql.compiler.tsclient.OpenehrTerminologyServer;
import org.ehrbase.aql.compiler.tsclient.TerminologyServer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class FhirTerminologyServerAdaptorImpl
implements OpenehrTerminologyServer<DvCodedText, String> {
    private String codePath = "$[\"expansion\"][\"contains\"][*][\"code\"]";
    private String systemPath = "$[\"expansion\"][\"contains\"][*][\"system\"]";
    private String displayPath = "$[\"expansion\"][\"contains\"][*][\"display\"]";

    @Override
    @ConfigurationProperties(prefix="terminology_server")
    public List<DvCodedText> expand(String valueSetId) {
        RestTemplate rest = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("accept", "application/fhir+json");
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = rest.exchange(valueSetId, HttpMethod.GET, entity, String.class, new Object[0]);
        String response = (String)responseEntity.getBody();
        DocumentContext jsonContext = JsonPath.parse((String)response);
        List codeList = (List)jsonContext.read(this.codePath, new Predicate[0]);
        List systemList = (List)jsonContext.read(this.systemPath, new Predicate[0]);
        List displayList = (List)jsonContext.read(this.displayPath, new Predicate[0]);
        ArrayList<DvCodedText> expansionList = new ArrayList<DvCodedText>();
        for (int i = 0; i < codeList.size(); ++i) {
            TerminologyId termId = new TerminologyId((String)systemList.get(i));
            CodePhrase codePhrase = new CodePhrase(termId, (String)codeList.get(i));
            DvCodedText codedText = new DvCodedText((String)displayList.get(i), codePhrase);
            expansionList.add(codedText);
        }
        return expansionList;
    }

    @Override
    public DvCodedText lookUp(String conceptId) {
        return null;
    }

    @Override
    public Boolean validate(DvCodedText concept, String valueSetId) {
        return null;
    }

    @Override
    public TerminologyServer.SubsumptionResult subsumes(DvCodedText conceptA, DvCodedText conceptB) {
        return null;
    }
}

