/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.containment;

import org.apache.commons.collections4.set.ListOrderedSet;
import org.ehrbase.aql.containment.Containment;

public class ContainmentSet {
    private int serial;
    private Containment enclosing;
    private ContainmentSet parentSet;
    private ListOrderedSet<Object> containmentList = new ListOrderedSet();
    private int operatorSlot = -1;

    public ContainmentSet(int serial, Containment enclosing) {
        this.serial = serial;
        this.enclosing = enclosing;
    }

    public void add(Containment containment) {
        this.containmentList.add((Object)containment);
    }

    public void add(String operator) {
        this.containmentList.add((Object)OPERATOR.valueOf(operator));
    }

    private boolean isContainmentInList(ListOrderedSet<Object> list, Containment containment) {
        for (Object item : list) {
            if (!(item instanceof Containment) || !((Containment)item).equals(containment)) continue;
            return true;
        }
        return false;
    }

    public void setOperator(String operator) {
        OPERATOR op = OPERATOR.valueOf(operator.trim());
        if (op == null) {
            throw new IllegalArgumentException("Invalid operator value:" + operator);
        }
        if (this.operatorSlot < 0) {
            for (int i = this.containmentList.size() - 1; i >= 0; --i) {
                Object item = this.containmentList.get(i);
                if (!(item instanceof Containment)) continue;
                Containment containment = (Containment)item;
                if (containment.getEnclosingContainment() != null) {
                    Containment enclosing = containment.getEnclosingContainment();
                    if (this.isContainmentInList(this.containmentList, enclosing)) continue;
                    this.operatorSlot = i;
                } else {
                    this.operatorSlot = i;
                }
                break;
            }
        } else {
            --this.operatorSlot;
        }
        if (this.operatorSlot < 0) {
            throw new IllegalArgumentException("Cannot insert operator:" + op);
        }
        this.containmentList.add(this.operatorSlot, (Object)op);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.serial + "|");
        if (this.containmentList.size() > 0) {
            boolean comma = false;
            for (Object item : this.containmentList) {
                if (comma) {
                    sb.append(",");
                }
                comma = true;
                if (item instanceof Containment) {
                    sb.append(item);
                    continue;
                }
                if (item instanceof OPERATOR) {
                    sb.append(item);
                    continue;
                }
                if (item instanceof String) {
                    sb.append(item);
                    continue;
                }
                sb.append("-- Unhandled Item Type --");
            }
        } else {
            sb.append("--EMPTY SET--");
        }
        if (this.parentSet != null) {
            sb.append("<<<IN PARENT#" + this.parentSet.serial);
        } else {
            sb.append("<<< ROOT");
        }
        return sb.toString();
    }

    public int size() {
        return this.containmentList.size();
    }

    public boolean isEmpty() {
        return this.containmentList.isEmpty() && this.enclosing.getSymbol() == null && this.enclosing.getClassName() == null;
    }

    public void setParentSet(ContainmentSet parentSet) {
        this.parentSet = parentSet;
    }

    public ListOrderedSet<Object> getContainmentList() {
        return this.containmentList;
    }

    public ContainmentSet getParentSet() {
        return this.parentSet;
    }

    public Containment getEnclosing() {
        return this.enclosing;
    }

    public static enum OPERATOR {
        AND,
        OR,
        XOR;

    }
}

