/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.sql.binding.ContainBinder;
import org.ehrbase.aql.sql.queryImpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryImpl.JsonbEntryQuery;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;

public class PathResolver {
    private Logger logger = LogManager.getLogger(PathResolver.class);
    private DSLContext context;
    private final IdentifierMapper mapper;
    private Map<String, String> resolveMap = new HashMap<String, String>();

    public PathResolver(DSLContext context, IdentifierMapper mapper) {
        this.context = context;
        this.mapper = mapper;
    }

    static String buildLquery(Containment containment) {
        int depth = 0;
        StringBuilder lquery = new StringBuilder();
        Object archetypeId = containment.getArchetypeId();
        if (((String)archetypeId).isEmpty()) {
            lquery.append(containment.getClassName() + "%");
        } else {
            lquery.append(ContainBinder.labelize((String)archetypeId));
        }
        for (Containment parent = containment.getEnclosingContainment(); parent != null; parent = parent.getEnclosingContainment()) {
            ++depth;
            if (parent.getClassName().equals("COMPOSITION")) {
                lquery.insert(0, "*.");
                break;
            }
            archetypeId = parent.getArchetypeId();
            archetypeId = archetypeId == null || ((String)archetypeId).isEmpty() ? parent.getClassName() + "%" : ContainBinder.labelize((String)archetypeId);
            lquery.insert(0, (String)archetypeId + ".*.");
        }
        return lquery.toString();
    }

    private String lqueryExpression(String identifier) {
        Object containment = this.getMapper().getContainer(identifier);
        if (!(containment instanceof Containment)) {
            throw new IllegalArgumentException("No path found for identifier:" + identifier);
        }
        return PathResolver.buildLquery((Containment)containment);
    }

    public String pathOf(String identifier) {
        return this.getMapper().getPath(identifier);
    }

    public void resolvePaths(String templateId, UUID comp_id) {
        for (String identifier : this.getMapper().identifiers()) {
            try {
                String lquery = this.lqueryExpression(identifier);
                if (lquery.equals("COMPOSITION%")) continue;
                if (!this.resolveMap.containsKey(this.resolveMapKey(templateId, lquery))) {
                    Result records = this.context.select((SelectField)Tables.CONTAINMENT.PATH, (SelectField)Tables.ENTRY.TEMPLATE_ID).from((TableLike)Tables.CONTAINMENT).join((TableLike)Tables.ENTRY).on(Tables.ENTRY.COMPOSITION_ID.eq((Object)comp_id)).where(Tables.CONTAINMENT.COMP_ID.eq((Field)Tables.ENTRY.COMPOSITION_ID)).and(Tables.CONTAINMENT.LABEL + "~ '" + lquery + "'").fetch().into((Field)Tables.CONTAINMENT.PATH, (Field)Tables.ENTRY.TEMPLATE_ID);
                    if (records.isEmpty()) continue;
                    this.resolveMap.put(this.resolveMapKey((String)records.getValue(0, Tables.ENTRY.TEMPLATE_ID.getName()), lquery), (String)records.getValue(0, (Field)Tables.CONTAINMENT.PATH));
                    if (records.isEmpty()) {
                        this.logger.debug("No path found for identifier (query return no records):" + identifier);
                    }
                    if (records.size() > 1) {
                        this.logger.debug("Multiple paths found for identifier, returning first one:" + identifier);
                    }
                    String path = (String)records.getValue(0, (Field)Tables.CONTAINMENT.PATH);
                    this.getMapper().setPath(identifier, path);
                    if (((Containment)this.getMapper().getContainer(identifier)).getClassName().equals("COMPOSITION")) {
                        this.getMapper().setQueryStrategy(identifier, CompositionAttributeQuery.class);
                        continue;
                    }
                    this.getMapper().setQueryStrategy(identifier, JsonbEntryQuery.class);
                    continue;
                }
                String path = this.resolveMap.get(this.resolveMapKey(templateId, lquery));
                this.getMapper().setPath(identifier, path);
                if (((Containment)this.getMapper().getContainer(identifier)).getClassName().equals("COMPOSITION")) {
                    this.getMapper().setQueryStrategy(identifier, CompositionAttributeQuery.class);
                    continue;
                }
                this.getMapper().setQueryStrategy(identifier, JsonbEntryQuery.class);
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("No path for:" + e);
            }
        }
    }

    private String resolveMapKey(String templateId, String lquery) {
        return templateId + "::" + lquery;
    }

    public boolean hasPathExpression() {
        return this.getMapper().hasPathExpression();
    }

    public String rootOf(String identifier) {
        return this.getMapper().getArchetypeId(identifier);
    }

    public String classNameOf(String identifier) {
        return this.getMapper().getClassName(identifier);
    }

    public IdentifierMapper getMapper() {
        return this.mapper;
    }
}

