/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.aql.compiler.Contains;
import org.ehrbase.aql.compiler.Statements;
import org.ehrbase.aql.compiler.TopAttributes;
import org.ehrbase.aql.definition.Variables;
import org.ehrbase.aql.sql.AqlResult;
import org.ehrbase.aql.sql.QuerySteps;
import org.ehrbase.aql.sql.binding.JoinBinder;
import org.ehrbase.aql.sql.binding.LimitBinding;
import org.ehrbase.aql.sql.binding.OrderByField;
import org.ehrbase.aql.sql.binding.SelectBinder;
import org.ehrbase.aql.sql.binding.SuperQuery;
import org.ehrbase.aql.sql.postprocessing.RawJsonTransform;
import org.ehrbase.aql.sql.queryImpl.ContainsSet;
import org.ehrbase.aql.sql.queryImpl.TemplateMetaData;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.service.IntrospectService;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Operator;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;

public class QueryProcessor
extends TemplateMetaData {
    private final DSLContext context;
    private final I_KnowledgeCache knowledgeCache;
    private final Contains contains;
    private Statements statements;
    private final String serverNodeId;
    private final Boolean usePgExtensions;

    public QueryProcessor(DSLContext context, I_KnowledgeCache knowledgeCache, IntrospectService introspectCache, Contains contains, Statements statements, String serverNodeId, boolean usePgExtensions) {
        super(introspectCache);
        this.context = context;
        this.knowledgeCache = knowledgeCache;
        this.contains = contains;
        this.statements = statements;
        this.serverNodeId = serverNodeId;
        this.usePgExtensions = usePgExtensions;
    }

    public AqlResult execute() {
        AqlSelectQuery aqlSelectQuery = this.buildAqlSelectQuery();
        Result<Record> result = this.fetchResultSet((Select<?>)aqlSelectQuery.getSelectQuery(), null);
        if (aqlSelectQuery.isOutputWithJson() && this.knowledgeCache != null) {
            RawJsonTransform.toRawJson(result, aqlSelectQuery.getQuerySteps(), this.knowledgeCache);
        }
        List<List<String>> explainList = this.buildExplain((Select<?>)aqlSelectQuery.getSelectQuery());
        return new AqlResult(result, explainList);
    }

    AqlSelectQuery buildAqlSelectQuery() {
        ContainsSet containsSet = new ContainsSet(this.contains.getContainClause(), this.context);
        Result<?> containmentRecords = containsSet.getInSet();
        HashMap cacheQuery = new HashMap();
        this.statements = new OrderByField(this.statements).merge();
        if (containmentRecords.isEmpty()) {
            SelectQuery falseSelectQuery = this.context.selectQuery();
            falseSelectQuery.addConditions((Condition)DSL.falseCondition());
            return new AqlSelectQuery((SelectQuery<Record>)falseSelectQuery, null, false);
        }
        containmentRecords.forEach(containmentRecord -> cacheQuery.computeIfAbsent((String)containmentRecord.getValue(Tables.ENTRY.TEMPLATE_ID.getName()), templateId -> this.buildQuerySteps((UUID)containmentRecord.getValue(Tables.CONTAINMENT.COMP_ID.getName()), (String)templateId, (String)containmentRecord.getValue("entry_root", String.class))));
        SelectQuery unionSetQuery = this.context.selectQuery();
        boolean first = true;
        for (QuerySteps queryStep : cacheQuery.values()) {
            Condition condition;
            SelectQuery select = queryStep.getSelectQuery();
            if (!queryStep.getTemplateId().equals("*")) {
                select.addConditions(Tables.ENTRY.TEMPLATE_ID.eq((Object)queryStep.getTemplateId()));
            }
            if ((condition = queryStep.getWhereCondition()) != null) {
                select.addConditions(Operator.AND, condition);
            }
            select.addFrom((TableLike)Tables.ENTRY);
            select = new JoinBinder(select, false).addJoinClause(queryStep.getCompositionAttributeQuery());
            if (first) {
                unionSetQuery = select;
                first = false;
                continue;
            }
            unionSetQuery.union(select);
        }
        if (new Variables(this.statements.getVariables()).hasDefinedDistinct() || new Variables(this.statements.getVariables()).hasDefinedFunction()) {
            SuperQuery superQuery = new SuperQuery(this.context, this.statements.getVariables(), unionSetQuery);
            unionSetQuery = superQuery.select();
            if (this.statements.getOrderAttributes() != null && !this.statements.getOrderAttributes().isEmpty()) {
                unionSetQuery = superQuery.setOrderBy(this.statements.getOrderAttributes(), unionSetQuery);
            }
        } else if (this.statements.getOrderAttributes() != null && !this.statements.getOrderAttributes().isEmpty()) {
            unionSetQuery = new SuperQuery(this.context, this.statements.getVariables(), unionSetQuery).selectOrderBy(this.statements.getOrderAttributes());
        }
        LimitBinding limitBinding = new LimitBinding(Optional.ofNullable(this.statements.getTopAttributes()).map(TopAttributes::getWindow).orElse(this.statements.getLimitAttribute()), this.statements.getOffsetAttribute(), unionSetQuery);
        unionSetQuery = limitBinding.bind();
        return new AqlSelectQuery((SelectQuery<Record>)unionSetQuery, cacheQuery.values(), cacheQuery.values().stream().anyMatch(QuerySteps::isContainsJson));
    }

    private QuerySteps buildQuerySteps(UUID compId, String templateId, String entryRoot) {
        SelectBinder selectBinder = new SelectBinder(this.context, this.introspectCache, this.contains, this.statements, this.serverNodeId, entryRoot).setUsePgExtensions(this.usePgExtensions);
        SelectQuery<Record> select = selectBinder.bind(templateId, compId);
        return new QuerySteps(select, selectBinder.getWhereConditions(templateId, null), templateId, selectBinder.getCompositionAttributeQuery(), selectBinder.getJsonDataBlock(), selectBinder.containsJQueryPath());
    }

    private Result<Record> fetchResultSet(Select<?> select, Result<Record> result) {
        Result intermediary = select.fetch();
        if (result != null) {
            result.addAll((Collection)intermediary);
        } else if (intermediary != null) {
            result = intermediary;
        }
        return result;
    }

    private List<List<String>> buildExplain(Select<?> select) {
        ArrayList<List<String>> explainList = new ArrayList<List<String>>();
        DSLContext pretty = DSL.using((SQLDialect)this.context.dialect(), (Settings)new Settings().withRenderFormatted(Boolean.valueOf(true)));
        String sql = pretty.render(select);
        ArrayList<String> details = new ArrayList<String>();
        details.add(sql);
        for (Param parameter : select.getParams().values()) {
            details.add(parameter.getValue().toString());
        }
        explainList.add(details);
        return explainList;
    }

    static class AqlSelectQuery {
        private final SelectQuery<Record> selectQuery;
        private final Collection<QuerySteps> querySteps;
        private final boolean outputWithJson;

        AqlSelectQuery(SelectQuery<Record> selectQuery, Collection<QuerySteps> querySteps, boolean outputWithJson) {
            this.selectQuery = selectQuery;
            this.querySteps = querySteps;
            this.outputWithJson = outputWithJson;
        }

        public SelectQuery<Record> getSelectQuery() {
            return this.selectQuery;
        }

        boolean isOutputWithJson() {
            return this.outputWithJson;
        }

        Collection<QuerySteps> getQuerySteps() {
            return this.querySteps;
        }
    }
}

