/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.containment.ContainmentSet;
import org.ehrbase.aql.containment.Predicates;
import org.ehrbase.aql.sql.binding.PredicatesBinder;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class ContainBinder {
    private static final String CONTAIN_SUBSELECT_TEMPLATE = "SELECT DISTINCT comp_id FROM ehr.containment WHERE label ~";
    private static final Character SINGLE_QUOTE = Character.valueOf('\'');
    private static final String RIGHT_WILDCARD = ".*";
    public static final String LEFT_WILDCARD = "*.";
    public static final String INNER_WILDCARD = ".*.";
    private List<ContainmentSet> nestedSets;
    private boolean useSimpleCompositionContainment = false;

    public ContainBinder(List<ContainmentSet> containmentSets) {
        this.nestedSets = containmentSets;
        for (int index = this.nestedSets.size() - 1; index >= 0; --index) {
            ContainmentSet adopter;
            ContainmentSet containmentSet = this.nestedSets.get(index);
            if (containmentSet == null || containmentSet.getParentSet() == null || !containmentSet.getParentSet().isEmpty()) continue;
            for (adopter = containmentSet.getParentSet(); adopter != null && adopter.isEmpty(); adopter = adopter.getParentSet()) {
                this.nestedSets.remove(adopter);
            }
            if (adopter.getContainmentList() == null) continue;
            containmentSet.setParentSet(adopter);
        }
    }

    public String bind() {
        ArrayList<Predicates> predicates = new ArrayList<Predicates>();
        for (ContainmentSet containmentSet : this.nestedSets) {
            predicates.add(new PredicatesBinder().bind(containmentSet));
        }
        this.factor4LTree(predicates);
        String query = this.inlineSqlQuery(predicates);
        return query;
    }

    public SelectQuery bind(DSLContext context) {
        ArrayList<Predicates> predicates = new ArrayList<Predicates>();
        for (ContainmentSet containmentSet : this.nestedSets) {
            predicates.add(new PredicatesBinder().bind(containmentSet));
        }
        this.factor4LTree(predicates);
        SelectQuery<?> query = this.jooqQuery(context, predicates);
        return query;
    }

    private String assembleSetOp(List<String> pendingAtomics, List<Predicates.Details> details, String opExpression, StringBuilder query) {
        for (Predicates.Details definition : details) {
            if (definition != null && !definition.isVoid()) {
                if (!pendingAtomics.isEmpty()) {
                    query.append(pendingAtomics.get(0));
                    pendingAtomics.remove(0);
                }
                query.append(opExpression + CONTAIN_SUBSELECT_TEMPLATE + SINGLE_QUOTE + definition.getExpression() + SINGLE_QUOTE);
            } else if (pendingAtomics.size() > 1) {
                query.append(pendingAtomics.get(0));
                query.append(opExpression + pendingAtomics.get(1));
                pendingAtomics.remove(0);
                pendingAtomics.remove(0);
            }
            pendingAtomics.add(query.toString());
            query = new StringBuilder();
        }
        return query.toString();
    }

    private SelectQuery singularSelect(DSLContext context, Predicates.Details definition) {
        SelectQuery selectQuery = context.selectQuery();
        if (definition.getExpression().equals("COMPOSITION%")) {
            this.useSimpleCompositionContainment = true;
            return null;
        }
        Condition condition = DSL.condition((String)("label ~" + SINGLE_QUOTE + definition.getExpression() + SINGLE_QUOTE));
        selectQuery.addConditions(condition);
        selectQuery.addFrom((TableLike)Tables.CONTAINMENT);
        selectQuery.addDistinctOn(new SelectFieldOrAsterisk[]{Tables.CONTAINMENT.COMP_ID});
        selectQuery.addSelect(new SelectFieldOrAsterisk[]{Tables.CONTAINMENT.COMP_ID});
        return selectQuery;
    }

    private SelectQuery assembleSetOp(DSLContext context, List<SelectQuery> pendingAtomics, List<Predicates.Details> details, String opExpression, SelectQuery query) {
        for (Predicates.Details definition : details) {
            if (definition != null && !definition.isVoid()) {
                if (!pendingAtomics.isEmpty()) {
                    query.addFrom((TableLike)pendingAtomics.get(0));
                    pendingAtomics.remove(0);
                }
                SelectQuery secondary = this.singularSelect(context, definition);
                switch (opExpression) {
                    case " INTERSECT ": {
                        query.intersect((Select)secondary);
                        break;
                    }
                    case " UNION ": {
                        query.unionAll((Select)secondary);
                        break;
                    }
                    case " EXCEPT ": {
                        query.exceptAll((Select)secondary);
                    }
                }
            } else if (pendingAtomics.size() > 1) {
                SelectQuery initial = pendingAtomics.get(0);
                SelectQuery secondary = pendingAtomics.get(1);
                switch (opExpression) {
                    case " INTERSECT ": {
                        initial.intersect((Select)secondary);
                        break;
                    }
                    case " UNION ": {
                        initial.unionAll((Select)secondary);
                        break;
                    }
                    case " EXCEPT ": {
                        initial.exceptAll((Select)secondary);
                    }
                }
                pendingAtomics.remove(0);
                pendingAtomics.remove(0);
            }
            pendingAtomics.add(query);
        }
        return query;
    }

    private String inlineSqlQuery(List<Predicates> predicatesList) {
        StringBuilder query = new StringBuilder();
        ArrayList<String> pendingAtomics = new ArrayList<String>();
        for (Predicates predicates : predicatesList) {
            if (predicates == null) continue;
            if (!predicates.getAtomicPredicates().isEmpty()) {
                for (Predicates.Details definition : predicates.getAtomicPredicates()) {
                    query.append(CONTAIN_SUBSELECT_TEMPLATE + SINGLE_QUOTE + definition.getExpression() + SINGLE_QUOTE);
                    pendingAtomics.add(query.toString());
                    query = new StringBuilder();
                }
            }
            if (!predicates.getIntersectPredicates().isEmpty()) {
                this.assembleSetOp(pendingAtomics, predicates.getIntersectPredicates(), " INTERSECT ", query);
                query = new StringBuilder();
            }
            if (!predicates.getUnionPredicates().isEmpty()) {
                this.assembleSetOp(pendingAtomics, predicates.getUnionPredicates(), " UNION ", query);
                query = new StringBuilder();
            }
            if (predicates.getExceptPredicates().isEmpty()) continue;
            this.assembleSetOp(pendingAtomics, predicates.getExceptPredicates(), " EXCEPT ", query);
            query = new StringBuilder();
        }
        if (!pendingAtomics.isEmpty()) {
            query.append((String)pendingAtomics.get(0));
            return query.toString();
        }
        return "";
    }

    private SelectQuery<?> jooqQuery(DSLContext context, List<Predicates> predicatesList) {
        ArrayList<SelectQuery> pendingAtomics = new ArrayList<SelectQuery>();
        SelectQuery selectQuery = null;
        for (Predicates predicates : predicatesList) {
            if (predicates == null) continue;
            if (!predicates.getAtomicPredicates().isEmpty()) {
                for (Predicates.Details definition : predicates.getAtomicPredicates()) {
                    selectQuery = this.singularSelect(context, definition);
                    pendingAtomics.add(selectQuery);
                    selectQuery = context.selectQuery();
                }
            }
            if (!predicates.getIntersectPredicates().isEmpty()) {
                this.assembleSetOp(context, pendingAtomics, predicates.getIntersectPredicates(), " INTERSECT ", selectQuery);
                selectQuery = context.selectQuery();
            }
            if (!predicates.getUnionPredicates().isEmpty()) {
                this.assembleSetOp(context, pendingAtomics, predicates.getUnionPredicates(), " UNION ", selectQuery);
                selectQuery = context.selectQuery();
            }
            if (predicates.getExceptPredicates().isEmpty()) continue;
            this.assembleSetOp(context, pendingAtomics, predicates.getExceptPredicates(), " EXCEPT ", selectQuery);
            selectQuery = context.selectQuery();
        }
        if (!pendingAtomics.isEmpty()) {
            if (pendingAtomics.get(0) == null) {
                return null;
            }
            selectQuery.addFrom((TableLike)pendingAtomics.get(0));
            return selectQuery;
        }
        return null;
    }

    private void factorEnclosing(List<Predicates.Details> predicatesDetails) {
        for (Predicates.Details details : predicatesDetails) {
            for (Containment enclosure = details.getContainedIn(); enclosure != null; enclosure = enclosure.getEnclosingContainment()) {
                if (StringUtils.isNotEmpty((CharSequence)enclosure.getArchetypeId())) {
                    String labelized;
                    details.setExpression(labelized + ((labelized = ContainBinder.labelize(enclosure.getArchetypeId())).length() > 0 ? INNER_WILDCARD : LEFT_WILDCARD) + details.getExpression());
                    continue;
                }
                details.setExpression(LEFT_WILDCARD + details.getExpression());
            }
        }
    }

    private void factor4LTree(List<Predicates> predicates) {
        for (Predicates predicatesDetail : predicates) {
            if (predicatesDetail == null) continue;
            this.factorEnclosing(predicatesDetail.getAtomicPredicates());
            this.factorEnclosing(predicatesDetail.getUnionPredicates());
            this.factorEnclosing(predicatesDetail.getIntersectPredicates());
            this.factorEnclosing(predicatesDetail.getExceptPredicates());
        }
    }

    public static String labelize(String archetypeId) {
        return archetypeId.replaceAll("\\-", "_").replaceAll("\\.", "_");
    }

    public boolean isUseSimpleCompositionContainment() {
        return this.useSimpleCompositionContainment;
    }
}

