/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.queryImpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryImpl.I_QueryImpl;
import org.ehrbase.aql.sql.queryImpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryImpl.VariableAqlPath;
import org.ehrbase.aql.sql.queryImpl.attribute.ehr.EhrResolver;
import org.jooq.Field;

class ExpressionField {
    private final I_VariableDefinition variableDefinition;
    private final JsonbEntryQuery jsonbEntryQuery;
    private final CompositionAttributeQuery compositionAttributeQuery;
    private boolean containsJsonDataBlock = false;
    private String rootJsonKey = null;
    private String optionalPath = null;
    private String jsonbItemPath = null;

    public ExpressionField(I_VariableDefinition variableDefinition, JsonbEntryQuery jsonbEntryQuery, CompositionAttributeQuery compositionAttributeQuery) {
        this.variableDefinition = variableDefinition;
        this.jsonbEntryQuery = jsonbEntryQuery;
        this.compositionAttributeQuery = compositionAttributeQuery;
    }

    Field<?> toSql(String className, String template_id, UUID comp_id, String identifier) {
        Field<?> field;
        switch (className) {
            case "COMPOSITION": {
                if (this.variableDefinition.getPath() != null && this.variableDefinition.getPath().startsWith("content")) {
                    field = this.jsonbEntryQuery.makeField(template_id, comp_id, identifier, this.variableDefinition, I_QueryImpl.Clause.SELECT);
                    this.containsJsonDataBlock = this.jsonbEntryQuery.isJsonDataBlock();
                    this.jsonbItemPath = this.jsonbEntryQuery.getJsonbItemPath();
                } else {
                    field = this.compositionAttributeQuery.makeField(template_id, comp_id, identifier, this.variableDefinition, I_QueryImpl.Clause.SELECT);
                    this.containsJsonDataBlock = this.compositionAttributeQuery.isJsonDataBlock();
                }
                this.optionalPath = this.variableDefinition.getPath();
                break;
            }
            case "EHR": {
                if (EhrResolver.isEhrAttribute(this.variableDefinition.getPath())) {
                    this.variableDefinition.setDistinct(true);
                }
                field = this.compositionAttributeQuery.makeField(template_id, comp_id, identifier, this.variableDefinition, I_QueryImpl.Clause.SELECT);
                this.containsJsonDataBlock = this.compositionAttributeQuery.isJsonDataBlock();
                this.optionalPath = this.variableDefinition.getPath();
                break;
            }
            default: {
                VariableAqlPath variableAqlPath;
                Class itemClass;
                field = this.jsonbEntryQuery.makeField(template_id, comp_id, identifier, this.variableDefinition, I_QueryImpl.Clause.SELECT);
                this.jsonbItemPath = this.jsonbEntryQuery.getJsonbItemPath();
                this.containsJsonDataBlock |= this.jsonbEntryQuery.isJsonDataBlock();
                if (!this.jsonbEntryQuery.isJsonDataBlock() || this.jsonbEntryQuery.getItemType() == null || !DataValue.class.isAssignableFrom(itemClass = ArchieRMInfoLookup.getInstance().getClass(this.jsonbEntryQuery.getItemType())) || !(variableAqlPath = new VariableAqlPath(this.variableDefinition.getPath())).getSuffix().equals("value")) break;
                try {
                    I_VariableDefinition variableDefinition1 = this.variableDefinition.clone();
                    variableDefinition1.setPath(variableAqlPath.getInfix());
                    field = this.jsonbEntryQuery.makeField(template_id, comp_id, identifier, variableDefinition1, I_QueryImpl.Clause.SELECT);
                    this.jsonbItemPath = this.jsonbEntryQuery.getJsonbItemPath();
                    this.rootJsonKey = variableAqlPath.getSuffix();
                    break;
                }
                catch (CloneNotSupportedException e) {
                    throw new InternalServerException("Couldn't handle variable:" + this.variableDefinition.toString() + "Code error:" + e);
                }
            }
        }
        return field;
    }

    boolean isContainsJsonDataBlock() {
        return this.containsJsonDataBlock;
    }

    String getRootJsonKey() {
        return this.rootJsonKey;
    }

    String getOptionalPath() {
        return this.optionalPath;
    }

    String getJsonbItemPath() {
        return this.jsonbItemPath;
    }
}

