/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.UUID;
import org.ehrbase.aql.sql.binding.I_JoinBinder;
import org.ehrbase.aql.sql.queryImpl.CompositionAttributeQuery;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.SelectField;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class JoinBinder
implements I_JoinBinder {
    private boolean isWholeComposition = false;
    private boolean compositionJoined = false;
    private boolean statusJoined = false;
    private boolean subjectJoin = false;
    private boolean eventContextJoined = false;
    private boolean facilityJoined = false;
    private boolean composerJoined = false;
    private boolean ehrJoined = false;
    private boolean systemJoined = false;
    SelectQuery<?> selectQuery;

    public JoinBinder(SelectQuery<?> selectQuery, boolean isWholeComposition) {
        this.selectQuery = selectQuery;
        this.isWholeComposition = isWholeComposition;
    }

    public JoinBinder() {
        this.isWholeComposition = false;
    }

    public SelectQuery<?> addJoinClause(CompositionAttributeQuery compositionAttributeQuery) {
        if (compositionAttributeQuery.isJoinSubject()) {
            this.joinSubject(this.selectQuery, compositionAttributeQuery);
        }
        if (compositionAttributeQuery.isJoinComposition()) {
            this.joinComposition(this.selectQuery, compositionAttributeQuery);
        }
        if (compositionAttributeQuery.isJoinEventContext()) {
            this.joinEventContext(this.selectQuery, compositionAttributeQuery);
        }
        if (compositionAttributeQuery.isJoinContextFacility()) {
            this.joinContextFacility(this.selectQuery, compositionAttributeQuery);
        }
        if (compositionAttributeQuery.isJoinComposer()) {
            this.joinComposer(this.selectQuery, compositionAttributeQuery);
        }
        if (compositionAttributeQuery.isJoinEhr()) {
            this.joinEhr(this.selectQuery, compositionAttributeQuery);
        }
        if (compositionAttributeQuery.isJoinSystem()) {
            this.joinSystem(this.selectQuery, compositionAttributeQuery);
        }
        if (compositionAttributeQuery.isJoinEhrStatus() || compositionAttributeQuery.containsEhrStatus()) {
            this.joinEhrStatus(this.selectQuery, compositionAttributeQuery);
        }
        return this.selectQuery;
    }

    private void joinComposition(SelectQuery<?> selectQuery, CompositionAttributeQuery compositionAttributeQuery) {
        if (this.compositionJoined) {
            return;
        }
        selectQuery.addJoin((TableLike)compositionRecordTable, JoinType.RIGHT_OUTER_JOIN, DSL.field((SelectField)compositionRecordTable.field((Field)Tables.COMPOSITION.ID)).eq((Field)Tables.ENTRY.COMPOSITION_ID));
        this.compositionJoined = true;
    }

    private void joinSystem(SelectQuery<?> selectQuery, CompositionAttributeQuery compositionAttributeQuery) {
        if (this.systemJoined) {
            return;
        }
        selectQuery.addJoin((TableLike)systemRecordTable, JoinType.RIGHT_OUTER_JOIN, DSL.field((SelectField)systemRecordTable.field((Field)Tables.SYSTEM.ID)).eq(DSL.field((SelectField)ehrRecordTable.field(Tables.EHR_.SYSTEM_ID.getName(), UUID.class))));
        this.systemJoined = true;
    }

    private void joinEhrStatus(SelectQuery<?> selectQuery, CompositionAttributeQuery compositionAttributeQuery) {
        if (this.statusJoined) {
            return;
        }
        if (compositionAttributeQuery.isJoinComposition() || compositionAttributeQuery.useFromEntry()) {
            this.joinComposition(selectQuery, compositionAttributeQuery);
            selectQuery.addJoin((TableLike)statusRecordTable, DSL.field((SelectField)statusRecordTable.field(Tables.STATUS.EHR_ID.getName(), UUID.class)).eq(DSL.field((SelectField)compositionRecordTable.field(Tables.COMPOSITION.EHR_ID.getName(), UUID.class))));
            this.statusJoined = true;
        } else {
            this.joinEhr(selectQuery, compositionAttributeQuery);
            selectQuery.addJoin((TableLike)statusRecordTable, DSL.field((SelectField)statusRecordTable.field(Tables.STATUS.EHR_ID.getName(), UUID.class)).eq(DSL.field((SelectField)ehrRecordTable.field(Tables.EHR_.ID.getName(), UUID.class))));
            this.statusJoined = true;
        }
    }

    private void joinSubject(SelectQuery<?> selectQuery, CompositionAttributeQuery compositionAttributeQuery) {
        if (this.subjectJoin) {
            return;
        }
        this.joinEhrStatus(selectQuery, compositionAttributeQuery);
        Table subjectTable = subjectRef;
        selectQuery.addJoin((TableLike)subjectTable, DSL.field((SelectField)subjectTable.field(Tables.PARTY_IDENTIFIED.ID.getName(), UUID.class)).eq(DSL.field((SelectField)statusRecordTable.field(Tables.STATUS.PARTY.getName(), UUID.class))));
        this.subjectJoin = true;
    }

    private void joinEventContext(SelectQuery<?> selectQuery, CompositionAttributeQuery compositionAttributeQuery) {
        if (this.eventContextJoined) {
            return;
        }
        selectQuery.addJoin((TableLike)Tables.EVENT_CONTEXT, Tables.EVENT_CONTEXT.COMPOSITION_ID.eq((Field)Tables.ENTRY.COMPOSITION_ID));
        this.eventContextJoined = true;
    }

    private void joinContextFacility(SelectQuery<?> selectQuery, CompositionAttributeQuery compositionAttributeQuery) {
        if (this.facilityJoined) {
            return;
        }
        this.joinEventContext(selectQuery, compositionAttributeQuery);
        Table facilityTable = facilityRef;
        selectQuery.addJoin((TableLike)facilityTable, Tables.EVENT_CONTEXT.FACILITY.eq(DSL.field((SelectField)facilityTable.field(Tables.PARTY_IDENTIFIED.ID.getName(), UUID.class))));
        this.facilityJoined = true;
    }

    private void joinComposer(SelectQuery<?> selectQuery, CompositionAttributeQuery compositionAttributeQuery) {
        if (this.composerJoined) {
            return;
        }
        this.joinComposition(selectQuery, compositionAttributeQuery);
        Table composerTable = composerRef;
        selectQuery.addJoin((TableLike)composerTable, DSL.field((SelectField)compositionRecordTable.field(Tables.COMPOSITION.COMPOSER.getName(), UUID.class)).eq(DSL.field((SelectField)composerTable.field(Tables.PARTY_IDENTIFIED.ID.getName(), UUID.class))));
        this.composerJoined = true;
    }

    private void joinEhr(SelectQuery<?> selectQuery, CompositionAttributeQuery compositionAttributeQuery) {
        if (this.ehrJoined) {
            return;
        }
        this.joinComposition(selectQuery, compositionAttributeQuery);
        selectQuery.addJoin((TableLike)ehrRecordTable, JoinType.RIGHT_OUTER_JOIN, DSL.field((SelectField)ehrRecordTable.field(Tables.EHR_.ID.getName(), UUID.class)).eq(DSL.field((SelectField)compositionRecordTable.field(Tables.COMPOSITION.EHR_ID.getName(), UUID.class))));
        this.ehrJoined = true;
    }
}

