/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import com.google.common.base.Strings;
import java.util.Iterator;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.aql.compiler.OrderAttribute;
import org.ehrbase.aql.compiler.Statements;
import org.ehrbase.aql.definition.I_VariableDefinition;

public class OrderByField {
    private Statements statements;

    public OrderByField(Statements statements) {
        this.statements = statements;
    }

    private boolean containsOrderBy() {
        return this.statements.getOrderAttributes() != null && !this.statements.getOrderAttributes().isEmpty();
    }

    public Statements merge() {
        if (!this.containsOrderBy()) {
            return this.statements;
        }
        for (OrderAttribute orderAttribute : this.statements.getOrderAttributes()) {
            I_VariableDefinition orderAttributeVariable = orderAttribute.getVariableDefinition();
            if (this.isSelectVariable(orderAttributeVariable)) continue;
            try {
                I_VariableDefinition orderVariable = orderAttributeVariable.clone();
                orderVariable.setHidden(true);
                this.statements.put(orderVariable);
            }
            catch (CloneNotSupportedException e) {
                throw new InternalServerException("Could not handle order variable:" + orderAttributeVariable.toString() + ", exception:" + e);
            }
        }
        return this.statements;
    }

    private boolean isSelectVariable(I_VariableDefinition aVariable) {
        Iterator<I_VariableDefinition> variableDefinitions = this.statements.getVariables().iterator();
        while (variableDefinitions.hasNext()) {
            I_VariableDefinition variableDefinition = variableDefinitions.next();
            if (aVariable.getAlias() != null && Strings.nullToEmpty((String)variableDefinition.getAlias()).equals(Strings.nullToEmpty((String)aVariable.getAlias()))) {
                return true;
            }
            if (aVariable.getPath() == null || !Strings.nullToEmpty((String)variableDefinition.getPath()).equals(Strings.nullToEmpty((String)aVariable.getPath()))) continue;
            return true;
        }
        return false;
    }
}

