/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.commons.collections4.set.ListOrderedSet;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.containment.ContainmentSet;
import org.ehrbase.aql.containment.Predicates;
import org.ehrbase.aql.sql.binding.ContainBinder;

class PredicatesBinder {
    private Predicates predicates;
    static final String EXCEPT_EXPRESSION = " EXCEPT ";
    static final String INTERSECT_EXPRESSION = " INTERSECT ";
    static final String UNION_EXPRESSION = " UNION ";

    PredicatesBinder() {
    }

    private Object lookAhead(ListOrderedSet<Object> containmentList, int cursor) {
        if (cursor + 1 >= containmentList.size()) {
            return null;
        }
        return containmentList.get(cursor + 1);
    }

    private boolean isOperator(Object object) {
        return object instanceof ContainmentSet.OPERATOR;
    }

    private boolean isContainment(Object object) {
        return object instanceof Containment;
    }

    private boolean isLastItem(ListOrderedSet<Object> containmentList, int cursor) {
        return cursor + 1 >= containmentList.size();
    }

    private int resolveUnallocated(Deque<ContainmentSet.OPERATOR> operatorStack) {
        if (!this.predicates.getAtomicPredicates().isEmpty() && !operatorStack.isEmpty()) {
            ContainmentSet.OPERATOR operator = operatorStack.pop();
            int cursor = this.predicates.getAtomicPredicates().size() - 1;
            switch (operator) {
                case AND: {
                    Predicates.Details details = this.predicates.getAtomicPredicates().get(cursor);
                    this.predicates.getIntersectPredicates().add(details);
                    this.predicates.getAtomicPredicates().remove(cursor);
                    break;
                }
                case OR: {
                    Predicates.Details details = this.predicates.getAtomicPredicates().get(cursor);
                    this.predicates.getUnionPredicates().add(details);
                    this.predicates.getAtomicPredicates().remove(cursor);
                    break;
                }
                case XOR: {
                    Predicates.Details details = this.predicates.getAtomicPredicates().get(cursor);
                    this.predicates.getExceptPredicates().add(details);
                    this.predicates.getAtomicPredicates().remove(cursor);
                }
            }
        }
        return this.predicates.getAtomicPredicates().size();
    }

    private StringBuilder buildBooleanExpression(StringBuilder containedPredicateLtree, String operator, List<Predicates.Details> predicatesList, ContainmentSet inSet, Containment enclosing) {
        if (this.predicates.getAtomicPredicates().size() == 2) {
            containedPredicateLtree.append(this.predicates.getAtomicPredicates().get(0));
            containedPredicateLtree.append(operator);
            containedPredicateLtree.append(this.predicates.getAtomicPredicates().get(1));
            this.predicates.getAtomicPredicates().remove(1);
            this.predicates.getAtomicPredicates().remove(0);
            this.predicates.getAtomicPredicates().add(new Predicates.Details(containedPredicateLtree.toString(), inSet, enclosing));
        } else if (this.predicates.getAtomicPredicates().size() == 1) {
            containedPredicateLtree.append(this.predicates.getAtomicPredicates().get(0));
            containedPredicateLtree.append(operator);
            this.predicates.getAtomicPredicates().remove(0);
            this.predicates.getAtomicPredicates().add(new Predicates.Details(containedPredicateLtree.toString(), inSet, enclosing));
        } else if (this.predicates.getAtomicPredicates().isEmpty()) {
            predicatesList.add(new Predicates.Details(containedPredicateLtree.toString(), inSet, enclosing));
        }
        return containedPredicateLtree;
    }

    Predicates bind(ContainmentSet containmentSet) {
        if (containmentSet == null) {
            return null;
        }
        this.predicates = new Predicates(containmentSet);
        ArrayDeque<ContainmentSet.OPERATOR> operatorStack = new ArrayDeque<ContainmentSet.OPERATOR>();
        StringBuilder containedPredicateLtree = new StringBuilder();
        for (int i = 0; i < containmentSet.getContainmentList().size(); ++i) {
            Object item = containmentSet.getContainmentList().get(i);
            if (this.isContainment(item)) {
                Containment containmentDefinition = (Containment)item;
                String archetypeId = containmentDefinition.getArchetypeId();
                if (archetypeId.length() != 0) {
                    containedPredicateLtree.append(ContainBinder.labelize(archetypeId));
                } else {
                    containedPredicateLtree.append(containmentDefinition.getClassName() + "%");
                }
                if (!this.isLastItem(containmentSet.getContainmentList(), i) && !this.isOperator(this.lookAhead(containmentSet.getContainmentList(), i))) {
                    containedPredicateLtree.append(".*.");
                }
            } else if (this.isOperator(item)) {
                ContainmentSet.OPERATOR operator = (ContainmentSet.OPERATOR)((Object)item);
                switch (operator) {
                    case OR: {
                        if (containedPredicateLtree.length() == 0) {
                            containedPredicateLtree = this.buildBooleanExpression(containedPredicateLtree, EXCEPT_EXPRESSION, this.predicates.getUnionPredicates(), containmentSet.getParentSet(), containmentSet.getEnclosing());
                        } else {
                            this.predicates.getUnionPredicates().add(new Predicates.Details(containedPredicateLtree.toString(), containmentSet.getParentSet(), containmentSet.getEnclosing()));
                            operatorStack.push(operator);
                        }
                        containedPredicateLtree = new StringBuilder();
                        break;
                    }
                    case XOR: {
                        if (containedPredicateLtree.length() == 0) {
                            containedPredicateLtree = this.buildBooleanExpression(containedPredicateLtree, EXCEPT_EXPRESSION, this.predicates.getExceptPredicates(), containmentSet.getParentSet(), containmentSet.getEnclosing());
                        } else {
                            this.predicates.getExceptPredicates().add(new Predicates.Details(containedPredicateLtree.toString(), containmentSet.getParentSet(), containmentSet.getEnclosing()));
                            operatorStack.push(operator);
                        }
                        containedPredicateLtree = new StringBuilder();
                        break;
                    }
                    case AND: {
                        if (containedPredicateLtree.length() == 0) {
                            containedPredicateLtree = this.buildBooleanExpression(containedPredicateLtree, INTERSECT_EXPRESSION, this.predicates.getIntersectPredicates(), containmentSet.getParentSet(), containmentSet.getEnclosing());
                        } else {
                            this.predicates.getAtomicPredicates().add(new Predicates.Details(containedPredicateLtree.toString(), containmentSet.getParentSet(), containmentSet.getEnclosing()));
                            operatorStack.push(operator);
                        }
                        containedPredicateLtree = new StringBuilder();
                    }
                }
            }
            int n = this.resolveUnallocated(operatorStack);
        }
        if (containedPredicateLtree.length() > 0) {
            this.predicates.getAtomicPredicates().add(new Predicates.Details(containedPredicateLtree.toString(), containmentSet.getParentSet(), containmentSet.getEnclosing()));
        }
        return this.predicates;
    }
}

