/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.ehrbase.aql.compiler.Contains;
import org.ehrbase.aql.compiler.Statements;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.ExpressionField;
import org.ehrbase.aql.sql.binding.I_SelectBinder;
import org.ehrbase.aql.sql.binding.JsonbBlockDef;
import org.ehrbase.aql.sql.binding.VariableDefinitions;
import org.ehrbase.aql.sql.binding.WhereBinder;
import org.ehrbase.aql.sql.queryImpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryImpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryImpl.TemplateMetaData;
import org.ehrbase.service.IntrospectService;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;

public class SelectBinder
extends TemplateMetaData
implements I_SelectBinder {
    private final JsonbEntryQuery jsonbEntryQuery;
    private final CompositionAttributeQuery compositionAttributeQuery;
    private final PathResolver pathResolver;
    private final VariableDefinitions variableDefinitions;
    private final List<JsonbBlockDef> jsonDataBlock = new ArrayList<JsonbBlockDef>();
    private final DSLContext context;
    private final WhereBinder whereBinder;
    private boolean isWholeComposition = false;
    private boolean usePgExtensions = true;

    SelectBinder(DSLContext context, IntrospectService introspectCache, PathResolver pathResolver, VariableDefinitions variableDefinitions, List whereClause, String serverNodeId, String entry_root) {
        super(introspectCache);
        this.context = context;
        this.pathResolver = pathResolver;
        this.variableDefinitions = variableDefinitions;
        this.jsonbEntryQuery = new JsonbEntryQuery(context, introspectCache, pathResolver, entry_root);
        this.compositionAttributeQuery = new CompositionAttributeQuery(context, pathResolver, serverNodeId, entry_root, introspectCache);
        this.whereBinder = new WhereBinder(this.jsonbEntryQuery, this.compositionAttributeQuery, whereClause, pathResolver.getMapper());
    }

    private SelectBinder(DSLContext context, IntrospectService introspectCache, IdentifierMapper mapper, VariableDefinitions variableDefinitions, List whereClause, String serverNodeId, String entry_root) {
        this(context, introspectCache, new PathResolver(context, mapper), variableDefinitions, whereClause, serverNodeId, entry_root);
    }

    public SelectBinder(DSLContext context, IntrospectService introspectCache, Contains contains, Statements statements, String serverNodeId, String entry_root) {
        this(context, introspectCache, contains.getIdentifierMapper(), statements.getVariables(), statements.getWhereClause(), serverNodeId, entry_root);
    }

    public SelectQuery<Record> bind(String template_id, UUID comp_id) {
        this.pathResolver.resolvePaths(template_id, comp_id);
        this.jsonbEntryQuery.reset();
        SelectQuery selectQuery = this.context.selectQuery();
        while (this.variableDefinitions.hasNext()) {
            I_VariableDefinition variableDefinition = this.variableDefinitions.next();
            if (variableDefinition.isFunction() || variableDefinition.isExtension()) continue;
            String identifier = variableDefinition.getIdentifier();
            String className = this.pathResolver.classNameOf(identifier);
            ExpressionField expressionField = new ExpressionField(variableDefinition, this.jsonbEntryQuery, this.compositionAttributeQuery);
            Field<?> field = expressionField.toSql(className, template_id, comp_id, identifier);
            this.handleJsonDataBlock(expressionField, field, expressionField.getRootJsonKey(), expressionField.getOptionalPath());
            if (field == null) {
                throw new IllegalArgumentException("Field expression is not supported or invalid :" + variableDefinition);
            }
            selectQuery.addSelect(new SelectFieldOrAsterisk[]{field});
            this.jsonbEntryQuery.inc();
        }
        return selectQuery;
    }

    private void handleJsonDataBlock(ExpressionField expressionField, Field field, String rootJsonKey, String optionalPath) {
        if (expressionField.isContainsJsonDataBlock()) {
            this.jsonDataBlock.add(new JsonbBlockDef(optionalPath == null ? expressionField.getJsonbItemPath() : optionalPath, field, rootJsonKey));
        }
    }

    public Condition getWhereConditions(String templateId, UUID comp_id) {
        return this.whereBinder.bind(templateId, comp_id);
    }

    public boolean containsJQueryPath() {
        return this.jsonbEntryQuery.isContainsJqueryPath();
    }

    public CompositionAttributeQuery getCompositionAttributeQuery() {
        return this.compositionAttributeQuery;
    }

    public List<JsonbBlockDef> getJsonDataBlock() {
        return this.jsonDataBlock;
    }

    public boolean isWholeComposition() {
        return this.isWholeComposition;
    }

    public SelectBinder setUsePgExtensions(boolean usePgExtensions) {
        this.usePgExtensions = usePgExtensions;
        this.whereBinder.setUsePgExtensions(usePgExtensions);
        return this;
    }
}

