/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ehrbase.aql.compiler.OrderAttribute;
import org.ehrbase.aql.definition.FuncParameter;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.Variables;
import org.ehrbase.aql.sql.binding.OrderByBinder;
import org.ehrbase.aql.sql.binding.VariableDefinitions;
import org.ehrbase.aql.sql.queryImpl.DefaultColumnId;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class SuperQuery {
    private VariableDefinitions variableDefinitions;
    private SelectQuery query;
    private DSLContext context;

    public SuperQuery(DSLContext context, VariableDefinitions variableDefinitions, SelectQuery query) {
        this.context = context;
        this.variableDefinitions = variableDefinitions;
        this.query = query;
    }

    private List<Field> selectFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        Iterator<I_VariableDefinition> iterator = this.variableDefinitions.iterator();
        while (iterator.hasNext()) {
            I_VariableDefinition variableDefinition = iterator.next();
            if (variableDefinition.getAlias() == null || variableDefinition.getAlias().isEmpty()) {
                fields.add(DSL.fieldByName((String[])new String[]{new DefaultColumnId().value(variableDefinition)}));
                continue;
            }
            fields.add(DSL.fieldByName((String[])new String[]{variableDefinition.getAlias()}));
        }
        return fields;
    }

    private SelectQuery selectDistinct() {
        SelectQuery selectQuery = this.context.selectQuery();
        List<Field> fields = this.selectFields();
        selectQuery.addDistinctOn(fields);
        selectQuery.addFrom((TableLike)this.query);
        return selectQuery;
    }

    private SelectQuery selectAggregate() {
        SelectQuery selectQuery = this.context.selectQuery();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<String> skipField = new ArrayList<String>();
        Iterator<I_VariableDefinition> iterator = this.variableDefinitions.iterator();
        while (iterator.hasNext()) {
            String alias;
            I_VariableDefinition variableDefinition = iterator.next();
            String string = alias = variableDefinition.getAlias() == null || variableDefinition.getAlias().isEmpty() ? variableDefinition.getPath() : variableDefinition.getAlias();
            if (variableDefinition.isFunction()) {
                skipField.add(alias);
                Field field = DSL.field((String)this.functionExpression(variableDefinition));
                if (variableDefinition.getAlias() != null) {
                    field = field.as(alias);
                }
                fields.add(field);
                continue;
            }
            if (variableDefinition.isExtension() || skipField.contains(alias)) continue;
            fields.add(DSL.fieldByName((String[])new String[]{alias}));
        }
        selectQuery.addSelect(fields);
        selectQuery.addFrom((TableLike)this.query);
        return selectQuery;
    }

    private String functionExpression(I_VariableDefinition variableDefinition) {
        StringBuilder expression = new StringBuilder();
        for (FuncParameter parameter : variableDefinition.getFuncParameters()) {
            if (parameter.isVariable()) {
                expression.append("\"");
                expression.append(parameter.getValue());
                expression.append("\"");
                continue;
            }
            expression.append(parameter.getValue());
        }
        return expression.toString();
    }

    public SelectQuery selectOrderBy(List<OrderAttribute> orderAttributes) {
        SelectQuery selectQuery = this.context.selectQuery();
        selectQuery.addFrom((TableLike)this.query);
        selectQuery = this.setOrderBy(orderAttributes, selectQuery);
        return selectQuery;
    }

    public SelectQuery setOrderBy(List<OrderAttribute> orderAttributes, SelectQuery selectQuery) {
        return new OrderByBinder(orderAttributes, (SelectQuery<Record>)selectQuery).bind();
    }

    public SelectQuery select() {
        if (new Variables(this.variableDefinitions).hasDefinedDistinct()) {
            return this.selectDistinct();
        }
        if (new Variables(this.variableDefinitions).hasDefinedFunction()) {
            return this.selectAggregate();
        }
        throw new IllegalArgumentException("Don't know how to handle super query");
    }
}

