/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.sql.binding.I_TaggedStringBuilder;
import org.ehrbase.aql.sql.binding.TaggedStringBuilder;
import org.ehrbase.aql.sql.binding.WhereJsQueryExpression;
import org.ehrbase.aql.sql.queryImpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryImpl.I_QueryImpl;
import org.ehrbase.aql.sql.queryImpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryImpl.VariablePath;
import org.ehrbase.aql.sql.queryImpl.value_field.ISODateTime;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class WhereBinder {
    private static final String VALUETYPE_EXPR_VALUE = "\"value\"";
    private static final Set<String> sqloperators = new HashSet<String>(Arrays.asList("=", "!=", ">", ">=", "<", "<=", "MATCHES", "EXISTS", "NOT", "(", ")", "{", "}"));
    private JsonbEntryQuery jsonbEntryQuery;
    private CompositionAttributeQuery compositionAttributeQuery;
    private final List whereClause;
    private IdentifierMapper mapper;
    private Condition initialCondition;
    private boolean isWholeComposition = false;
    private String compositionName = null;
    private String sqlConditionalFunctionalOperatorRegexp = "(?i)(like|ilike|in|not in)";
    private boolean requiresJSQueryClosure = false;
    private boolean isFollowedBySQLConditionalOperator = false;
    private boolean usePgExtensions = true;

    public WhereBinder(JsonbEntryQuery jsonbEntryQuery, CompositionAttributeQuery compositionAttributeQuery, List whereClause, IdentifierMapper mapper) {
        this.jsonbEntryQuery = jsonbEntryQuery;
        this.compositionAttributeQuery = compositionAttributeQuery;
        this.whereClause = whereClause;
        this.mapper = mapper;
    }

    private TaggedStringBuilder encodeWhereVariable(String templateId, UUID comp_id, I_VariableDefinition variableDefinition, boolean forceSQL, String compositionName) {
        String identifier = variableDefinition.getIdentifier();
        String className = this.mapper.getClassName(identifier);
        if (className == null) {
            throw new IllegalArgumentException("Could not bind identifier in WHERE clause:'" + identifier + "'");
        }
        if (forceSQL || !this.usePgExtensions) {
            Field<?> field = className.equals("COMPOSITION") || className.equals("EHR") ? this.compositionAttributeQuery.whereField(templateId, comp_id, identifier, variableDefinition) : this.jsonbEntryQuery.makeField(templateId, comp_id, identifier, variableDefinition, I_QueryImpl.Clause.WHERE);
            if (field == null) {
                return null;
            }
            return new TaggedStringBuilder(field.toString(), I_TaggedStringBuilder.TagField.SQLQUERY);
        }
        switch (className) {
            case "COMPOSITION": {
                if (variableDefinition.getPath().startsWith("content")) {
                    Field<?> field = this.jsonbEntryQuery.whereField(templateId, comp_id, identifier, variableDefinition);
                    TaggedStringBuilder taggedStringBuilder = new TaggedStringBuilder(field.toString(), I_TaggedStringBuilder.TagField.JSQUERY);
                    if (compositionName != null && taggedStringBuilder.startWith("/composition")) {
                        taggedStringBuilder.replace("]", " and name/value='" + compositionName + "']");
                    }
                    return taggedStringBuilder;
                }
            }
            case "EHR": {
                Field<?> field = this.compositionAttributeQuery.whereField(templateId, comp_id, identifier, variableDefinition);
                if (field == null) {
                    return null;
                }
                return new TaggedStringBuilder(field.toString(), I_TaggedStringBuilder.TagField.SQLQUERY);
            }
        }
        Field<?> field = this.jsonbEntryQuery.whereField(templateId, comp_id, identifier, variableDefinition);
        return new TaggedStringBuilder(field.toString(), I_TaggedStringBuilder.TagField.JSQUERY);
    }

    private TaggedStringBuilder buildWhereCondition(String templateId, UUID comp_id, TaggedStringBuilder taggedBuffer, List item) {
        for (Object part : item) {
            TaggedStringBuilder taggedStringBuilder;
            if (part instanceof String) {
                taggedBuffer.append((String)part);
                continue;
            }
            if (part instanceof VariableDefinition) {
                taggedStringBuilder = this.encodeWhereVariable(templateId, comp_id, (VariableDefinition)part, false, null);
                taggedBuffer.append(taggedStringBuilder.toString());
                taggedBuffer.setTagField(taggedStringBuilder.getTagField());
                continue;
            }
            if (!(part instanceof List)) continue;
            taggedStringBuilder = this.buildWhereCondition(templateId, comp_id, taggedBuffer, (List)part);
            taggedBuffer.append(taggedStringBuilder.toString());
            taggedBuffer.setTagField(taggedStringBuilder.getTagField());
        }
        return taggedBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Condition bind(String templateId, UUID comp_id) {
        if (this.whereClause.size() == 0) {
            return null;
        }
        TaggedStringBuilder taggedBuffer = new TaggedStringBuilder();
        List whereItems = this.whereClause;
        for (int cursor = 0; cursor < whereItems.size(); ++cursor) {
            TaggedStringBuilder taggedStringBuilder;
            Object e = whereItems.get(cursor);
            if (e instanceof String) {
                switch (((String)e).trim().toUpperCase()) {
                    case "OR": 
                    case "XOR": 
                    case "AND": 
                    case "NOT": {
                        taggedBuffer = new WhereJsQueryExpression(taggedBuffer, this.requiresJSQueryClosure, this.isFollowedBySQLConditionalOperator).closure();
                        taggedBuffer.append(" " + e + " ");
                        break;
                    }
                    default: {
                        ISODateTime isoDateTime = new ISODateTime(((String)e).replaceAll("'", ""));
                        if (isoDateTime.isValidDateTimeExpression()) {
                            Long timestamp = isoDateTime.toTimeStamp();
                            int lastValuePos = taggedBuffer.lastIndexOf(VALUETYPE_EXPR_VALUE);
                            if (lastValuePos > 0) {
                                taggedBuffer.replaceLast(VALUETYPE_EXPR_VALUE, "\"epoch_offset\"");
                            }
                            Object object = this.hackItem(taggedBuffer, timestamp.toString());
                            taggedBuffer.append((String)object);
                            break;
                        }
                        Object object = this.hackItem(taggedBuffer, (String)e);
                        taggedBuffer.append((String)object);
                        break;
                    }
                }
                continue;
            }
            if (e instanceof Long) {
                Object object = this.hackItem(taggedBuffer, e.toString());
                taggedBuffer.append(object.toString());
                continue;
            }
            if (e instanceof I_VariableDefinition) {
                taggedStringBuilder = new TaggedStringBuilder();
                if (this.isFollowedBySQLConditionalOperator(cursor)) {
                    taggedStringBuilder.append(this.expandForCondition(this.encodeWhereVariable(templateId, comp_id, (I_VariableDefinition)e, true, null)));
                } else if (((I_VariableDefinition)e).getPath() != null && this.isWholeComposition) {
                    if (this.compositionName == null) {
                        this.compositionName = this.compositionNameValue(((I_VariableDefinition)e).getIdentifier());
                    }
                    if (this.compositionName == null) throw new IllegalArgumentException("A composition name/value is required to resolve where statement when querying for a whole composition");
                    taggedStringBuilder = this.encodeWhereVariable(templateId, comp_id, (I_VariableDefinition)e, false, this.compositionName);
                } else if (new VariablePath(((I_VariableDefinition)e).getPath()).hasPredicate()) {
                    taggedStringBuilder.append(this.expandForCondition(this.encodeWhereVariable(templateId, comp_id, (I_VariableDefinition)e, true, null)));
                } else {
                    taggedStringBuilder.append(this.expandForCondition(this.encodeWhereVariable(templateId, comp_id, (I_VariableDefinition)e, false, null)));
                }
                if (taggedStringBuilder == null) continue;
                taggedBuffer.append(taggedStringBuilder.toString());
                taggedBuffer.setTagField(taggedStringBuilder.getTagField());
                continue;
            }
            if (!(e instanceof List)) continue;
            taggedStringBuilder = this.buildWhereCondition(templateId, comp_id, taggedBuffer, (List)e);
            taggedBuffer.append(taggedStringBuilder.toString());
            taggedBuffer.setTagField(taggedStringBuilder.getTagField());
        }
        taggedBuffer = new WhereJsQueryExpression(taggedBuffer, this.requiresJSQueryClosure, this.isFollowedBySQLConditionalOperator).closure();
        return DSL.condition((String)taggedBuffer.toString());
    }

    private boolean isFollowedBySQLConditionalOperator(int cursor) {
        Object nextToken;
        if (cursor < this.whereClause.size() - 1 && (nextToken = this.whereClause.get(cursor + 1)) instanceof String && ((String)nextToken).trim().matches(this.sqlConditionalFunctionalOperatorRegexp)) {
            this.isFollowedBySQLConditionalOperator = true;
            return true;
        }
        this.isFollowedBySQLConditionalOperator = false;
        return false;
    }

    private String compositionNameValue(String symbol) {
        String token = null;
        for (int lcursor = 0; lcursor < this.whereClause.size() - 1; ++lcursor) {
            if (!(this.whereClause.get(lcursor) instanceof VariableDefinition) || !((VariableDefinition)this.whereClause.get(lcursor)).getIdentifier().equals(symbol) || !((VariableDefinition)this.whereClause.get(lcursor)).getPath().equals("name/value")) continue;
            Object nextToken = this.whereClause.get(lcursor + 1);
            if (nextToken instanceof String && !nextToken.equals("=")) {
                throw new IllegalArgumentException("name/value for CompositionAttribute must be an equality");
            }
            nextToken = this.whereClause.get(lcursor + 2);
            if (!(nextToken instanceof String)) continue;
            token = (String)nextToken;
            break;
        }
        return token;
    }

    private Object hackItem(TaggedStringBuilder taggedBuffer, String item) {
        if (sqloperators.contains(item.toUpperCase())) {
            return item;
        }
        if (taggedBuffer.toString().contains("composition_join") && item.contains("::")) {
            return item.split("::")[0] + "'";
        }
        if (taggedBuffer.indexOf("#>>") > 0) {
            return item;
        }
        if (taggedBuffer.indexOf("#") > 0 && item.contains("'")) {
            return item.replaceAll("'", "\"");
        }
        return item;
    }

    public WhereBinder setUsePgExtensions(boolean usePgExtensions) {
        this.usePgExtensions = usePgExtensions;
        return this;
    }

    private String expandForCondition(TaggedStringBuilder taggedStringBuilder) {
        Object wrapped;
        switch (taggedStringBuilder.getTagField()) {
            case JSQUERY: {
                wrapped = JsonbEntryQuery.Jsquery_COMPOSITION_OPEN + taggedStringBuilder.toString();
                this.requiresJSQueryClosure = true;
                break;
            }
            case SQLQUERY: {
                wrapped = taggedStringBuilder.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Uninitialized tag passed in query expression");
            }
        }
        return wrapped;
    }

    private static enum Operator {
        OR,
        XOR,
        AND,
        NOT,
        EXISTS;

    }
}

