/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.postprocessing;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ehrbase.aql.sql.QuerySteps;
import org.ehrbase.aql.sql.binding.JsonbBlockDef;
import org.ehrbase.aql.sql.postprocessing.I_RawJsonTransform;
import org.ehrbase.ehr.encode.rawjson.LightRawJsonEncoder;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;

public class RawJsonTransform
implements I_RawJsonTransform {
    private final DSLContext context;

    public RawJsonTransform(DSLContext context) {
        this.context = context;
    }

    public static void toRawJson(Result<Record> result, Collection<QuerySteps> querySteps, I_KnowledgeCache knowledgeCache) {
        for (QuerySteps queryStep : querySteps) {
            if (queryStep.jsonColumnsSize() <= 0) continue;
            result.forEach(record -> {
                ArrayList<JsonbBlockDef> deleteList = new ArrayList<JsonbBlockDef>();
                for (JsonbBlockDef jsonbBlockDef : queryStep.getJsonColumns()) {
                    if (record.getValue(jsonbBlockDef.getField()) == null) continue;
                    String jsonbOrigin = record.getValue(jsonbBlockDef.getField()).toString();
                    try {
                        JsonElement jsonElement = new LightRawJsonEncoder(jsonbOrigin).encodeContentAsJson(jsonbBlockDef.getJsonPathRoot());
                        record.setValue(jsonbBlockDef.getField(), (Object)jsonElement);
                    }
                    catch (Exception e) {
                        record.setValue(jsonbBlockDef.getField(), (Object)jsonbOrigin);
                        deleteList.add(jsonbBlockDef);
                    }
                }
                for (JsonbBlockDef deleteBlock : deleteList) {
                    queryStep.getJsonColumns().remove(deleteBlock);
                }
            });
        }
    }

    private static int columnIndex(List<Field> fields, String columnName) {
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!field.getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public static Result<Record> deleteNamedColumn(Result<Record> result, String columnName) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(result.fields()));
        int ndx = RawJsonTransform.columnIndex(fields, columnName);
        if (ndx >= 0) {
            fields.remove(ndx);
            Field[] arrayField = fields.toArray(new Field[0]);
            return result.into(arrayField);
        }
        return result;
    }
}

