/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryImpl;

import java.util.UUID;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.I_JoinBinder;
import org.ehrbase.aql.sql.queryImpl.I_QueryImpl;
import org.ehrbase.aql.sql.queryImpl.ObjectQuery;
import org.ehrbase.aql.sql.queryImpl.attribute.AttributePath;
import org.ehrbase.aql.sql.queryImpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryImpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryImpl.attribute.composer.ComposerResolver;
import org.ehrbase.aql.sql.queryImpl.attribute.composition.CompositionResolver;
import org.ehrbase.aql.sql.queryImpl.attribute.composition.FullCompositionJson;
import org.ehrbase.aql.sql.queryImpl.attribute.ehr.EhrResolver;
import org.ehrbase.aql.sql.queryImpl.attribute.eventcontext.EventContextResolver;
import org.ehrbase.service.IntrospectService;
import org.jooq.DSLContext;
import org.jooq.Field;

public class CompositionAttributeQuery
extends ObjectQuery
implements I_QueryImpl,
I_JoinBinder {
    private String serverNodeId;
    protected JoinSetup joinSetup = new JoinSetup();
    private final String entry_root;
    private final IntrospectService introspectCache;

    public CompositionAttributeQuery(DSLContext context, PathResolver pathResolver, String serverNodeId, String entry_root, IntrospectService introspectCache) {
        super(context, pathResolver);
        this.serverNodeId = serverNodeId;
        this.entry_root = entry_root;
        this.introspectCache = introspectCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Field<?> makeField(String templateId, UUID compositionId, String identifier, I_VariableDefinition variableDefinition, I_QueryImpl.Clause clause) {
        Field<?> retField;
        String columnAlias = variableDefinition.getPath();
        this.jsonDataBlock = false;
        FieldResolutionContext fieldResolutionContext = new FieldResolutionContext(this.context, this.serverNodeId, compositionId, identifier, variableDefinition, clause, this.pathResolver, this.introspectCache, this.entry_root);
        if (columnAlias == null) {
            if (clause.equals((Object)I_QueryImpl.Clause.SELECT)) {
                if (!this.pathResolver.classNameOf(variableDefinition.getIdentifier()).equals("COMPOSITION")) throw new IllegalArgumentException("Only full composition canonical json is supported at this stage, found class:" + this.pathResolver.classNameOf(variableDefinition.getIdentifier()));
                retField = new FullCompositionJson(fieldResolutionContext, this.joinSetup).sqlField();
            } else {
                retField = null;
            }
        } else if (this.pathResolver.classNameOf(variableDefinition.getIdentifier()).equals("EHR")) {
            retField = new EhrResolver(fieldResolutionContext, this.joinSetup).sqlField(columnAlias);
        } else {
            if (!this.pathResolver.classNameOf(variableDefinition.getIdentifier()).equals("COMPOSITION")) throw new IllegalArgumentException("INTERNAL: the following class cannot be resolved for AQL querying:" + this.pathResolver.classNameOf(variableDefinition.getIdentifier()));
            retField = columnAlias.startsWith("composer") ? new ComposerResolver(fieldResolutionContext, this.joinSetup).sqlField(new AttributePath("composer").redux(columnAlias)) : (columnAlias.startsWith("context") ? new EventContextResolver(fieldResolutionContext, this.joinSetup).sqlField(columnAlias) : new CompositionResolver(fieldResolutionContext, this.joinSetup).sqlField(columnAlias));
        }
        this.jsonDataBlock = fieldResolutionContext.isJsonDatablock();
        return retField;
    }

    @Override
    public Field<?> whereField(String templateId, UUID compositionId, String identifier, I_VariableDefinition variableDefinition) {
        return this.makeField(templateId, compositionId, identifier, variableDefinition, I_QueryImpl.Clause.WHERE);
    }

    public boolean isJoinComposition() {
        return this.joinSetup.isJoinComposition();
    }

    public boolean isJoinEventContext() {
        return this.joinSetup.isJoinEventContext();
    }

    public boolean isJoinSubject() {
        return this.joinSetup.isJoinSubject();
    }

    public boolean isJoinEhr() {
        return this.joinSetup.isJoinEhr();
    }

    public boolean isJoinSystem() {
        return this.joinSetup.isJoinSystem();
    }

    public boolean isJoinEhrStatus() {
        return this.joinSetup.isJoinEhrStatus();
    }

    public boolean isJoinComposer() {
        return this.joinSetup.isJoinComposer();
    }

    public boolean isJoinContextFacility() {
        return this.joinSetup.isJoinContextFacility();
    }

    public boolean containsEhrStatus() {
        return this.joinSetup.isContainsEhrStatus();
    }

    @Override
    public boolean isContainsJqueryPath() {
        return false;
    }

    @Override
    public String getJsonbItemPath() {
        return null;
    }

    public boolean useFromEntry() {
        return this.pathResolver.hasPathExpression();
    }
}

