/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryImpl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.ehrbase.aql.sql.queryImpl.I_IterativeNode;
import org.ehrbase.ehr.util.LocatableHelper;
import org.ehrbase.service.IntrospectService;

public class IterativeNode
implements I_IterativeNode {
    private final List<String> ignoreIterativeNode;
    private final List<Map> unbounded;
    private final int depth;

    public IterativeNode(String templateId, IntrospectService introspectCache, List<String> ignoreIterativeNode, int depth) throws Exception {
        this.ignoreIterativeNode = ignoreIterativeNode;
        this.unbounded = introspectCache.getQueryOptMetaData(templateId).upperNotBounded();
        this.depth = depth;
    }

    public Integer[] iterativeAt(List<String> segmentedPath) throws Exception {
        int marked = 0;
        ArrayList<Integer> retarray = new ArrayList<Integer>();
        if (this.unbounded.size() == 0) {
            retarray.add(-1);
        } else {
            String path = "/" + String.join((CharSequence)"/", this.compact(segmentedPath));
            for (int i = this.unbounded.size() - 1; i >= 0; --i) {
                Map mapEntry = this.unbounded.get(i);
                String aql_path = (String)mapEntry.get("aql_path");
                List<String> aqlPathSegments = LocatableHelper.dividePathIntoSegments(aql_path);
                boolean ignoreThisAqlPath = false;
                if (this.ignoreIterativeNode != null && this.ignoreIterativeNode.size() > 0) {
                    for (String ignoreItemRegex : this.ignoreIterativeNode) {
                        if (!aqlPathSegments.get(aqlPathSegments.size() - 1).matches(ignoreItemRegex)) continue;
                        ignoreThisAqlPath = true;
                        break;
                    }
                }
                if (ignoreThisAqlPath || !path.startsWith(aql_path)) continue;
                int pos = this.aqlPathInJsonbArray(aqlPathSegments, segmentedPath);
                retarray.add(pos);
                if (++marked >= this.depth) break;
            }
        }
        retarray.sort(Comparator.naturalOrder());
        return retarray.toArray(new Integer[0]);
    }

    public List<String> clipInIterativeMarker(List<String> segmentedPath, Integer[] clipPos) throws Exception {
        ArrayList<String> resultingPath = new ArrayList<String>();
        resultingPath.addAll(segmentedPath);
        for (Integer pos : clipPos) {
            resultingPath.set(pos, "$AQL_NODE_ITERATIVE$");
        }
        return resultingPath;
    }

    List<String> compact(List<String> segmentedPath) {
        ArrayList<String> resultPath = new ArrayList<String>();
        for (String item : segmentedPath) {
            try {
                Integer.parseInt(item);
            }
            catch (Exception e) {
                if (item.startsWith("/composition")) continue;
                if (item.startsWith("/")) {
                    if (item.equals("/events") || item.equals("/activities")) continue;
                    resultPath.add(item.substring(1));
                    continue;
                }
                resultPath.add(item);
            }
        }
        return resultPath;
    }

    int aqlPathInJsonbArray(List<String> aqlSegmented, List<String> jsonbSegmented) {
        int retval = 0;
        int aqlSegIndex = 0;
        int i = 0;
        while (aqlSegIndex < aqlSegmented.size()) {
            if (jsonbSegmented.get(i).startsWith("/composition")) {
                ++retval;
            } else {
                try {
                    Integer.parseInt(jsonbSegmented.get(i));
                    ++retval;
                }
                catch (Exception e) {
                    if (jsonbSegmented.get(retval).equals("/events") || jsonbSegmented.get(retval).equals("/activities")) {
                        ++retval;
                    }
                    try {
                        if (jsonbSegmented.get(retval).startsWith("/") ? !$assertionsDisabled && !jsonbSegmented.get(retval).substring(1).equals(aqlSegmented.get(aqlSegIndex)) : !$assertionsDisabled && !jsonbSegmented.get(retval).equals(aqlSegmented.get(aqlSegIndex))) {
                            throw new AssertionError();
                        }
                    }
                    catch (Exception e1) {
                        throw new IllegalArgumentException("Drift in locating array marker: aql:" + aqlSegmented.get(aqlSegIndex) + ", jsonb:" + jsonbSegmented.get(retval) + ", @index:" + retval);
                    }
                    ++retval;
                    ++aqlSegIndex;
                }
            }
            ++i;
        }
        return retval;
    }
}

