/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.I_JoinBinder;
import org.ehrbase.aql.sql.queryImpl.DefaultColumnId;
import org.ehrbase.aql.sql.queryImpl.EntryAttributeMapper;
import org.ehrbase.aql.sql.queryImpl.I_QueryImpl;
import org.ehrbase.aql.sql.queryImpl.IterativeNode;
import org.ehrbase.aql.sql.queryImpl.JsonbFunctionCall;
import org.ehrbase.aql.sql.queryImpl.NodeNameValuePredicate;
import org.ehrbase.aql.sql.queryImpl.NodePredicateCall;
import org.ehrbase.aql.sql.queryImpl.ObjectQuery;
import org.ehrbase.aql.sql.queryImpl.PGType;
import org.ehrbase.aql.sql.queryImpl.SegmentedPath;
import org.ehrbase.aql.sql.queryImpl.value_field.NodePredicate;
import org.ehrbase.ehr.util.LocatableHelper;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.service.IntrospectService;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class JsonbEntryQuery
extends ObjectQuery
implements I_QueryImpl {
    Logger logger = LogManager.getLogger(JsonbEntryQuery.class);
    private static final String JSONBSelector_COMPOSITION_OPEN = Tables.ENTRY.ENTRY_ + " #>> '{";
    public static final String Jsquery_COMPOSITION_OPEN = Tables.ENTRY.ENTRY_ + " @@ '";
    private static final String SELECT_EHR_OTHER_DETAILS_MACRO = I_JoinBinder.statusRecordTable.field((Field)Tables.STATUS.OTHER_DETAILS) + "->('/other_details')";
    private static final String JSONBSelector_EHR_OTHER_DETAILS_OPEN = SELECT_EHR_OTHER_DETAILS_MACRO + " #>> '{";
    public static final String Jsquery_EHR_OTHER_DETAILS_OPEN = SELECT_EHR_OTHER_DETAILS_MACRO + " @@ '";
    private static final String SELECT_EHR_OTHER_CONTEXT_MACRO = Tables.EVENT_CONTEXT.OTHER_CONTEXT + "->('/context/other_context[at0001]')";
    private static final String JSONBSelector_EHR_OTHER_CONTEXT_OPEN = SELECT_EHR_OTHER_CONTEXT_MACRO + " #>> '{";
    public static final String Jsquery_EHR_OTHER_CONTEXT_OPEN = SELECT_EHR_OTHER_CONTEXT_MACRO + " @@ '";
    public static final String matchNodePredicate = "(/(content|events|protocol|data|description|instruction|items|activities|activity|composition|entry|evaluation|observation|action)\\[([(0-9)|(A-Z)|(a-z)|\\-|_|\\.]*)\\])|(/value|/value,definingCode|/time|/name,0)";
    private static final String JSONBSelector_CLOSE = "}'";
    public static final String Jsquery_CLOSE = " '::jsquery";
    private static final String namedItemPrefix = " and name/value='";
    public static final String TAG_COMPOSITION = "/composition";
    public static final String TAG_CONTENT = "/content";
    private static boolean useEntry = false;
    private String jsonbItemPath;
    public static final String TAG_ACTIVITIES = "/activities";
    public static final String TAG_EVENTS = "/events";
    private static final String[] listIdentifier = new String[]{"/content", "/items", "/activities", "/events"};
    private boolean containsJqueryPath = false;
    private boolean ignoreUnresolvedIntrospect = false;
    private static String ENV_IGNORE_UNRESOLVED_INTROSPECT = "aql.ignoreUnresolvedIntrospect";
    private String entry_root;
    private IntrospectService introspectCache;

    public JsonbEntryQuery(DSLContext context, IntrospectService introspectCache, PathResolver pathResolver, String entry_root) {
        super(context, pathResolver);
        this.entry_root = entry_root;
        this.introspectCache = introspectCache;
        this.ignoreUnresolvedIntrospect = Boolean.parseBoolean(System.getProperty(ENV_IGNORE_UNRESOLVED_INTROSPECT, "false"));
    }

    private static boolean isList(String predicate) {
        if (predicate.equals(TAG_ACTIVITIES)) {
            return false;
        }
        for (String identifier : listIdentifier) {
            if (!predicate.startsWith(identifier)) continue;
            return true;
        }
        return false;
    }

    private static void encodeTreeMapNodeId(List<String> jqueryPath, String nodeId) {
        if (nodeId.startsWith(TAG_EVENTS)) {
            jqueryPath.add(TAG_EVENTS);
        } else if (nodeId.startsWith(TAG_ACTIVITIES)) {
            jqueryPath.add(TAG_ACTIVITIES);
        }
    }

    public List<String> jqueryPath(PATH_PART path_part, String path, String defaultIndex) {
        if (path == null) {
            this.jsonDataBlock = true;
            return new ArrayList<String>();
        }
        this.jsonDataBlock = false;
        int offset = 0;
        List<String> segments = LocatableHelper.dividePathIntoSegments(path);
        List<String> jqueryPath = new ArrayList<String>();
        Object nodeId = null;
        for (int i = offset; i < segments.size(); ++i) {
            nodeId = segments.get(i);
            nodeId = "/" + (String)nodeId;
            JsonbEntryQuery.encodeTreeMapNodeId(jqueryPath, (String)nodeId);
            NodePredicate nodePredicate = new NodePredicate((String)nodeId);
            if (path_part.equals((Object)PATH_PART.IDENTIFIER_PATH_PART)) {
                nodeId = nodePredicate.removeNameValuePredicate();
                jqueryPath.add((String)nodeId);
            } else if (path_part.equals((Object)PATH_PART.VARIABLE_PATH_PART)) {
                if (nodePredicate.hasPredicate()) {
                    jqueryPath = new NodeNameValuePredicate(nodePredicate).path(jqueryPath, (String)nodeId);
                } else {
                    nodeId = nodePredicate.removeNameValuePredicate();
                    jqueryPath.add((String)nodeId);
                }
            }
            if (!JsonbEntryQuery.isList((String)nodeId)) continue;
            if (path_part.equals((Object)PATH_PART.VARIABLE_PATH_PART) && i != segments.size() - 1) {
                jqueryPath.add(defaultIndex);
                continue;
            }
            if (!path_part.equals((Object)PATH_PART.IDENTIFIER_PATH_PART)) continue;
            jqueryPath.add(defaultIndex);
        }
        if (path_part.equals((Object)PATH_PART.VARIABLE_PATH_PART)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = jqueryPath.size() - 1; i >= 0 && !((String)jqueryPath.get(i)).matches("[0-9]*|#") && !((String)jqueryPath.get(i)).contains("[at"); --i) {
                String item = (String)jqueryPath.remove(i);
                stringBuffer.insert(0, item);
            }
            nodeId = EntryAttributeMapper.map(stringBuffer.toString());
            if (nodeId != null) {
                if (defaultIndex.equals("#")) {
                    if (((String)nodeId).contains(",")) {
                        String[] parts = ((String)nodeId).split(",");
                        jqueryPath.addAll(Arrays.asList(parts));
                    } else {
                        jqueryPath.add((String)nodeId);
                    }
                } else {
                    jqueryPath.add((String)nodeId);
                }
            }
        }
        useEntry = true;
        if (path_part.equals((Object)PATH_PART.VARIABLE_PATH_PART) && ((String)jqueryPath.get(jqueryPath.size() - 1)).matches(matchNodePredicate)) {
            this.jsonDataBlock = true;
        }
        return jqueryPath;
    }

    private int retrieveIndex(String nodeId) {
        if (nodeId.contains("#")) {
            Integer indexValue = Integer.valueOf(nodeId.split("#")[1].split("']")[0]);
            return indexValue;
        }
        return 0;
    }

    public Field<?> makeField(OTHER_ITEM type, String path, String alias, String variablePath, boolean withAlias) {
        Field fieldPathItem;
        ArrayList<String> itemPathArray = new ArrayList<String>();
        if (path != null) {
            itemPathArray.addAll(this.jqueryPath(PATH_PART.IDENTIFIER_PATH_PART, path, "0"));
        }
        itemPathArray.addAll(this.jqueryPath(PATH_PART.VARIABLE_PATH_PART, variablePath, "0"));
        this.resolveArrayIndex(itemPathArray);
        Object itemPath = StringUtils.join((Object[])itemPathArray.toArray(new String[0]), (String)",");
        itemPath = JsonbEntryQuery.wrapQuery((String)itemPath, type.equals((Object)OTHER_ITEM.OTHER_DETAILS) ? JSONBSelector_EHR_OTHER_DETAILS_OPEN : JSONBSelector_EHR_OTHER_CONTEXT_OPEN, JSONBSelector_CLOSE);
        if (((String)itemPathArray.get(itemPathArray.size() - 1)).contains("magnitude")) {
            itemPath = "(" + (String)itemPath + ")::float";
        }
        if (withAlias) {
            if (StringUtils.isNotEmpty((CharSequence)alias)) {
                fieldPathItem = DSL.field((String)itemPath, String.class).as(alias);
            } else {
                String tempAlias = "FIELD_" + JsonbEntryQuery.getSerial();
                fieldPathItem = DSL.field((String)itemPath, String.class).as(tempAlias);
            }
        } else {
            fieldPathItem = DSL.field((String)itemPath, String.class);
        }
        this.containsJqueryPath = true;
        useEntry = true;
        return fieldPathItem;
    }

    @Override
    public Field<?> makeField(String templateId, UUID compositionId, String identifier, I_VariableDefinition variableDefinition, I_QueryImpl.Clause clause) {
        String alias;
        Object path;
        boolean isRootContent = false;
        if (this.entry_root == null) {
            return null;
        }
        if (variableDefinition.getPath() != null && variableDefinition.getPath().startsWith("content")) {
            path = "/" + variableDefinition.getPath();
            isRootContent = true;
        } else {
            path = this.pathResolver.pathOf(variableDefinition.getIdentifier());
        }
        String string = alias = clause.equals((Object)I_QueryImpl.Clause.WHERE) ? null : variableDefinition.getAlias();
        if (path == null) {
            String cast = "";
            if (variableDefinition.getPath().endsWith("magnitude")) {
                cast = "::numeric";
            }
            if (alias != null) {
                return DSL.field((String)(DSL.val((String)null) + cast)).as(variableDefinition.getAlias());
            }
            return DSL.field((String)(DSL.val((String)null) + cast));
        }
        List<String> itemPathArray = new ArrayList<String>();
        itemPathArray.add(this.entry_root.replaceAll("'", "''"));
        if (!((String)path).startsWith(TAG_COMPOSITION) && !isRootContent) {
            itemPathArray.addAll(this.jqueryPath(PATH_PART.IDENTIFIER_PATH_PART, (String)path, "0"));
        }
        itemPathArray.addAll(this.jqueryPath(PATH_PART.VARIABLE_PATH_PART, variableDefinition.getPath(), "0"));
        if (clause.equals((Object)I_QueryImpl.Clause.SELECT)) {
            try {
                String[] ignoreIterativeOnRegexp = System.getenv("aql.arrays.ignoreNodeRegexp") != null ? System.getenv("aql.arrays.ignoreNodeRegexp").split(",") : new String[]{"^/content.*", "^/events.*"};
                int depth = 1;
                if (System.getenv("aql.arrays.depth") != null) {
                    depth = Integer.parseInt(System.getenv("aql.arrays.depth"));
                }
                IterativeNode iterativeNode = new IterativeNode(templateId, this.introspectCache, Arrays.asList(ignoreIterativeOnRegexp), depth);
                Integer[] pos = iterativeNode.iterativeAt(itemPathArray);
                itemPathArray = iterativeNode.clipInIterativeMarker(itemPathArray, pos);
            }
            catch (Exception ignoreIterativeOnRegexp) {
                // empty catch block
            }
        }
        this.resolveArrayIndex(itemPathArray);
        ArrayList<String> referenceItemPathArray = new ArrayList<String>();
        referenceItemPathArray.addAll(itemPathArray);
        Collections.replaceAll(referenceItemPathArray, "$AQL_NODE_ITERATIVE$", "0");
        if (itemPathArray.contains("$AQL_NODE_NAME_PREDICATE$")) {
            itemPathArray = new NodePredicateCall(itemPathArray).resolve();
        } else if (itemPathArray.contains("$AQL_NODE_ITERATIVE$")) {
            itemPathArray = new JsonbFunctionCall(itemPathArray, "$AQL_NODE_ITERATIVE$", "jsonb_array_elements").resolve();
        }
        Object itemPath = StringUtils.join((Object[])itemPathArray.toArray(new String[0]), (String)",");
        if (!((String)itemPath).startsWith("ehr.aql_node_name_predicate") && !((String)itemPath).contains("jsonb_array_elements")) {
            itemPath = JsonbEntryQuery.wrapQuery((String)itemPath, JSONBSelector_COMPOSITION_OPEN, JSONBSelector_CLOSE);
        }
        try {
            if (this.introspectCache == null) {
                throw new IllegalArgumentException("MetaDataCache is not initialized");
            }
            String reducedItemPathArray = new SegmentedPath(referenceItemPathArray).reduce();
            if (reducedItemPathArray != null && !reducedItemPathArray.isEmpty()) {
                String pgType;
                this.itemType = this.introspectCache.getQueryOptMetaData(templateId).type(reducedItemPathArray);
                if (this.itemType != null && (pgType = new PGType(itemPathArray).forRmType(this.itemType)) != null) {
                    itemPath = "(" + (String)itemPath + ")::" + pgType;
                }
            }
        }
        catch (Exception e) {
            if (!this.ignoreUnresolvedIntrospect) {
                throw new IllegalArgumentException("Unresolved type, missing template?(" + templateId + "), reason:" + e);
            }
            this.logger.warn("Ignoring unresolved introspect (reason:" + e + ")");
        }
        if (itemPathArray.get(itemPathArray.size() - 1).contains("magnitude")) {
            itemPath = "(" + (String)itemPath + ")::numeric";
        }
        Field fieldPathItem = null;
        if (clause.equals((Object)I_QueryImpl.Clause.SELECT)) {
            if (alias != null && StringUtils.isNotEmpty((CharSequence)alias)) {
                fieldPathItem = DSL.field((String)itemPath, String.class).as(alias);
            } else {
                String tempAlias = new DefaultColumnId().value(variableDefinition);
                fieldPathItem = DSL.field((String)itemPath, String.class).as(tempAlias);
            }
        } else {
            fieldPathItem = DSL.field((String)itemPath, String.class);
        }
        this.containsJqueryPath = true;
        useEntry = true;
        if (this.isJsonDataBlock()) {
            this.jsonbItemPath = this.toAqlPath(itemPathArray);
        }
        return fieldPathItem;
    }

    private String toAqlPath(List<String> itemPathArray) {
        ArrayList<String> aqlPath = new ArrayList<String>();
        for (String path : itemPathArray) {
            if (path.startsWith(TAG_COMPOSITION) || path.matches("[0-9]*")) continue;
            aqlPath.add(path);
        }
        return StringUtils.join((Object[])aqlPath.toArray(new String[0]));
    }

    @Override
    public Field<?> whereField(String templateId, UUID compositionId, String identifier, I_VariableDefinition variableDefinition) {
        String path = this.pathResolver.pathOf(variableDefinition.getIdentifier());
        if (path == null) {
            if (this.entry_root == null) {
                String compositionRootArchetype = this.pathResolver.rootOf(variableDefinition.getIdentifier());
                this.entry_root = "/composition[" + compositionRootArchetype + "]";
            } else {
                throw new IllegalArgumentException("Could not find a path for identifier:" + variableDefinition.getIdentifier());
            }
        }
        ArrayList<String> itemPathArray = new ArrayList<String>();
        if (this.entry_root == null) {
            throw new IllegalArgumentException("a name/value expression for composition must be specified, where clause cannot be built without");
        }
        itemPathArray.add(this.entry_root.replaceAll("'", "''"));
        if (path != null && !path.startsWith(TAG_COMPOSITION)) {
            itemPathArray.addAll(this.jqueryPath(PATH_PART.IDENTIFIER_PATH_PART, path, "#"));
        }
        itemPathArray.addAll(this.jqueryPath(PATH_PART.VARIABLE_PATH_PART, variableDefinition.getPath(), "#"));
        StringBuffer jsqueryPath = new StringBuffer();
        for (int i = 0; i < itemPathArray.size(); ++i) {
            if (!((String)itemPathArray.get(i)).equals("#")) {
                jsqueryPath.append("\"" + (String)itemPathArray.get(i) + "\"");
            } else {
                jsqueryPath.append((String)itemPathArray.get(i));
            }
            if (i >= itemPathArray.size() - 1) continue;
            jsqueryPath.append(".");
        }
        Field fieldPathItem = DSL.field((String)jsqueryPath.toString(), String.class);
        this.containsJqueryPath = true;
        useEntry = true;
        return fieldPathItem;
    }

    private void resolveArrayIndex(List<String> itemPathArray) {
        for (int i = 0; i < itemPathArray.size(); ++i) {
            String nodeId = itemPathArray.get(i);
            if (!nodeId.contains("#")) continue;
            Integer index = this.retrieveIndex(nodeId);
            if (i - 1 >= 0) {
                itemPathArray.set(i - 1, index.toString());
            }
            itemPathArray.set(i, nodeId);
        }
    }

    private static String wrapQuery(String itemPath, String open, String close) {
        if (itemPath.contains("/item_count")) {
            Object[] segments = itemPath.split("(?=(,[0-9]*,))");
            String pathPart = StringUtils.join((Object[])((String[])ArrayUtils.subarray((Object[])segments, (int)0, (int)(segments.length - 1))));
            return "jsonb_array_length(content #> '{" + pathPart + "}')";
        }
        return open + itemPath + close;
    }

    @Override
    public boolean isContainsJqueryPath() {
        return this.containsJqueryPath;
    }

    @Override
    public String getJsonbItemPath() {
        return this.jsonbItemPath;
    }

    public static enum OTHER_ITEM {
        OTHER_DETAILS,
        OTHER_CONTEXT;

    }

    public static enum PATH_PART {
        IDENTIFIER_PATH_PART,
        VARIABLE_PATH_PART;

    }
}

