/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryImpl.value_field;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.sql.queryImpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryImpl.attribute.GenericJsonPath;
import org.ehrbase.aql.sql.queryImpl.attribute.I_RMObjectAttribute;
import org.ehrbase.aql.sql.queryImpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryImpl.attribute.RMObjectAttribute;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableField;
import org.jooq.impl.DSL;

public class GenericJsonField
extends RMObjectAttribute {
    protected Optional<String> jsonPath = Optional.empty();
    private boolean isJsonDataBlock = true;

    public GenericJsonField(FieldResolutionContext fieldContext, JoinSetup joinSetup) {
        super(fieldContext, joinSetup);
    }

    public Field jsonField(String rmType, String plpgsqlFunction, TableField ... tableFields) {
        this.fieldContext.setJsonDatablock(this.isJsonDataBlock);
        this.fieldContext.setRmType(rmType);
        Field jsonContextField = this.jsonPath.isPresent() ? DSL.field((String)(plpgsqlFunction + "(" + StringUtils.join((Object[])tableFields, (String)",") + ")::json #>>" + this.jsonPath.get())) : DSL.field((String)(plpgsqlFunction + "(" + StringUtils.join((Object[])tableFields, (String)",") + ")::text"));
        return this.as(DSL.field((SelectField)jsonContextField));
    }

    public Field jsonField(String rmType, String plpgsqlFunction, Field ... fields) {
        this.fieldContext.setJsonDatablock(this.isJsonDataBlock);
        this.fieldContext.setRmType(rmType);
        Field jsonContextField = this.jsonPath.isPresent() ? DSL.field((String)(plpgsqlFunction + "(" + StringUtils.join((Object[])fields, (String)",") + ")::json #>>" + this.jsonPath.get())) : DSL.field((String)(plpgsqlFunction + "(" + StringUtils.join((Object[])fields, (String)",") + ")::text"));
        return this.as(DSL.field((SelectField)jsonContextField));
    }

    public Field sqlField() {
        return null;
    }

    @Override
    public I_RMObjectAttribute forTableField(TableField tableField) {
        return this;
    }

    public GenericJsonField forJsonPath(String jsonPath) {
        if (jsonPath == null || jsonPath.isEmpty()) {
            this.jsonPath = Optional.empty();
            return this;
        }
        this.jsonPath = Optional.of(new GenericJsonPath(jsonPath).jqueryPath());
        return this;
    }

    public GenericJsonField setJsonDataBlock(boolean jsonDataBlock) {
        this.isJsonDataBlock = jsonDataBlock;
        return this;
    }
}

