/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.configuration;

import java.net.URISyntaxException;
import java.util.UUID;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.ehrbase.opt.query.I_QueryOptMetaData;
import org.ehrbase.validation.Validator;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CacheConfiguration {
    public static final String INTROSPECT_CACHE = "introspectCache";
    public static final String OPERATIONAL_TEMPLATE_CACHE = "operationaltemplateCache";
    public static final String VALIDATOR_CACHE = "validatorCache";
    @Value(value="${cache.config}")
    private String configPath;
    @Value(value="${cache.enabled}")
    private boolean enabled;

    @Bean
    public CacheManager cacheManagerCustomizer() throws URISyntaxException {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = this.enabled ? cachingProvider.getCacheManager(this.getClass().getResource(this.configPath).toURI(), this.getClass().getClassLoader()) : cachingProvider.getCacheManager();
        CacheConfiguration.buildCache(INTROSPECT_CACHE, UUID.class, I_QueryOptMetaData.class, cacheManager, this.enabled);
        CacheConfiguration.buildCache(OPERATIONAL_TEMPLATE_CACHE, String.class, OPERATIONALTEMPLATE.class, cacheManager, this.enabled);
        CacheConfiguration.buildCache(VALIDATOR_CACHE, UUID.class, Validator.class, cacheManager, this.enabled);
        return cacheManager;
    }

    public static <K, V> void buildCache(String cacheName, Class<K> keyClass, Class<V> valueClass, CacheManager cacheManager, boolean enabled) {
        MutableConfiguration config = new MutableConfiguration();
        config.setTypes(keyClass, valueClass);
        config.setStoreByValue(false);
        if (!enabled) {
            config.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)Duration.ZERO));
        }
        cacheManager.createCache(cacheName, (javax.cache.configuration.Configuration)config);
    }
}

