/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.interfaces;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.EventContext;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.interfaces.I_SimpleCRUD;
import org.ehrbase.dao.access.jooq.CompositionAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.CompositionHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.CompositionRecord;
import org.ehrbase.jooq.pg.tables.records.ConceptRecord;
import org.ehrbase.jooq.pg.tables.records.EventContextRecord;
import org.ehrbase.jooq.pg.tables.records.IdentifierRecord;
import org.ehrbase.jooq.pg.tables.records.ParticipationRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.jooq.pg.tables.records.TerritoryRecord;
import org.jooq.Result;
import org.jooq.Table;

public interface I_CompositionAccess
extends I_SimpleCRUD {
    public static final String COMPOSITION_JOIN = "composition_join";
    public static final String COMPOSER_JOIN = "composer_ref";
    public static final String COMPOSER_ID = "composer_id";
    public static final String FACILITY_JOIN = "facility_ref";
    public static final String FACILITY_ID = "facility_id";
    public static final String EVENT_CONTEXT_JOIN = "event_context_ref";
    public static final String PARTICIPATION_JOIN = "participation_ref";
    public static final String PERFORMER_JOIN = "performer_ref";
    public static final String TERRITORY_JOIN = "territory_ref";
    public static final String CONCEPT_JOIN = "concept_ref";
    public static final String F_VERSION = "version";
    public static final String F_COMPOSITION_ID = "composition_id";
    public static final String F_ENTRY = "jsonb_entry";
    public static final String F_ENTRY_TEMPLATE = "template_id";
    public static final String F_LANGUAGE = "language";
    public static final String F_TERRITORY = "territory";
    public static final String F_TERRITORY_CODE = "territory_code";
    public static final String F_COMPOSER_NAME = "composer_name";
    public static final String F_COMPOSER_REF_VALUE = "composer_ref_value";
    public static final String F_COMPOSER_REF_SCHEME = "composer_ref_scheme";
    public static final String F_COMPOSER_REF_NAMESPACE = "composer_ref_namespace";
    public static final String F_COMPOSER_REF_TYPE = "composer_ref_type";
    public static final String F_COMPOSER_ID_VALUE = "composer_id_value";
    public static final String F_COMPOSER_ID_ISSUER = "composer_id_issuer";
    public static final String F_COMPOSER_ID_TYPE_NAME = "composer_id_type_name";
    public static final String F_CONTEXT_START_TIME = "context_start_time";
    public static final String F_CONTEXT_START_TIME_TZID = "context_start_time_tzid";
    public static final String F_CONTEXT_END_TIME = "context_end_time";
    public static final String F_CONTEXT_END_TIME_TZID = "context_end_time_tzid";
    public static final String F_CONTEXT_LOCATION = "context_location";
    public static final String F_CONTEXT_OTHER_CONTEXT = "context_other_context";
    public static final String F_FACILITY_NAME = "facility_name";
    public static final String F_FACILITY_REF_VALUE = "facility_ref_value";
    public static final String F_FACILITY_REF_SCHEME = "facility_ref_scheme";
    public static final String F_FACILITY_REF_NAMESPACE = "facility_ref_namespace";
    public static final String F_FACILITY_REF_TYPE = "facility_ref_type";
    public static final String F_FACILITY_ID_VALUE = "facility_id_value";
    public static final String F_FACILITY_ID_ISSUER = "facility_id_issuer";
    public static final String F_FACILITY_ID_TYPE_NAME = "facility_id_type_name";
    public static final String F_PARTICIPATION_FUNCTION = "participation_function";
    public static final String F_PARTICIPATION_MODE = "participation_mode";
    public static final String F_PARTICIPATION_START_TIME = "participation_start_time";
    public static final String F_PARTICIPATION_START_TIME_TZID = "participation_start_time_tzid";
    public static final String F_PERFORMER_NAME = "performer_name";
    public static final String F_PERFORMER_REF_VALUE = "performer_ref_value";
    public static final String F_PERFORMER_REF_SCHEME = "performer_ref_scheme";
    public static final String F_PERFORMER_REF_NAMESPACE = "performer_ref_namespace";
    public static final String F_PERFORMER_REF_TYPE = "performer_ref_type";
    public static final String F_PERFORMER_ID_VALUE = "performer_id_value";
    public static final String F_PERFORMER_ID_ISSUER = "performer_id_issuer";
    public static final String F_PERFORMER_ID_TYPE_NAME = "performer_id_type_name";
    public static final String F_CONCEPT_ID = "concept_id";
    public static final String F_CONCEPT_DESCRIPTION = "concept_description";
    public static final Table<CompositionRecord> compositionRef = Tables.COMPOSITION.as("composition_join");
    public static final Table<PartyIdentifiedRecord> composerRef = Tables.PARTY_IDENTIFIED.as("composer_ref");
    public static final Table<IdentifierRecord> composerId = Tables.IDENTIFIER.as("composer_id");
    public static final Table<PartyIdentifiedRecord> facilityRef = Tables.PARTY_IDENTIFIED.as("facility_ref");
    public static final Table<IdentifierRecord> facilityId = Tables.IDENTIFIER.as("facility_id");
    public static final Table<EventContextRecord> eventContextRef = Tables.EVENT_CONTEXT.as("event_context_ref");
    public static final Table<ParticipationRecord> participationRef = Tables.PARTICIPATION.as("participation_ref");
    public static final Table<PartyIdentifiedRecord> performerRef = Tables.PARTY_IDENTIFIED.as("performer_ref");
    public static final Table<TerritoryRecord> territoryRef = Tables.TERRITORY.as("territory_ref");
    public static final Table<ConceptRecord> conceptRef = Tables.CONCEPT.as("concept_ref");

    public static I_CompositionAccess getNewInstance(I_DomainAccess domain, Composition composition, UUID ehrId) {
        return new CompositionAccess(domain.getContext(), domain.getKnowledgeManager(), domain.getIntrospectService(), domain.getServerConfig(), composition, ehrId);
    }

    public static I_CompositionAccess retrieveCompositionVersion(I_DomainAccess domainAccess, UUID id, int version) {
        return CompositionAccess.retrieveCompositionVersion(domainAccess, id, version);
    }

    public static int getVersionFromTimeStamp(I_DomainAccess domainAccess, UUID vCompositionUid, Timestamp timeCommitted) {
        return CompositionAccess.getVersionFromTimeStamp(domainAccess, vCompositionUid, timeCommitted);
    }

    public static I_CompositionAccess retrieveInstanceByTimestamp(I_DomainAccess domainAccess, UUID compositionUid, Timestamp timeCommitted) {
        return CompositionAccess.retrieveInstanceByTimestamp(domainAccess, compositionUid, timeCommitted);
    }

    public static I_CompositionAccess retrieveInstance(I_DomainAccess domainAccess, UUID id) {
        return CompositionAccess.retrieveInstance(domainAccess, id);
    }

    public static Map<I_CompositionAccess, Integer> retrieveInstancesInContribution(I_DomainAccess domainAccess, UUID contributionId) {
        return CompositionAccess.retrieveCompositionsInContribution(domainAccess, contributionId);
    }

    public static boolean hasPreviousVersion(I_DomainAccess domainAccess, UUID compositionId) {
        return CompositionAccess.hasPreviousVersion(domainAccess, compositionId);
    }

    public static Map<I_CompositionAccess, Integer> getVersionMapOfComposition(I_DomainAccess domainAccess, UUID compositionId) {
        return I_CompositionAccess.getVersionMapOfComposition(domainAccess, compositionId);
    }

    public static Integer getLastVersionNumber(I_DomainAccess domainAccess, UUID compositionId) {
        return CompositionAccess.getLastVersionNumber(domainAccess, compositionId);
    }

    public static Integer fetchTerritoryCode(I_DomainAccess domainAccess, String territoryAsString) {
        Result result = domainAccess.getContext().selectFrom((Table)Tables.TERRITORY).where(Tables.TERRITORY.TWOLETTER.equal((Object)territoryAsString)).fetch();
        if (result.isEmpty()) {
            return -1;
        }
        return ((TerritoryRecord)result.get(0)).getCode();
    }

    public static boolean isValidLanguageCode(I_DomainAccess domainAccess, String languageCode) {
        return !domainAccess.getContext().selectFrom((Table)Tables.LANGUAGE).where(Tables.LANGUAGE.CODE.equal((Object)languageCode)).fetch().isEmpty();
    }

    public UUID commit(UUID var1, UUID var2, String var3);

    public UUID commitWithCustomContribution(UUID var1, UUID var2, String var3);

    public Boolean update(UUID var1, UUID var2, ContributionDef.ContributionState var3, I_ConceptAccess.ContributionChangeType var4, String var5);

    public Boolean updateWithCustomContribution(UUID var1, UUID var2, I_ConceptAccess.ContributionChangeType var3, String var4);

    public Integer delete(UUID var1, UUID var2, String var3);

    public Integer deleteWithCustomContribution(UUID var1, UUID var2, String var3);

    public Timestamp getSysTransaction();

    public Timestamp getTimeCommitted();

    public UUID getId();

    public UUID getEhrid();

    public void setEhrid(UUID var1);

    public UUID getComposerId();

    public void setComposerId(UUID var1);

    public Optional<UUID> getContextId();

    public UUID getContributionId();

    public String getLanguageCode();

    public void setLanguageCode(String var1);

    public Integer getTerritoryCode();

    public void setTerritoryCode(Integer var1);

    public List<UUID> getContentIds();

    public void setContextCompositionId(UUID var1);

    public int addContent(I_EntryAccess var1);

    public List<I_EntryAccess> getContent();

    public void setContent(List<I_EntryAccess> var1);

    public void setContributionId(UUID var1);

    public void setCompositionRecord(CompositionRecord var1);

    public void setCompositionRecord(CompositionHistoryRecord var1);

    public void setCompositionRecord(Result<?> var1);

    public void setComposition(Composition var1);

    public void setContributionAccess(I_ContributionAccess var1);

    public void setAuditDetailsAccess(I_AuditDetailsAccess var1);

    public Integer getVersion();

    public void updateCompositionData(Composition var1);

    public void setContext(EventContext var1);

    public UUID getAuditDetailsId();

    public void setAuditDetailsId(UUID var1);

    public static boolean exists(I_DomainAccess domainAccess, UUID versionedObjectId) {
        return CompositionAccess.exists(domainAccess, versionedObjectId);
    }

    public static boolean isDeleted(I_DomainAccess domainAccess, UUID versionedObjectId) {
        return CompositionAccess.isDeleted(domainAccess, versionedObjectId);
    }
}

