/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.interfaces;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.ehr.EhrStatus;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_SimpleCRUD;
import org.ehrbase.dao.access.interfaces.I_StatusAccess;
import org.ehrbase.dao.access.jooq.EhrAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.EhrRecord;
import org.jooq.Table;

public interface I_EhrAccess
extends I_SimpleCRUD {
    public static final String TAG_TEMPLATE_ID = "$TEMPLATE_ID$";

    public static I_EhrAccess getInstance(I_DomainAccess domain, UUID partyId, UUID systemId, UUID directoryId, UUID accessId, UUID ehrId) {
        return new EhrAccess(domain.getContext(), domain.getServerConfig(), partyId, systemId, directoryId, accessId, ehrId);
    }

    public static UUID retrieveInstanceBySubject(I_DomainAccess domainAccess, String subjectId, String issuerSpace) {
        return EhrAccess.retrieveInstanceBySubject(domainAccess, subjectId, issuerSpace);
    }

    public static UUID retrieveInstanceBySubject(I_DomainAccess domainAccess, UUID subjectUuid) {
        return EhrAccess.retrieveInstanceBySubject(domainAccess, subjectUuid);
    }

    public static UUID retrieveInstanceBySubjectExternalRef(I_DomainAccess domainAccess, String subjectId, String issuerSpace) {
        return EhrAccess.retrieveInstanceBySubjectExternalRef(domainAccess, subjectId, issuerSpace);
    }

    public static I_EhrAccess retrieveInstanceByStatus(I_DomainAccess domainAccess, UUID ehrId, UUID status, int version) {
        return EhrAccess.retrieveInstanceByStatus(domainAccess, ehrId, status, (Integer)version);
    }

    public static boolean checkExist(I_DomainAccess domainAccess, UUID partyId) {
        return domainAccess.getContext().fetchExists((Table)Tables.STATUS, Tables.STATUS.PARTY.eq((Object)partyId));
    }

    public static I_EhrAccess retrieveInstance(I_DomainAccess domainAccess, UUID ehrId) {
        return EhrAccess.retrieveInstance(domainAccess, ehrId);
    }

    public static Map<String, Object> fetchSubjectIdentifiers(I_DomainAccess domainAccess, UUID ehrId) {
        return EhrAccess.fetchSubjectIdentifiers(domainAccess, ehrId);
    }

    public static Map<String, Map<String, String>> getCompositionList(I_DomainAccess domainAccess, UUID ehrId) {
        return EhrAccess.getCompositionList(domainAccess, ehrId);
    }

    public void setModifiable(Boolean var1);

    public void setQueryable(Boolean var1);

    public UUID commit(UUID var1, UUID var2, String var3);

    public Boolean update(UUID var1, UUID var2, ContributionDef.ContributionState var3, I_ConceptAccess.ContributionChangeType var4, String var5);

    public void setAccess(UUID var1);

    public void setDirectory(UUID var1);

    public void setSystem(UUID var1);

    public UUID reload();

    public boolean isNew();

    public UUID getParty();

    public void setParty(UUID var1);

    public UUID getId();

    public Boolean isModifiable();

    public Boolean isQueryable();

    public UUID getSystemId();

    public UUID getStatusId();

    public UUID getDirectoryId();

    public UUID getAccessId();

    public void setContributionAccess(I_ContributionAccess var1);

    public I_StatusAccess getStatusAccess();

    public void setStatusAccess(I_StatusAccess var1);

    public void setOtherDetails(ItemStructure var1, String var2);

    public ItemStructure getOtherDetails();

    public EhrRecord getEhrRecord();

    public void setStatus(EhrStatus var1);

    public EhrStatus getStatus();

    public Integer getLastVersionNumberOfStatus(I_DomainAccess var1, UUID var2);

    public int getEhrStatusVersionFromTimeStamp(Timestamp var1);

    public Timestamp getInitialTimeOfVersionedEhrStatus();

    public Integer getNumberOfEhrStatusVersions();
}

