/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.interfaces;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.List;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_SimpleCRUD;
import org.ehrbase.dao.access.jooq.PartyIdentifiedAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.IdentifierRecord;
import org.jooq.Table;

public interface I_PartyIdentifiedAccess
extends I_SimpleCRUD {
    public static I_PartyIdentifiedAccess getInstance(I_DomainAccess domain, String partyName) {
        return new PartyIdentifiedAccess(domain.getContext(), domain.getServerConfig(), partyName);
    }

    public static UUID retrievePartyIdByPartyName(I_DomainAccess domainAccess, String partyName) {
        return PartyIdentifiedAccess.retrievePartyIdByPartyName(domainAccess, partyName);
    }

    public static I_PartyIdentifiedAccess retrieveInstance(I_DomainAccess domainAccess, UUID id) {
        return PartyIdentifiedAccess.retrieveInstance(domainAccess, id);
    }

    public static int deleteInstance(I_DomainAccess domainAccess, UUID id) {
        domainAccess.getContext().delete((Table)Tables.IDENTIFIER).where(Tables.IDENTIFIER.PARTY.eq((Object)id)).execute();
        return domainAccess.getContext().delete((Table)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)id)).execute();
    }

    public static UUID retrievePartyByIdentifier(I_DomainAccess domainAccess, String value, String issuer) {
        UUID uuid = ((IdentifierRecord)domainAccess.getContext().fetchAny((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.ID_VALUE.eq((Object)value).and(Tables.IDENTIFIER.ISSUER.eq((Object)issuer)))).getParty();
        return uuid;
    }

    public static UUID getOrCreateParty(I_DomainAccess domainAccess, String name, String value, String issuer, String assigner, String type) {
        return PartyIdentifiedAccess.getOrCreateParty(domainAccess, name, value, issuer, assigner, type);
    }

    public static UUID getOrCreatePartyByExternalRef(I_DomainAccess domainAccess, String name, String code, String scheme, String namespace, String type) {
        PartyIdentified partyIdentified = new PartyIdentified(new PartyRef((ObjectId)new GenericId(code, scheme), namespace, type), name, null);
        return PartyIdentifiedAccess.getOrCreateParty(domainAccess, partyIdentified);
    }

    public static UUID getOrCreateParty(I_DomainAccess domainAccess, PartyIdentified partyIdentified) {
        return PartyIdentifiedAccess.getOrCreateParty(domainAccess, partyIdentified);
    }

    public static UUID getOrCreatePartySelf(I_DomainAccess domainAccess) {
        return PartyIdentifiedAccess.getOrCreatePartySelf(domainAccess);
    }

    public static PartyProxy retrievePartyIdentified(I_DomainAccess domainAccess, UUID id) {
        return PartyIdentifiedAccess.retrievePartyProxy(domainAccess, id);
    }

    public static UUID findIdentifiedParty(I_DomainAccess domainAccess, List<DvIdentifier> identifierList) {
        return PartyIdentifiedAccess.findIdentifiedParty(domainAccess.getContext(), identifierList);
    }

    public static UUID findReferencedParty(I_DomainAccess domainAccess, PartyRef partyRef) {
        return PartyIdentifiedAccess.findReferencedParty(domainAccess.getContext(), partyRef);
    }

    public static UUID findReferencedParty(I_DomainAccess domainAccess, String value, String scheme, String namespace, String type) {
        PartyRef partyRef = new PartyRef((ObjectId)new GenericId(value, scheme), namespace, type);
        return PartyIdentifiedAccess.findReferencedParty(domainAccess.getContext(), partyRef);
    }

    public Integer addIdentifier(String var1, String var2, String var3, String var4);

    public Integer deleteIdentifier(String var1, String var2);

    public String getPartyName();

    public void setPartyName(String var1);

    public String getPartyRefValue();

    public String getPartyRefNamespace();

    public String[] getIdentifiersKeySet();

    public UUID getId();
}

