/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.compiler.AqlExpression;
import org.ehrbase.aql.compiler.AqlExpressionWithParameters;
import org.ehrbase.aql.compiler.Contains;
import org.ehrbase.aql.compiler.Statements;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.AqlResult;
import org.ehrbase.aql.sql.QueryProcessor;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.support.DataAccess;

public class AqlQueryHandler
extends DataAccess {
    private boolean usePgExtensions;

    public AqlQueryHandler(I_DomainAccess domainAccess, boolean usePgExtensions) {
        super(domainAccess);
        this.usePgExtensions = usePgExtensions;
    }

    public AqlResult process(String query) {
        AqlExpression aqlExpression = new AqlExpression().parse(query);
        return this.execute(aqlExpression);
    }

    public AqlResult process(String query, Map<String, Object> parameters) {
        AqlExpressionWithParameters aqlExpression = new AqlExpressionWithParameters().parse(query, parameters);
        return this.execute(aqlExpression);
    }

    private AqlResult execute(AqlExpression aqlExpression) {
        Contains contains = new Contains(aqlExpression.getParseTree()).process();
        Statements statements = new Statements(aqlExpression.getParseTree(), contains.getIdentifierMapper()).process();
        QueryProcessor queryProcessor = new QueryProcessor(this.getContext(), this.getKnowledgeManager(), this.getIntrospectService(), contains, statements, this.getDataAccess().getServerConfig().getNodename(), this.usePgExtensions);
        AqlResult aqlResult = queryProcessor.execute();
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        Iterator<I_VariableDefinition> iterator = statements.getVariables().iterator();
        int serial = 0;
        while (iterator.hasNext()) {
            I_VariableDefinition variableDefinition = iterator.next();
            if (variableDefinition.isHidden()) continue;
            variables.put((String)(variableDefinition.getAlias() == null ? "#" + serial++ : variableDefinition.getAlias()), (String)(StringUtils.isNotBlank((CharSequence)variableDefinition.getPath()) ? "/" + variableDefinition.getPath() : variableDefinition.getIdentifier()));
        }
        aqlResult.setVariables(variables);
        return aqlResult;
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

