/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.tables.records.AuditDetailsRecord;
import org.jooq.Table;

public class AuditDetailsAccess
extends DataAccess
implements I_AuditDetailsAccess {
    private AuditDetailsRecord auditDetailsRecord;

    public AuditDetailsAccess(I_DomainAccess dataAccess) {
        super(dataAccess.getContext(), null, null, dataAccess.getServerConfig());
        this.auditDetailsRecord = (AuditDetailsRecord)dataAccess.getContext().newRecord((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS);
    }

    public AuditDetailsAccess(I_DomainAccess dataAccess, UUID systemId, UUID committer, I_ConceptAccess.ContributionChangeType changeType, String description) {
        super(dataAccess.getContext(), null, null, dataAccess.getServerConfig());
        this.auditDetailsRecord = (AuditDetailsRecord)dataAccess.getContext().newRecord((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS);
        this.auditDetailsRecord.setSystemId(systemId);
        this.auditDetailsRecord.setCommitter(committer);
        this.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, changeType));
        this.auditDetailsRecord.setDescription(description);
    }

    @Override
    public I_AuditDetailsAccess retrieveInstance(I_DomainAccess dataAccess, UUID auditId) {
        AuditDetailsAccess auditDetailsAccess = new AuditDetailsAccess(dataAccess);
        try {
            auditDetailsAccess.auditDetailsRecord = (AuditDetailsRecord)dataAccess.getContext().fetchOne((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS, org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS.ID.eq((Object)auditId));
        }
        catch (Exception e) {
            throw new InternalServerException("fetching audit_details failed", e);
        }
        if (auditDetailsAccess.auditDetailsRecord == null) {
            return null;
        }
        return auditDetailsAccess;
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.auditDetailsRecord.setTimeCommitted(transactionTime);
        this.auditDetailsRecord.setTimeCommittedTzid(ZonedDateTime.now().getZone().getId());
        int result = this.auditDetailsRecord.insert();
        if (result == 1) {
            return this.auditDetailsRecord.getId();
        }
        throw new InternalServerException("Couldn't store auditDetails, DB problem");
    }

    @Override
    public UUID commit() {
        return this.commit(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public UUID commit(UUID systemId, UUID committerId, String description) {
        if (systemId == null || committerId == null) {
            throw new IllegalArgumentException("arguments not optional");
        }
        this.auditDetailsRecord.setSystemId(systemId);
        this.auditDetailsRecord.setCommitter(committerId);
        if (description != null) {
            this.auditDetailsRecord.setDescription(description);
        }
        this.auditDetailsRecord.setChangeType(ContributionChangeType.creation);
        return this.commit();
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        boolean result = false;
        if (force || this.auditDetailsRecord.changed()) {
            this.auditDetailsRecord.setId(UUID.randomUUID());
            result = this.auditDetailsRecord.insert() == 1;
        }
        return result;
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(Timestamp.valueOf(LocalDateTime.now()), false);
    }

    @Override
    public Boolean update(Boolean force) {
        return this.update(Timestamp.valueOf(LocalDateTime.now()), force);
    }

    @Override
    public Boolean update() {
        return this.update(false);
    }

    @Override
    public Boolean update(UUID systemId, UUID committer, I_ConceptAccess.ContributionChangeType changeType, String description) {
        if (systemId != null) {
            this.setSystemId(systemId);
        }
        if (committer != null) {
            this.setCommitter(committer);
        }
        if (changeType != null) {
            this.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, changeType));
        }
        if (description != null) {
            this.setDescription(description);
        }
        return this.update();
    }

    @Override
    public Integer delete() {
        return this.auditDetailsRecord.delete();
    }

    @Override
    public UUID getId() {
        return this.auditDetailsRecord.getId();
    }

    @Override
    public void setSystemId(UUID systemId) {
        this.auditDetailsRecord.setSystemId(systemId);
    }

    @Override
    public UUID getSystemId() {
        return this.auditDetailsRecord.getSystemId();
    }

    @Override
    public void setCommitter(UUID committer) {
        this.auditDetailsRecord.setCommitter(committer);
    }

    @Override
    public UUID getCommitter() {
        return this.auditDetailsRecord.getCommitter();
    }

    @Override
    public void setChangeType(UUID changeType) {
        String changeTypeString = I_ConceptAccess.fetchConceptLiteral(this, changeType);
        this.auditDetailsRecord.setChangeType(ContributionChangeType.valueOf((String)changeTypeString));
    }

    @Override
    public void setChangeType(I_ConceptAccess.ContributionChangeType changeType) {
        this.auditDetailsRecord.setChangeType(ContributionChangeType.valueOf((String)changeType.name()));
    }

    @Override
    public ContributionChangeType getChangeType() {
        return this.auditDetailsRecord.getChangeType();
    }

    @Override
    public void setDescription(String description) {
        this.auditDetailsRecord.setDescription(description);
    }

    @Override
    public String getDescription() {
        return this.auditDetailsRecord.getDescription();
    }

    @Override
    public Timestamp getTimeCommitted() {
        return this.auditDetailsRecord.getTimeCommitted();
    }

    @Override
    public String getTimeCommittedTzId() {
        return this.auditDetailsRecord.getTimeCommittedTzid();
    }

    @Override
    public void setRecord(AuditDetailsRecord record) {
        this.auditDetailsRecord = record;
    }

    @Override
    public AuditDetails getAsAuditDetails() {
        String systemId = this.getSystemId().toString();
        PartyProxy party = I_PartyIdentifiedAccess.retrievePartyIdentified(this, this.getCommitter());
        DvDateTime time = new DvDateTime((TemporalAccessor)this.getTimeCommitted().toLocalDateTime());
        DvCodedText changeType = new DvCodedText(this.getChangeType().getName(), new CodePhrase("openehr"));
        DvText description = new DvText(this.getDescription());
        return new AuditDetails(systemId, party, time, changeType, description);
    }
}

