/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartySelf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContextAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.jooq.CompositionHistoryAccess;
import org.ehrbase.dao.access.jooq.EventContextFactory;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.records.AuditDetailsRecord;
import org.ehrbase.jooq.pg.tables.records.CompositionHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.CompositionRecord;
import org.ehrbase.jooq.pg.tables.records.EventContextRecord;
import org.ehrbase.service.IntrospectService;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class CompositionAccess
extends DataAccess
implements I_CompositionAccess {
    private static final Logger log = LogManager.getLogger(CompositionAccess.class);
    private List<I_EntryAccess> content = new ArrayList<I_EntryAccess>();
    private CompositionRecord compositionRecord;
    private I_ContributionAccess contributionAccess = null;
    private I_AuditDetailsAccess auditDetailsAccess;
    private Composition composition;

    public CompositionAccess(DSLContext context, I_KnowledgeCache knowledgeManager, IntrospectService introspectCache, ServerConfig serverConfig, Composition composition, UUID ehrId) {
        super(context, knowledgeManager, introspectCache, serverConfig);
        this.composition = composition;
        String territoryCode = composition.getTerritory().getCodeString();
        String languageCode = composition.getLanguage().getCodeString();
        UUID composerId = this.seekComposerId(composition.getComposer());
        this.compositionRecord = (CompositionRecord)context.newRecord((Table)Tables.COMPOSITION);
        this.compositionRecord.setId(UUID.randomUUID());
        this.compositionRecord.setTerritory(this.seekTerritoryCode(territoryCode));
        this.compositionRecord.setLanguage(this.seekLanguageCode(languageCode));
        this.compositionRecord.setActive(Boolean.valueOf(true));
        this.compositionRecord.setComposer(composerId);
        this.compositionRecord.setEhrId(ehrId);
        this.contributionAccess = I_ContributionAccess.getInstance(this, this.compositionRecord.getEhrId());
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.auditDetailsAccess = I_AuditDetailsAccess.getInstance(this.getDataAccess());
    }

    public CompositionAccess(I_DomainAccess domainAccess, Composition composition, UUID ehrId) {
        super(domainAccess);
        this.composition = composition;
        String territoryCode = composition.getTerritory().getCodeString();
        String languageCode = composition.getLanguage().getCodeString();
        UUID composerId = this.seekComposerId(composition.getComposer());
        this.compositionRecord = (CompositionRecord)domainAccess.getContext().newRecord((Table)Tables.COMPOSITION);
        this.compositionRecord.setId(UUID.randomUUID());
        this.compositionRecord.setTerritory(this.seekTerritoryCode(territoryCode));
        this.compositionRecord.setLanguage(this.seekLanguageCode(languageCode));
        this.compositionRecord.setActive(Boolean.valueOf(true));
        this.compositionRecord.setComposer(composerId);
        this.compositionRecord.setEhrId(ehrId);
        this.contributionAccess = I_ContributionAccess.getInstance(this, this.compositionRecord.getEhrId());
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.auditDetailsAccess = I_AuditDetailsAccess.getInstance(this.getDataAccess());
    }

    private CompositionAccess(I_DomainAccess domainAccess, CompositionRecord compositionRecord) {
        super(domainAccess);
        this.compositionRecord = compositionRecord;
        this.contributionAccess = I_ContributionAccess.getInstance(this, compositionRecord.getEhrId());
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.auditDetailsAccess = I_AuditDetailsAccess.getInstance(this.getDataAccess());
    }

    CompositionAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public static I_CompositionAccess retrieveCompositionVersion(I_DomainAccess domainAccess, UUID id, int version) {
        if (version < 1) {
            throw new IllegalArgumentException("Version number must be > 0  please check your code");
        }
        if (CompositionAccess.getLastVersionNumber(domainAccess, id) == version) {
            return CompositionAccess.retrieveInstance(domainAccess, id);
        }
        String versionQuery = "select row_id, in_contribution, ehr_id, language, territory, composer, sys_transaction, has_audit from \n  (select ROW_NUMBER() OVER (ORDER BY sys_transaction ASC ) AS row_id, * from ehr.composition_history WHERE id = ?) \n    AS Version WHERE row_id = ?;";
        Connection connection = domainAccess.getConnection();
        I_CompositionAccess compositionHistoryAccess = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement(versionQuery);){
            preparedStatement.setObject(1, id);
            preparedStatement.setInt(2, version);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    CompositionRecord compositionRecord1 = (CompositionRecord)domainAccess.getContext().newRecord((Table)Tables.COMPOSITION);
                    compositionRecord1.setId(id);
                    compositionRecord1.setInContribution(UUID.fromString(resultSet.getString("in_contribution")));
                    compositionRecord1.setEhrId(UUID.fromString(resultSet.getString("ehr_id")));
                    compositionRecord1.setLanguage(resultSet.getString("language"));
                    compositionRecord1.setTerritory(Integer.valueOf(resultSet.getInt("territory")));
                    compositionRecord1.setComposer(UUID.fromString(resultSet.getString("composer")));
                    compositionRecord1.setSysTransaction(resultSet.getTimestamp("sys_transaction"));
                    compositionRecord1.setHasAudit(UUID.fromString(resultSet.getString("has_audit")));
                    compositionHistoryAccess = new CompositionAccess(domainAccess, compositionRecord1);
                }
            }
        }
        catch (SQLException e) {
            throw new ObjectNotFoundException("composition", "Composition not found or or invalid DB content", (Throwable)e);
        }
        if (compositionHistoryAccess != null) {
            compositionHistoryAccess.setContent(I_EntryAccess.retrieveInstanceInCompositionVersion(domainAccess, compositionHistoryAccess, version));
            I_ContributionAccess contributionAccess = I_ContributionAccess.retrieveVersionedInstance(domainAccess, compositionHistoryAccess.getContributionId(), compositionHistoryAccess.getSysTransaction());
            compositionHistoryAccess.setContributionAccess(contributionAccess);
            I_AuditDetailsAccess auditDetailsAccess = new AuditDetailsAccess(domainAccess.getDataAccess()).retrieveInstance(domainAccess.getDataAccess(), compositionHistoryAccess.getAuditDetailsId());
            compositionHistoryAccess.setAuditDetailsAccess(auditDetailsAccess);
            EventContext historicalEventContext = I_ContextAccess.retrieveHistoricalEventContext(domainAccess, id, compositionHistoryAccess.getSysTransaction());
            if (historicalEventContext != null) {
                for (I_EntryAccess entryAccess : compositionHistoryAccess.getContent()) {
                    entryAccess.getComposition().setContext(historicalEventContext);
                }
            }
        }
        domainAccess.releaseConnection(connection);
        return compositionHistoryAccess;
    }

    public static Integer getLastVersionNumber(I_DomainAccess domainAccess, UUID compositionId) {
        if (domainAccess.getContext().fetchExists((Table)Tables.COMPOSITION, Tables.COMPOSITION.ID.eq((Object)compositionId))) {
            return 1 + domainAccess.getContext().fetchCount((Table)Tables.COMPOSITION_HISTORY, Tables.COMPOSITION_HISTORY.ID.eq((Object)compositionId));
        }
        return domainAccess.getContext().fetchCount((Table)Tables.COMPOSITION_HISTORY, Tables.COMPOSITION_HISTORY.ID.eq((Object)compositionId));
    }

    public static boolean hasPreviousVersion(I_DomainAccess domainAccess, UUID compositionId) {
        return domainAccess.getContext().fetchExists((Table)Tables.COMPOSITION_HISTORY, Tables.COMPOSITION_HISTORY.ID.eq((Object)compositionId));
    }

    public static I_CompositionAccess retrieveInstance(I_DomainAccess domainAccess, UUID id) {
        CompositionAccess compositionAccess = new CompositionAccess(domainAccess);
        CompositionRecord compositionRecord = (CompositionRecord)domainAccess.getContext().selectFrom((Table)Tables.COMPOSITION).where(Tables.COMPOSITION.ID.eq((Object)id)).fetchOne();
        if (compositionRecord == null) {
            return null;
        }
        compositionAccess.setCompositionRecord(compositionRecord);
        compositionAccess.setContent(I_EntryAccess.retrieveInstanceInComposition(domainAccess, compositionAccess));
        I_ContributionAccess contributionAccess = I_ContributionAccess.retrieveInstance(domainAccess, compositionAccess.getContributionId());
        compositionAccess.setContributionAccess(contributionAccess);
        I_AuditDetailsAccess auditAccess = new AuditDetailsAccess(domainAccess.getDataAccess()).retrieveInstance(domainAccess.getDataAccess(), compositionAccess.getAuditDetailsId());
        compositionAccess.setAuditDetailsAccess(auditAccess);
        return compositionAccess;
    }

    public static int getVersionFromTimeStamp(I_DomainAccess domainAccess, UUID vCompositionUid, Timestamp timeCommitted) {
        Record result2;
        Record result;
        if (timeCommitted == null) {
            return CompositionAccess.getLastVersionNumber(domainAccess, vCompositionUid);
        }
        try {
            result = domainAccess.getContext().select((SelectField)DSL.max((Field)Tables.COMPOSITION.SYS_TRANSACTION).as("mostRecentInTable")).from((TableLike)Tables.COMPOSITION).where(Tables.COMPOSITION.ID.eq((Object)vCompositionUid)).fetchOne();
        }
        catch (RuntimeException e) {
            throw new InternalServerException("Problem with SQL statement or input", (Exception)e);
        }
        Timestamp latestCompoTime = (Timestamp)result.get("mostRecentInTable");
        try {
            result2 = domainAccess.getContext().select((SelectField)DSL.count().as("countVersionInTable")).from((TableLike)Tables.COMPOSITION_HISTORY).where(Tables.COMPOSITION_HISTORY.SYS_TRANSACTION.lessOrEqual((Object)timeCommitted).and(Tables.COMPOSITION_HISTORY.ID.eq((Object)vCompositionUid))).fetchOne();
        }
        catch (RuntimeException e) {
            throw new InternalServerException("Problem with SQL statement or input", (Exception)e);
        }
        int versionComHist = (Integer)result2.get("countVersionInTable");
        if (timeCommitted.compareTo(latestCompoTime) >= 0) {
            ++versionComHist;
        }
        if (versionComHist == 0) {
            throw new IllegalArgumentException("There are no versions available prior to date " + timeCommitted + " for the the composition with id: " + vCompositionUid);
        }
        return versionComHist;
    }

    public static I_CompositionAccess retrieveInstanceByTimestamp(I_DomainAccess domainAccess, UUID compositionUid, Timestamp timeCommitted) {
        int version = CompositionAccess.getVersionFromTimeStamp(domainAccess, compositionUid, timeCommitted);
        if (CompositionAccess.getLastVersionNumber(domainAccess, compositionUid) == version) {
            return CompositionAccess.retrieveInstance(domainAccess, compositionUid);
        }
        return CompositionAccess.retrieveCompositionVersion(domainAccess, compositionUid, version);
    }

    public static Map<I_CompositionAccess, Integer> retrieveCompositionsInContribution(I_DomainAccess domainAccess, UUID contribution) {
        HashSet compositions = new HashSet();
        domainAccess.getContext().select((SelectField)Tables.COMPOSITION.ID).from((TableLike)Tables.COMPOSITION).where(Tables.COMPOSITION.IN_CONTRIBUTION.eq((Object)contribution)).fetch().forEach(rec -> compositions.add((UUID)rec.value1()));
        domainAccess.getContext().select((SelectField)Tables.COMPOSITION_HISTORY.ID).from((TableLike)Tables.COMPOSITION_HISTORY).where(Tables.COMPOSITION_HISTORY.IN_CONTRIBUTION.eq((Object)contribution)).fetch().forEach(rec -> compositions.add((UUID)rec.value1()));
        HashMap<I_CompositionAccess, Integer> resultMap = new HashMap<I_CompositionAccess, Integer>();
        for (UUID compositionId : compositions) {
            Map<I_CompositionAccess, Integer> map = CompositionAccess.getVersionMapOfComposition(domainAccess, compositionId);
            for (Map.Entry<I_CompositionAccess, Integer> entry : map.entrySet()) {
                if (!entry.getKey().getContributionId().equals(contribution)) continue;
                resultMap.put(entry.getKey(), entry.getValue());
            }
        }
        return resultMap;
    }

    public static Map<I_CompositionAccess, Integer> getVersionMapOfComposition(I_DomainAccess domainAccess, UUID compositionId) {
        HashMap<I_CompositionAccess, Integer> versionMap = new HashMap<I_CompositionAccess, Integer>();
        Integer versionCounter = CompositionAccess.getLastVersionNumber(domainAccess, compositionId);
        CompositionRecord record = (CompositionRecord)domainAccess.getContext().fetchOne((Table)Tables.COMPOSITION, Tables.COMPOSITION.ID.eq((Object)compositionId));
        if (record != null) {
            CompositionAccess compositionAccess = new CompositionAccess(domainAccess);
            compositionAccess.setCompositionRecord(record);
            compositionAccess.setContent(I_EntryAccess.retrieveInstanceInComposition(domainAccess, compositionAccess));
            versionMap.put(compositionAccess, versionCounter);
            Integer n = versionCounter;
            Integer n2 = versionCounter = Integer.valueOf(versionCounter - 1);
        }
        Result historyRecords = domainAccess.getContext().selectFrom((Table)Tables.COMPOSITION_HISTORY).where(Tables.COMPOSITION_HISTORY.ID.eq((Object)compositionId)).orderBy((OrderField)Tables.COMPOSITION_HISTORY.SYS_TRANSACTION.desc()).fetch();
        for (CompositionHistoryRecord historyRecord : historyRecords) {
            CompositionAccess historyAccess = new CompositionAccess(domainAccess);
            historyAccess.setCompositionRecord(historyRecord);
            historyAccess.setContent(I_EntryAccess.retrieveInstanceInComposition(domainAccess, historyAccess));
            versionMap.put(historyAccess, versionCounter);
            Integer n = versionCounter;
            Integer n3 = versionCounter = Integer.valueOf(versionCounter - 1);
        }
        if (versionCounter != 0) {
            throw new InternalServerException("Version Map generation failed");
        }
        return versionMap;
    }

    private UUID seekComposerId(PartyProxy composer) {
        if (composer instanceof PartyIdentified) {
            return I_PartyIdentifiedAccess.getOrCreateParty(this, (PartyIdentified)composer);
        }
        if (composer instanceof PartySelf) {
            return I_PartyIdentifiedAccess.getOrCreatePartySelf(this);
        }
        throw new InternalServerException("composer of unsupported type:" + composer.getClass());
    }

    private Integer seekTerritoryCode(String territoryCode) {
        Integer foundTerritoryCode = I_CompositionAccess.fetchTerritoryCode(this, territoryCode);
        if (foundTerritoryCode < 0) {
            throw new IllegalArgumentException("Invalid two letter territory code");
        }
        return foundTerritoryCode;
    }

    private String seekLanguageCode(String languageCode) {
        if (languageCode == null) {
            return "en";
        }
        if (!I_CompositionAccess.isValidLanguageCode(this, languageCode)) {
            throw new IllegalArgumentException("Invalid language code");
        }
        return languageCode;
    }

    @Override
    public UUID getEhrid() {
        return this.compositionRecord.getEhrId();
    }

    @Override
    public void setEhrid(UUID ehrId) {
        this.compositionRecord.setEhrId(ehrId);
    }

    @Override
    public UUID getComposerId() {
        return this.compositionRecord.getComposer();
    }

    @Override
    public void setComposerId(UUID composerId) {
        this.compositionRecord.setComposer(composerId);
    }

    @Override
    public Optional<UUID> getContextId() {
        if (this.compositionRecord == null) {
            return Optional.empty();
        }
        if (this.compositionRecord.getId() == null) {
            return Optional.empty();
        }
        EventContextRecord eventContext = (EventContextRecord)this.getContext().fetchOne((Table)Tables.EVENT_CONTEXT, Tables.EVENT_CONTEXT.COMPOSITION_ID.eq((Object)this.compositionRecord.getId()));
        if (eventContext == null) {
            return Optional.empty();
        }
        return Optional.of(eventContext.getId());
    }

    @Override
    public UUID getContributionId() {
        return this.compositionRecord.getInContribution();
    }

    @Override
    public String getLanguageCode() {
        return this.compositionRecord.getLanguage();
    }

    @Override
    public void setLanguageCode(String code) {
        this.compositionRecord.setLanguage(code);
    }

    @Override
    public Integer getTerritoryCode() {
        return this.compositionRecord.getTerritory();
    }

    @Override
    public void setTerritoryCode(Integer code) {
        this.compositionRecord.setTerritory(code);
    }

    @Override
    public List<I_EntryAccess> getContent() {
        return this.content;
    }

    @Override
    public void setContent(List<I_EntryAccess> content) {
        this.content = content;
    }

    @Override
    public UUID getId() {
        return this.compositionRecord.getId();
    }

    @Override
    public void setContextCompositionId(UUID contextId) {
        I_ContextAccess contextAccess = I_ContextAccess.retrieveInstance((I_DomainAccess)this, contextId);
        contextAccess.setCompositionId(this.compositionRecord.getId());
        contextAccess.update(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public void setContributionId(UUID contributionId) {
        this.compositionRecord.setInContribution(contributionId);
    }

    @Override
    public void setCompositionRecord(CompositionRecord record) {
        this.compositionRecord = record;
    }

    @Override
    public void setCompositionRecord(CompositionHistoryRecord historyRecord) {
        CompositionRecord compositionRecord;
        this.compositionRecord = compositionRecord = new CompositionRecord(historyRecord.getId(), historyRecord.getEhrId(), historyRecord.getInContribution(), historyRecord.getActive(), historyRecord.getIsPersistent(), historyRecord.getLanguage(), historyRecord.getTerritory(), historyRecord.getComposer(), null, null, historyRecord.getHasAudit(), null);
    }

    @Override
    public void setCompositionRecord(Result<?> records) {
        this.compositionRecord = (CompositionRecord)this.getContext().newRecord(compositionRef);
        try {
            this.compositionRecord.setId((UUID)records.getValue(0, "composition_id"));
            this.compositionRecord.setLanguage((String)records.getValue(0, "language"));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Handling of records failed", e);
        }
    }

    @Override
    public void setComposition(Composition composition) {
        this.composition = composition;
    }

    @Override
    public int addContent(I_EntryAccess entry) {
        entry.setCompositionId(this.compositionRecord.getId());
        this.content.add(entry);
        if (entry.getComposition() != null) {
            this.composition = entry.getComposition();
        }
        return this.content.size();
    }

    @Override
    public List<UUID> getContentIds() {
        ArrayList<UUID> entryList = new ArrayList<UUID>();
        for (I_EntryAccess entryAccess : this.content) {
            entryList.add(entryAccess.getId());
        }
        return entryList;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.auditDetailsAccess.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
        UUID auditId = this.auditDetailsAccess.commit();
        this.compositionRecord.setHasAudit(auditId);
        if (this.getContributionId() != null) {
            Optional.ofNullable(I_ContributionAccess.retrieveInstance(this, this.getContributionId())).orElseThrow(IllegalArgumentException::new);
        } else {
            this.contributionAccess.setAuditDetailsChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
            UUID contributionId = this.contributionAccess.commit();
            this.setContributionId(contributionId);
        }
        this.compositionRecord.setSysTransaction(transactionTime);
        this.compositionRecord.store();
        if (this.content.isEmpty()) {
            log.warn("Composition has no content:");
        }
        try {
            for (I_EntryAccess entryAccess : this.content) {
                entryAccess.commit(transactionTime);
            }
        }
        catch (Exception exception) {
            log.error("Problem in committing content, rolling back, exception:" + exception);
            throw new IllegalArgumentException("Could not commit content:" + exception);
        }
        if (!this.composition.getCategory().getDefiningCode().getCodeString().equals("431")) {
            EventContext eventContext = this.composition.getContext();
            I_ContextAccess contextAccess = I_ContextAccess.getInstance(this, eventContext);
            contextAccess.setCompositionId(this.compositionRecord.getId());
            contextAccess.commit(transactionTime);
        }
        return this.compositionRecord.getId();
    }

    @Override
    @Deprecated
    public UUID commit() {
        throw new UnsupportedOperationException("this commit() signature is not supported");
    }

    @Override
    public UUID commit(UUID committerId, UUID systemId, String description) {
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        this.contributionAccess.setDataType(ContributionDataType.composition);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.contributionAccess.setAuditDetailsValues(committerId, systemId, description);
        this.auditDetailsAccess.setSystemId(systemId);
        this.auditDetailsAccess.setCommitter(committerId);
        this.auditDetailsAccess.setDescription(description);
        return this.commit(timestamp);
    }

    @Override
    public UUID commitWithCustomContribution(UUID committerId, UUID systemId, String description) {
        this.auditDetailsAccess.setSystemId(systemId);
        this.auditDetailsAccess.setCommitter(committerId);
        this.auditDetailsAccess.setDescription(description);
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        return this.commit(timestamp);
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        boolean result = false;
        if (force || this.compositionRecord.changed()) {
            I_ContextAccess contextAccess;
            if (!this.compositionRecord.changed()) {
                this.compositionRecord.changed(true);
                this.compositionRecord.changed((Field)Tables.COMPOSITION.SYS_PERIOD, false);
            }
            this.compositionRecord.setSysTransaction(transactionTime);
            this.updateCompositionData(this.composition);
            result = this.compositionRecord.update() > 0;
            for (I_EntryAccess entryAccess : this.content) {
                entryAccess.setCompositionData(this.composition);
                entryAccess.update(transactionTime, true);
            }
            Optional<UUID> contextId = this.getContextId();
            if (contextId.isEmpty()) {
                EventContext context = new EventContextFactory().makeNull();
                contextAccess = I_ContextAccess.getInstance(this, context);
                contextAccess.commit(transactionTime);
            } else {
                contextAccess = I_ContextAccess.retrieveInstance((I_DomainAccess)this, contextId.get());
            }
            EventContext newEventContext = this.composition.getContext();
            if (contextId.isPresent()) {
                contextAccess.setRecordFields(contextId.get(), newEventContext);
                contextAccess.update(transactionTime, true);
            }
        }
        return result;
    }

    @Override
    public Boolean update() {
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        this.contributionAccess.update(timestamp, null, null, null, null, I_ConceptAccess.ContributionChangeType.MODIFICATION, null);
        this.auditDetailsAccess.update(null, null, I_ConceptAccess.ContributionChangeType.MODIFICATION, null);
        return this.update(timestamp);
    }

    @Override
    public Boolean update(Boolean force) {
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        this.contributionAccess.update(timestamp, null, null, null, null, I_ConceptAccess.ContributionChangeType.MODIFICATION, null);
        this.auditDetailsAccess.update(null, null, I_ConceptAccess.ContributionChangeType.MODIFICATION, null);
        return this.update(timestamp, force);
    }

    @Override
    public Boolean update(UUID committerId, UUID systemId, ContributionDef.ContributionState state, I_ConceptAccess.ContributionChangeType contributionChangeType, String description) {
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        this.contributionAccess.update(timestamp, committerId, systemId, null, state, contributionChangeType, description);
        this.auditDetailsAccess.update(systemId, committerId, contributionChangeType, description);
        return this.update(timestamp, true);
    }

    @Override
    public Boolean updateWithCustomContribution(UUID committerId, UUID systemId, I_ConceptAccess.ContributionChangeType contributionChangeType, String description) {
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        this.auditDetailsAccess.update(systemId, committerId, contributionChangeType, description);
        return this.update(timestamp);
    }

    @Override
    public Integer delete() {
        return this.delete(null, null, null);
    }

    @Override
    public Integer delete(UUID committerId, UUID systemId, String description) {
        int delRows = this.compositionRecord.delete();
        I_AuditDetailsAccess delAudit = I_AuditDetailsAccess.getInstance(this, systemId, committerId, I_ConceptAccess.ContributionChangeType.DELETED, description);
        UUID delAuditId = delAudit.commit();
        this.contributionAccess = I_ContributionAccess.getInstance(this.getDataAccess(), this.contributionAccess.getEhrId());
        UUID contrib = this.contributionAccess.commit(Timestamp.valueOf(LocalDateTime.now()), committerId, systemId, null, ContributionDef.ContributionState.COMPLETE, I_ConceptAccess.ContributionChangeType.DELETED, description);
        this.createAndCommitNewDeletedVersionAsHistory(delAuditId, contrib);
        return delRows;
    }

    @Override
    public Integer deleteWithCustomContribution(UUID committerId, UUID systemId, String description) {
        int delRows = this.compositionRecord.delete();
        I_AuditDetailsAccess delAudit = I_AuditDetailsAccess.getInstance(this, systemId, committerId, I_ConceptAccess.ContributionChangeType.DELETED, description);
        UUID delAuditId = delAudit.commit();
        this.createAndCommitNewDeletedVersionAsHistory(delAuditId, this.compositionRecord.getInContribution());
        return delRows;
    }

    private void createAndCommitNewDeletedVersionAsHistory(UUID delAuditId, UUID contrib) {
        CompositionHistoryAccess newDeletedVersionAsHistoryAccess = new CompositionHistoryAccess(this.getDataAccess());
        CompositionHistoryRecord newRecord = (CompositionHistoryRecord)this.getDataAccess().getContext().newRecord((Table)Tables.COMPOSITION_HISTORY);
        newRecord.setId(this.compositionRecord.getId());
        newRecord.setEhrId(this.compositionRecord.getEhrId());
        newRecord.setInContribution(contrib);
        newRecord.setActive(this.compositionRecord.getActive());
        newRecord.setIsPersistent(this.compositionRecord.getIsPersistent());
        newRecord.setLanguage(this.compositionRecord.getLanguage());
        newRecord.setTerritory(this.compositionRecord.getTerritory());
        newRecord.setComposer(this.compositionRecord.getComposer());
        newRecord.setHasAudit(delAuditId);
        newDeletedVersionAsHistoryAccess.setRecord(newRecord);
        if (newDeletedVersionAsHistoryAccess.commit() == null) {
            throw new InternalServerException("DB inconsistency");
        }
    }

    @Override
    public Timestamp getSysTransaction() {
        return this.compositionRecord.getSysTransaction();
    }

    @Override
    public Timestamp getTimeCommitted() {
        return this.auditDetailsAccess.getTimeCommitted();
    }

    @Override
    public void setContributionAccess(I_ContributionAccess contributionAccess) {
        this.contributionAccess = contributionAccess;
    }

    @Override
    public void setAuditDetailsAccess(I_AuditDetailsAccess auditDetailsAccess) {
        this.auditDetailsAccess = auditDetailsAccess;
    }

    @Override
    public Integer getVersion() {
        Integer version = 1;
        return version;
    }

    @Override
    public void updateCompositionData(Composition newComposition) {
        this.setLanguageCode(this.seekLanguageCode(newComposition.getLanguage().getCodeString()));
        this.setTerritoryCode(this.seekTerritoryCode(newComposition.getTerritory().getCodeString()));
        this.setComposerId(this.seekComposerId(newComposition.getComposer()));
    }

    @Override
    public void setContext(EventContext eventContext) {
        this.composition.setContext(eventContext);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public UUID getAuditDetailsId() {
        return this.compositionRecord.getHasAudit();
    }

    @Override
    public void setAuditDetailsId(UUID auditId) {
        this.compositionRecord.setHasAudit(auditId);
    }

    public static boolean exists(I_DomainAccess domainAccess, UUID versionedObjectId) {
        if (domainAccess.getContext().fetchExists((Table)Tables.COMPOSITION, Tables.COMPOSITION.ID.eq((Object)versionedObjectId)) || domainAccess.getContext().fetchExists((Table)Tables.COMPOSITION_HISTORY, Tables.COMPOSITION_HISTORY.ID.eq((Object)versionedObjectId))) {
            return true;
        }
        throw new ObjectNotFoundException("composition", "No composition with given ID found");
    }

    public static boolean isDeleted(I_DomainAccess domainAccess, UUID versionedObjectId) {
        if (domainAccess.getContext().fetchExists((Table)Tables.COMPOSITION, Tables.COMPOSITION.ID.eq((Object)versionedObjectId))) {
            return false;
        }
        if (domainAccess.getContext().fetchExists((Table)Tables.COMPOSITION_HISTORY, Tables.COMPOSITION_HISTORY.ID.eq((Object)versionedObjectId))) {
            Result historyRecordsRes = domainAccess.getContext().selectFrom((Table)Tables.COMPOSITION_HISTORY).where(Tables.COMPOSITION_HISTORY.ID.eq((Object)versionedObjectId)).orderBy((OrderField)Tables.COMPOSITION_HISTORY.SYS_TRANSACTION.desc()).fetch();
            AuditDetailsRecord audit = (AuditDetailsRecord)domainAccess.getContext().fetchOne((Table)Tables.AUDIT_DETAILS, Tables.AUDIT_DETAILS.ID.eq((Object)((CompositionHistoryRecord)historyRecordsRes.get(0)).getHasAudit()));
            if (audit == null) {
                throw new InternalServerException("DB inconsistency: couldn't retrieve referenced audit");
            }
            if (audit.getChangeType().equals((Object)ContributionChangeType.deleted)) {
                return true;
            }
        } else {
            throw new ObjectNotFoundException("composition", "No composition with given ID found");
        }
        throw new InternalServerException("Problem processing CompositionAccess.isDeleted(..)");
    }
}

