/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_ContainmentAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.ehr.encode.ItemStack;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class ContainmentAccess
extends DataAccess
implements I_ContainmentAccess {
    private static final Logger log = LogManager.getLogger(ContainmentAccess.class);
    private UUID entryId;
    private UUID compositionId;
    private Map<String, String> ltree = new HashMap<String, String>();

    public ContainmentAccess(DataAccess dataAccess, UUID entryId, String archetypeId, Map<String, String> ltreeMap, boolean debug) {
        super(dataAccess.getContext(), null, null, dataAccess.getServerConfig());
        this.entryId = entryId;
        String rootArchetype = ItemStack.normalizeLabel((String)archetypeId);
        this.ltree.put(rootArchetype, "/composition[" + archetypeId + "]");
        for (Map.Entry<String, String> entry : ltreeMap.entrySet()) {
            String label = rootArchetype + "." + entry.getKey().toString();
            String path = entry.getValue().toString();
            this.ltree.put(label, path);
            if (!debug) continue;
            log.debug("LABEL:" + label + "|PATH:" + path);
        }
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        return this.commit();
    }

    @Override
    public UUID commit() {
        this.commitContainments();
        return null;
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update();
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        return this.update();
    }

    @Override
    public Boolean update() {
        this.commitContainments();
        return true;
    }

    @Override
    public Boolean update(Boolean force) {
        return this.update();
    }

    private void commitContainments() {
        if (this.ltree == null) {
            throw new IllegalArgumentException("Containment label tree is not initialized, aborting");
        }
        if (this.getContext().fetchExists((Table)Tables.CONTAINMENT, Tables.CONTAINMENT.COMP_ID.eq((Object)this.compositionId))) {
            this.getContext().delete((Table)Tables.CONTAINMENT).where(Tables.CONTAINMENT.COMP_ID.eq((Object)this.compositionId)).execute();
        }
        for (Map.Entry<String, String> entry : this.ltree.entrySet()) {
            this.getContext().insertInto((Table)Tables.CONTAINMENT, (Field)Tables.CONTAINMENT.COMP_ID, (Field)Tables.CONTAINMENT.LABEL, (Field)Tables.CONTAINMENT.PATH).values((Field)DSL.val((UUID)this.compositionId), DSL.field((String)(DSL.val((String)entry.getKey().toString()) + "::ltree")), (Field)DSL.val((String)entry.getValue().toString())).execute();
        }
    }

    @Override
    @Deprecated
    public Integer delete() {
        throw new InternalServerException("INTERNAL: Invalid delete call, this signature is not supported in ContainmentAccess");
    }

    @Override
    public void setCompositionId(UUID compositionId) {
        this.compositionId = compositionId;
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

