/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_ContextAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.jooq.ConceptAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.ConceptRecord;
import org.ehrbase.jooq.pg.tables.records.EventContextHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EventContextRecord;
import org.ehrbase.jooq.pg.tables.records.ParticipationRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.serialisation.RawJson;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.JSONB;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.UpdateQuery;
import org.jooq.exception.DataAccessException;

public class ContextAccess
extends DataAccess
implements I_ContextAccess {
    private static final TerminologyId OPENEHR_TERMINOLOGY_ID = new TerminologyId("openehr");
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final String DB_INCONSISTENCY = "DB inconsistency";
    private static Logger log = LogManager.getLogger(ContextAccess.class);
    private EventContextRecord eventContextRecord;
    private PreparedStatement updateStatement;
    private List<ParticipationRecord> participations = new ArrayList<ParticipationRecord>();

    public ContextAccess(DSLContext context, ServerConfig serverConfig, EventContext eventContext) {
        super(context, null, null, serverConfig);
        this.eventContextRecord = (EventContextRecord)context.newRecord((Table)Tables.EVENT_CONTEXT);
        this.setRecordFields(UUID.randomUUID(), eventContext);
    }

    private ContextAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public static I_ContextAccess retrieveInstance(I_DomainAccess domainAccess, UUID id) {
        ContextAccess contextAccess = new ContextAccess(domainAccess);
        contextAccess.eventContextRecord = (EventContextRecord)domainAccess.getContext().fetchOne((Table)Tables.EVENT_CONTEXT, Tables.EVENT_CONTEXT.ID.eq((Object)id));
        return contextAccess;
    }

    public static I_ContextAccess retrieveInstance(I_DomainAccess domainAccess, Result<?> records) {
        ContextAccess contextAccess = new ContextAccess(domainAccess);
        EventContextRecord eventContextRecord = (EventContextRecord)domainAccess.getContext().newRecord((Table)Tables.EVENT_CONTEXT);
        eventContextRecord.setStartTime((Timestamp)records.getValue(0, "context_start_time"));
        eventContextRecord.setStartTimeTzid((String)records.getValue(0, "context_start_time_tzid"));
        eventContextRecord.setEndTime((Timestamp)records.getValue(0, "context_end_time"));
        eventContextRecord.setEndTimeTzid((String)records.getValue(0, "context_end_time_tzid"));
        eventContextRecord.setLocation((String)records.getValue(0, "context_location"));
        eventContextRecord.setOtherContext((JSONB)records.getValue(0, "context_other_context"));
        return contextAccess;
    }

    private static DvCodedText decodeDvCodedText(String codedDvCodedText) {
        String[] tokens = codedDvCodedText.substring(codedDvCodedText.indexOf("{") + 1, codedDvCodedText.indexOf("}")).split(",");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("failed to parse DvCodedText '" + codedDvCodedText + "', wrong number of tokens.");
        }
        String textValue = tokens[2].split("=")[1];
        String codeTerminology = tokens[1].split("=")[1];
        String codeString = tokens[0].split("=")[1];
        return new DvCodedText(textValue, new CodePhrase(new TerminologyId(codeTerminology), codeString));
    }

    private static DvDateTime decodeDvDateTime(Timestamp timestamp, String timezone) {
        if (timestamp == null) {
            return null;
        }
        Optional<Object> codedLocalDateTime = Optional.empty();
        Optional<Object> zonedDateTime = Optional.empty();
        if (timezone != null) {
            zonedDateTime = Optional.of(timestamp.toLocalDateTime().atZone(ZoneId.of(timezone)));
        } else {
            codedLocalDateTime = Optional.of(timestamp.toLocalDateTime());
        }
        Optional<String> convertedDateTime = codedLocalDateTime.map(i -> i.format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        if (convertedDateTime.isEmpty()) {
            convertedDateTime = zonedDateTime.map(i -> i.format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        }
        return new DvDateTime(convertedDateTime.orElseThrow(() -> new InternalServerException("Decoding DvDateTime failed")));
    }

    public static EventContext retrieveHistoricalEventContext(I_DomainAccess domainAccess, UUID compositionId, Timestamp transactionTime) {
        PartyIdentifiedRecord partyIdentifiedRecord;
        EventContextHistoryRecord eventContextHistoryRecord = (EventContextHistoryRecord)domainAccess.getContext().fetchAny((Table)Tables.EVENT_CONTEXT_HISTORY, Tables.EVENT_CONTEXT_HISTORY.COMPOSITION_ID.eq((Object)compositionId).and(Tables.EVENT_CONTEXT_HISTORY.SYS_TRANSACTION.eq((Object)transactionTime)));
        if (eventContextHistoryRecord == null) {
            return null;
        }
        PartyIdentified healthCareFacility = null;
        if (eventContextHistoryRecord.getFacility() != null && (partyIdentifiedRecord = (PartyIdentifiedRecord)domainAccess.getContext().fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)eventContextHistoryRecord.getFacility()))) != null) {
            ArrayList<DvIdentifier> identifiers = new ArrayList<DvIdentifier>();
            domainAccess.getContext().fetch((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.PARTY.eq((Object)partyIdentifiedRecord.getId())).forEach(record -> {
                DvIdentifier dvIdentifier = new DvIdentifier();
                dvIdentifier.setIssuer(record.getIssuer());
                dvIdentifier.setAssigner(record.getAssigner());
                dvIdentifier.setId(record.getIdValue());
                dvIdentifier.setType(record.getTypeName());
                identifiers.add(dvIdentifier);
            });
            healthCareFacility = ContextAccess.getPartyIdentifiedFromRecord(partyIdentifiedRecord, identifiers);
        }
        ArrayList participationList = new ArrayList();
        domainAccess.getContext().fetch((Table)Tables.PARTICIPATION_HISTORY, Tables.PARTICIPATION_HISTORY.EVENT_CONTEXT.eq((Object)eventContextHistoryRecord.getId()).and(Tables.PARTICIPATION_HISTORY.SYS_TRANSACTION.eq((Object)transactionTime))).forEach(record -> {
            DvCodedText mode;
            PartyProxy performer = I_PartyIdentifiedAccess.retrievePartyIdentified(domainAccess, record.getPerformer());
            DvInterval startTime = new DvInterval((DvOrdered)ContextAccess.decodeDvDateTime(record.getStartTime(), record.getStartTimeTzid()), null);
            try {
                mode = ContextAccess.decodeDvCodedText(record.getMode());
            }
            catch (IllegalArgumentException e) {
                throw new InternalServerException(DB_INCONSISTENCY, (Exception)e);
            }
            Participation participation = new Participation(performer, new DvText(record.getFunction()), mode, startTime);
            participationList.add(participation);
        });
        UUID settingUuid = eventContextHistoryRecord.getSetting();
        ConceptRecord conceptRecord = (ConceptRecord)domainAccess.getContext().fetchOne((Table)Tables.CONCEPT, Tables.CONCEPT.ID.eq((Object)settingUuid).and(Tables.CONCEPT.LANGUAGE.eq((Object)"en")));
        DvCodedText concept = conceptRecord != null ? new DvCodedText(conceptRecord.getDescription(), new CodePhrase(OPENEHR_TERMINOLOGY_ID, conceptRecord.getConceptid().toString())) : new DvCodedText("event", new CodePhrase(OPENEHR_TERMINOLOGY_ID, "433"));
        return new EventContext(healthCareFacility, ContextAccess.decodeDvDateTime(eventContextHistoryRecord.getStartTime(), eventContextHistoryRecord.getStartTimeTzid()), ContextAccess.decodeDvDateTime(eventContextHistoryRecord.getEndTime(), eventContextHistoryRecord.getEndTimeTzid()), participationList.isEmpty() ? null : participationList, eventContextHistoryRecord.getLocation(), concept, null);
    }

    private static PartyIdentified getPartyIdentifiedFromRecord(PartyIdentifiedRecord partyIdentifiedRecord, List<DvIdentifier> identifiers) {
        PartyRef partyRef;
        if (partyIdentifiedRecord.getPartyRefValue() != null && partyIdentifiedRecord.getPartyRefScheme() != null) {
            GenericId genericID = new GenericId(partyIdentifiedRecord.getPartyRefValue(), partyIdentifiedRecord.getPartyRefScheme());
            partyRef = new PartyRef((ObjectId)genericID, partyIdentifiedRecord.getPartyRefNamespace(), partyIdentifiedRecord.getPartyRefType());
        } else {
            HierObjectId objectID = new HierObjectId("ref");
            partyRef = new PartyRef((ObjectId)objectID, partyIdentifiedRecord.getPartyRefNamespace(), partyIdentifiedRecord.getPartyRefType());
        }
        PartyIdentified healthCareFacility = new PartyIdentified(partyRef, partyIdentifiedRecord.getName(), identifiers.isEmpty() ? null : identifiers);
        return healthCareFacility;
    }

    @Override
    public void setRecordFields(UUID id, EventContext eventContext) {
        this.eventContextRecord.setStartTimeTzid(ZoneId.systemDefault().getId());
        this.eventContextRecord.setStartTime(this.toTimestamp(eventContext.getStartTime()));
        if (eventContext.getEndTime() != null) {
            this.eventContextRecord.setEndTime(this.toTimestamp(eventContext.getEndTime()));
            this.eventContextRecord.setEndTimeTzid(ZoneId.systemDefault().getId());
        }
        this.eventContextRecord.setId(id != null ? id : UUID.randomUUID());
        if (eventContext.getHealthCareFacility() != null) {
            UUID healthcareFacilityId = I_PartyIdentifiedAccess.getOrCreateParty(this, eventContext.getHealthCareFacility());
            this.eventContextRecord.setFacility(healthcareFacilityId);
        }
        if (eventContext.getLocation() != null) {
            this.eventContextRecord.setLocation(eventContext.getLocation());
        }
        try {
            Integer settingCode = Integer.parseInt(eventContext.getSetting().getDefiningCode().getCodeString());
            this.eventContextRecord.setSetting(ConceptAccess.fetchConceptUUID(this, settingCode, "en"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (eventContext.getParticipations() != null) {
            for (Participation participation : eventContext.getParticipations()) {
                PartyProxy setPerformer;
                DvDateTime lower;
                ParticipationRecord participationRecord = (ParticipationRecord)this.getContext().newRecord((Table)Tables.PARTICIPATION);
                participationRecord.setEventContext(this.eventContextRecord.getId());
                participationRecord.setFunction(participation.getFunction().getValue());
                if (participation.getMode() != null) {
                    participationRecord.setMode(participation.getMode().toString());
                }
                if (participation.getTime() != null && (lower = (DvDateTime)participation.getTime().getLower()) != null) {
                    participationRecord.setStartTime(new Timestamp(lower.getValue().get(ChronoField.MILLI_OF_SECOND)));
                    participationRecord.setStartTimeTzid(ZoneId.systemDefault().getId());
                }
                if (!((setPerformer = participation.getPerformer()) instanceof PartyIdentified)) {
                    log.warn("Set performer is using unsupported type:" + setPerformer.toString());
                    break;
                }
                PartyIdentified performer = (PartyIdentified)setPerformer;
                UUID performerUuid = I_PartyIdentifiedAccess.getOrCreateParty(this, performer);
                participationRecord.setPerformer(performerUuid);
                this.participations.add(participationRecord);
            }
        }
        if (eventContext.getOtherContext() != null && CollectionUtils.isNotEmpty((Collection)eventContext.getOtherContext().getItems())) {
            this.eventContextRecord.setOtherContext(JSONB.valueOf((String)new RawJson().marshal((RMObject)eventContext.getOtherContext())));
        }
    }

    private Timestamp toTimestamp(DvDateTime dateTime) {
        TemporalAccessor accessor = dateTime.getValue();
        long millis = accessor.getLong(ChronoField.INSTANT_SECONDS) * 1000L + accessor.getLong(ChronoField.MILLI_OF_SECOND);
        return new Timestamp(millis);
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        int result;
        this.eventContextRecord.setSysTransaction(transactionTime);
        InsertQuery insertQuery = this.getContext().insertQuery((Table)Tables.EVENT_CONTEXT);
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.ID, (Object)this.eventContextRecord.getId());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.COMPOSITION_ID, (Object)this.eventContextRecord.getCompositionId());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.START_TIME, (Object)this.eventContextRecord.getStartTime());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.START_TIME_TZID, (Object)this.eventContextRecord.getStartTimeTzid());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.END_TIME, (Object)this.eventContextRecord.getEndTime());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.END_TIME_TZID, (Object)this.eventContextRecord.getEndTimeTzid());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.FACILITY, (Object)this.eventContextRecord.getFacility());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.LOCATION, (Object)this.eventContextRecord.getLocation());
        if (this.eventContextRecord.getOtherContext() != null) {
            insertQuery.addValue((Field)Tables.EVENT_CONTEXT.OTHER_CONTEXT, (Object)this.eventContextRecord.getOtherContext());
        }
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.SETTING, (Object)this.eventContextRecord.getSetting());
        insertQuery.addValue((Field)Tables.EVENT_CONTEXT.SYS_TRANSACTION, (Object)this.eventContextRecord.getSysTransaction());
        try {
            result = insertQuery.execute();
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Problem executing database operation", (Exception)((Object)e));
        }
        if (result < 1) {
            throw new IllegalArgumentException("Context commit failed");
        }
        if (!this.participations.isEmpty()) {
            this.participations.forEach(participation -> {
                participation.setEventContext(this.eventContextRecord.getId());
                participation.setSysTransaction(transactionTime);
                participation.store();
            });
        }
        return this.eventContextRecord.getId();
    }

    @Override
    public UUID commit() {
        return this.commit(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        Boolean result;
        for (ParticipationRecord participationRecord : this.participations) {
            participationRecord.setSysTransaction(transactionTime);
            if (!participationRecord.changed()) continue;
            try {
                if (this.getContext().fetchExists((Table)Tables.PARTICIPATION, Tables.PARTICIPATION.ID.eq((Object)participationRecord.getId()))) {
                    participationRecord.update();
                    continue;
                }
                participationRecord.setId(UUID.randomUUID());
                participationRecord.store();
            }
            catch (DataAccessException e) {
                throw new InternalServerException(DB_INCONSISTENCY, (Exception)((Object)e));
            }
        }
        this.eventContextRecord.changed((Field)Tables.EVENT_CONTEXT.SYS_PERIOD, false);
        this.eventContextRecord.setSysTransaction(transactionTime);
        UpdateQuery updateQuery = this.getContext().updateQuery((Table)Tables.EVENT_CONTEXT);
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.COMPOSITION_ID, (Object)this.eventContextRecord.getCompositionId());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.START_TIME, (Object)this.eventContextRecord.getStartTime());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.START_TIME_TZID, (Object)this.eventContextRecord.getStartTimeTzid());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.END_TIME, (Object)this.eventContextRecord.getEndTime());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.END_TIME_TZID, (Object)this.eventContextRecord.getEndTimeTzid());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.FACILITY, (Object)this.eventContextRecord.getFacility());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.LOCATION, (Object)this.eventContextRecord.getLocation());
        if (this.eventContextRecord.getOtherContext() != null) {
            updateQuery.addValue((Field)Tables.EVENT_CONTEXT.OTHER_CONTEXT, (Object)this.eventContextRecord.getOtherContext());
        }
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.SETTING, (Object)this.eventContextRecord.getSetting());
        updateQuery.addValue((Field)Tables.EVENT_CONTEXT.SYS_TRANSACTION, (Object)this.eventContextRecord.getSysTransaction());
        updateQuery.addConditions(Tables.EVENT_CONTEXT.ID.eq((Object)this.getId()));
        try {
            result = updateQuery.execute() > 0;
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Problem when updating DB entry", (Exception)((Object)e));
        }
        return result;
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        if (force) {
            this.eventContextRecord.changed(true);
            this.eventContextRecord.changed((Field)Tables.EVENT_CONTEXT.SYS_PERIOD, false);
            for (ParticipationRecord participationRecord : this.participations) {
                participationRecord.changed(true);
                participationRecord.changed((Field)Tables.PARTICIPATION.SYS_PERIOD, false);
            }
        }
        return this.update(transactionTime);
    }

    @Override
    @Deprecated
    public Boolean update() {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    @Deprecated
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    public Integer delete() {
        int count = 0;
        count += this.getContext().delete((Table)Tables.PARTICIPATION).where(Tables.PARTICIPATION.EVENT_CONTEXT.eq((Object)this.eventContextRecord.getId())).execute();
        return count += this.eventContextRecord.delete();
    }

    @Override
    public EventContext mapRmEventContext() {
        PartyIdentifiedRecord partyIdentifiedRecord = (PartyIdentifiedRecord)this.getContext().fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)this.eventContextRecord.getFacility()));
        PartyIdentified healthCareFacility = null;
        if (partyIdentifiedRecord != null) {
            ArrayList<DvIdentifier> identifiers = new ArrayList<DvIdentifier>();
            this.getContext().fetch((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.PARTY.eq((Object)partyIdentifiedRecord.getId())).forEach(record -> {
                DvIdentifier dvIdentifier = new DvIdentifier();
                dvIdentifier.setIssuer(record.getIssuer());
                dvIdentifier.setAssigner(record.getAssigner());
                dvIdentifier.setId(record.getIdValue());
                dvIdentifier.setType(record.getTypeName());
                identifiers.add(dvIdentifier);
            });
            healthCareFacility = ContextAccess.getPartyIdentifiedFromRecord(partyIdentifiedRecord, identifiers);
        }
        ArrayList participationList = new ArrayList();
        this.getContext().fetch((Table)Tables.PARTICIPATION, Tables.PARTICIPATION.EVENT_CONTEXT.eq((Object)this.eventContextRecord.getId())).forEach(record -> {
            DvCodedText mode;
            PartyProxy performer = I_PartyIdentifiedAccess.retrievePartyIdentified(this, record.getPerformer());
            DvInterval startTime = null;
            if (record.getStartTime() != null) {
                startTime = new DvInterval((DvOrdered)ContextAccess.decodeDvDateTime(record.getStartTime(), record.getStartTimeTzid()), null);
            }
            try {
                mode = StringUtils.isNotBlank((CharSequence)record.getMode()) ? ContextAccess.decodeDvCodedText(record.getMode()) : null;
            }
            catch (IllegalArgumentException e) {
                throw new InternalServerException(DB_INCONSISTENCY, (Exception)e);
            }
            Participation participation = new Participation(performer, new DvText(record.getFunction()), mode, startTime);
            participationList.add(participation);
        });
        UUID settingUuid = this.eventContextRecord.getSetting();
        ConceptRecord conceptRecord = (ConceptRecord)this.getContext().fetchOne((Table)Tables.CONCEPT, Tables.CONCEPT.ID.eq((Object)settingUuid).and(Tables.CONCEPT.LANGUAGE.eq((Object)"en")));
        DvCodedText concept = conceptRecord != null ? new DvCodedText(conceptRecord.getDescription(), new CodePhrase(OPENEHR_TERMINOLOGY_ID, conceptRecord.getConceptid().toString())) : new DvCodedText("event", new CodePhrase(OPENEHR_TERMINOLOGY_ID, "433"));
        ItemStructure otherContext = null;
        if (this.eventContextRecord.getOtherContext() != null) {
            otherContext = (ItemStructure)new RawJson().unmarshal(this.eventContextRecord.getOtherContext().data(), ItemStructure.class);
        }
        return new EventContext(healthCareFacility, ContextAccess.decodeDvDateTime(this.eventContextRecord.getStartTime(), this.eventContextRecord.getStartTimeTzid()), ContextAccess.decodeDvDateTime(this.eventContextRecord.getEndTime(), this.eventContextRecord.getEndTimeTzid()), participationList.isEmpty() ? null : participationList, this.eventContextRecord.getLocation(), concept, otherContext);
    }

    @Override
    public String getOtherContextJson() {
        if (this.eventContextRecord.getOtherContext() == null) {
            return null;
        }
        return this.eventContextRecord.getOtherContext().data();
    }

    @Override
    public void setCompositionId(UUID compositionId) {
        this.eventContextRecord.setCompositionId(compositionId);
    }

    @Override
    public UUID getId() {
        return this.eventContextRecord.getId();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

