/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyIdentified;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.jooq.CompositionAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.enums.ContributionState;
import org.ehrbase.jooq.pg.tables.records.ContributionHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.ContributionRecord;
import org.ehrbase.service.IntrospectService;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Table;

public class ContributionAccess
extends DataAccess
implements I_ContributionAccess {
    private final String signature = "$system$";
    Logger log = LogManager.getLogger(CompositionAccess.class);
    private ContributionRecord contributionRecord;
    private Map<UUID, I_CompositionAccess> compositions = new HashMap<UUID, I_CompositionAccess>();
    private I_AuditDetailsAccess auditDetails;

    public ContributionAccess(DSLContext context, I_KnowledgeCache knowledgeManager, IntrospectService introspectCache, ServerConfig serverConfig, UUID ehrId) {
        super(context, knowledgeManager, introspectCache, serverConfig);
        this.contributionRecord = (ContributionRecord)context.newRecord((Table)Tables.CONTRIBUTION);
        this.contributionRecord.setEhrId(ehrId);
        this.auditDetails = I_AuditDetailsAccess.getInstance(this.getDataAccess());
    }

    public ContributionAccess(I_DomainAccess domainAccess, UUID ehrId) {
        super(domainAccess.getContext(), domainAccess.getKnowledgeManager(), domainAccess.getIntrospectService(), domainAccess.getServerConfig());
        this.contributionRecord = (ContributionRecord)domainAccess.getContext().newRecord((Table)Tables.CONTRIBUTION);
        this.contributionRecord.setEhrId(ehrId);
        this.auditDetails = I_AuditDetailsAccess.getInstance(this.getDataAccess());
    }

    private ContributionAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public static I_ContributionAccess retrieveInstance(I_DomainAccess domainAccess, UUID contributionId) {
        ContributionAccess contributionAccess = new ContributionAccess(domainAccess);
        try {
            contributionAccess.contributionRecord = (ContributionRecord)domainAccess.getContext().fetchOne((Table)Tables.CONTRIBUTION, Tables.CONTRIBUTION.ID.eq((Object)contributionId));
        }
        catch (Exception e) {
            throw new InternalServerException("fetching contribution failed", e);
        }
        if (contributionAccess.contributionRecord == null) {
            return null;
        }
        HashMap<UUID, I_CompositionAccess> compos = new HashMap<UUID, I_CompositionAccess>();
        CompositionAccess.retrieveCompositionsInContribution(domainAccess, contributionAccess.contributionRecord.getId()).forEach((access, version) -> compos.put(access.getId(), (I_CompositionAccess)access));
        contributionAccess.compositions = compos;
        contributionAccess.auditDetails = new AuditDetailsAccess(domainAccess.getDataAccess()).retrieveInstance(domainAccess.getDataAccess(), contributionAccess.getHasAuditDetails());
        return contributionAccess;
    }

    public static I_ContributionAccess retrieveVersionedInstance(I_DomainAccess domainAccess, UUID contributionVersionedObjId, Timestamp transactionTime) {
        ContributionAccess contributionAccess = new ContributionAccess(domainAccess);
        ContributionHistoryRecord contributionHistoryRecord = (ContributionHistoryRecord)domainAccess.getContext().fetchOne((Table)Tables.CONTRIBUTION_HISTORY, Tables.CONTRIBUTION_HISTORY.ID.eq((Object)contributionVersionedObjId).and(Tables.CONTRIBUTION_HISTORY.SYS_TRANSACTION.eq((Object)transactionTime)));
        if (contributionHistoryRecord != null) {
            contributionAccess.contributionRecord = (ContributionRecord)domainAccess.getContext().newRecord((Table)Tables.CONTRIBUTION);
            contributionAccess.contributionRecord.from((Object)contributionHistoryRecord);
            return contributionAccess;
        }
        return null;
    }

    @Override
    public void addComposition(I_CompositionAccess compositionAccess) {
        compositionAccess.setEhrid(this.contributionRecord.getEhrId());
        if (compositionAccess.getComposerId() == null) {
            compositionAccess.setComposerId(this.auditDetails.getCommitter());
        }
        if (compositionAccess.getAuditDetailsId() == null) {
            throw new IllegalArgumentException("Composition has no embedded audit");
        }
        compositionAccess.setContributionId(this.contributionRecord.getId());
        this.compositions.put(compositionAccess.getId(), compositionAccess);
    }

    @Override
    public boolean removeComposition(I_CompositionAccess compositionAccess) {
        I_CompositionAccess removed = this.compositions.remove(compositionAccess.getId());
        return removed != null;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        UUID auditId = this.auditDetails.commit();
        this.contributionRecord.setHasAudit(auditId);
        if (this.contributionRecord.getState() == ContributionState.incomplete) {
            this.log.warn("Contribution state has not been set");
        }
        this.contributionRecord.setSysTransaction(transactionTime);
        this.contributionRecord.setEhrId(this.getEhrId());
        if (this.contributionRecord.insert() == 0) {
            throw new InternalServerException("Couldn't store contribution");
        }
        UUID contributionId = this.contributionRecord.getId();
        for (I_CompositionAccess compositionAccess : this.compositions.values()) {
            compositionAccess.commit(transactionTime);
        }
        return contributionId;
    }

    @Override
    public UUID commit() {
        return this.commit(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public UUID commit(Timestamp transactionTime, ContributionDataType contributionType, ContributionDef.ContributionState state) {
        if (transactionTime == null) {
            transactionTime = Timestamp.valueOf(LocalDateTime.now());
        }
        if (contributionType == null) {
            this.setContributionDataType(ContributionDataType.other);
        } else {
            this.setContributionDataType(contributionType);
        }
        if (state != null) {
            this.setState(state);
        } else {
            this.setState(ContributionDef.ContributionState.COMPLETE);
        }
        return this.commit(transactionTime);
    }

    @Override
    public UUID commit(Timestamp transactionTime, UUID committerId, UUID systemId, ContributionDataType contributionType, ContributionDef.ContributionState state, I_ConceptAccess.ContributionChangeType contributionChangeType, String description) {
        this.auditDetails = I_AuditDetailsAccess.getInstance(this.getDataAccess());
        if (transactionTime == null) {
            transactionTime = Timestamp.valueOf(LocalDateTime.now());
        }
        if (contributionType == null) {
            this.setContributionDataType(ContributionDataType.other);
        } else {
            this.setContributionDataType(contributionType);
        }
        if (state != null) {
            this.setState(state);
        } else {
            this.setState(ContributionDef.ContributionState.COMPLETE);
        }
        if (committerId == null) {
            String defaultUser = System.getProperty("user.name");
            try {
                InetAddress localMachine = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new InternalServerException("Problem while getting information about server", (Exception)e);
            }
            String scheme = System.getProperty("host.name");
            if (scheme == null) {
                scheme = "local";
            }
            committerId = I_PartyIdentifiedAccess.getOrCreatePartyByExternalRef(this, defaultUser, UUID.randomUUID().toString(), scheme, this.getServerConfig().getNodename(), "PARTY");
        }
        this.auditDetails.setCommitter(committerId);
        if (systemId != null) {
            this.auditDetails.setSystemId(systemId);
        } else {
            this.auditDetails.setSystemId(I_SystemAccess.createOrRetrieveLocalSystem(this));
        }
        if (contributionChangeType != null) {
            this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, contributionChangeType.name()));
        } else {
            this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
        }
        if (description != null) {
            this.auditDetails.setDescription(description);
        }
        return this.commit(transactionTime);
    }

    @Override
    public Boolean update(Timestamp transactionTime, UUID committerId, UUID systemId, String contributionType, String contributionState, String contributionChangeType, String description) {
        ContributionDataType type = null;
        ContributionDef.ContributionState state = null;
        I_ConceptAccess.ContributionChangeType changeType = null;
        if (contributionType == null) {
            type = ContributionDataType.valueOf((String)contributionType);
        }
        if (contributionState != null) {
            state = ContributionDef.ContributionState.valueOf(contributionState);
        }
        if (contributionChangeType != null) {
            changeType = I_ConceptAccess.ContributionChangeType.valueOf(contributionChangeType);
        }
        return this.update(transactionTime, committerId, systemId, type, state, changeType, description);
    }

    @Override
    public Boolean update(Timestamp transactionTime, UUID committerId, UUID systemId, ContributionDataType contributionType, ContributionDef.ContributionState state, I_ConceptAccess.ContributionChangeType contributionChangeType, String description) {
        if (contributionType != null) {
            this.setContributionDataType(contributionType);
        }
        if (state != null) {
            this.setState(state);
        }
        this.auditDetails = I_AuditDetailsAccess.getInstance(this.getDataAccess());
        if (committerId != null) {
            this.auditDetails.setCommitter(committerId);
        }
        if (systemId != null) {
            this.auditDetails.setSystemId(systemId);
        }
        if (description != null) {
            this.auditDetails.setDescription(description);
        }
        if (contributionChangeType != null) {
            this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, contributionChangeType));
        }
        return this.update(transactionTime);
    }

    @Override
    public UUID commitWithSignature(String signature) {
        this.contributionRecord.setSignature(signature);
        this.contributionRecord.setState(ContributionState.valueOf((String)"complete"));
        this.contributionRecord.store();
        return this.contributionRecord.getId();
    }

    @Override
    public UUID updateWithSignature(String signature) {
        this.contributionRecord.setSignature(signature);
        this.contributionRecord.setState(ContributionState.valueOf((String)"complete"));
        this.contributionRecord.update();
        return this.contributionRecord.getId();
    }

    @Override
    public void updateComposition(I_CompositionAccess compositionAccess) {
        this.compositions.remove(compositionAccess.getId());
        this.compositions.put(compositionAccess.getId(), compositionAccess);
        this.log.info("Updated composition with id:" + compositionAccess.getId());
        this.contributionRecord.changed(true);
        this.update(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        boolean updated = false;
        if (force || this.contributionRecord.changed()) {
            if (!this.contributionRecord.changed()) {
                this.contributionRecord.changed(true);
                this.contributionRecord.changed((Field)Tables.CONTRIBUTION.SYS_PERIOD, false);
            }
            this.contributionRecord.setSysTransaction(transactionTime);
            this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.MODIFICATION));
            if (this.auditDetails.update(transactionTime, force).equals(Boolean.FALSE)) {
                throw new InternalServerException("Couldn't update auditDetails");
            }
            this.contributionRecord.setHasAudit(this.auditDetails.getId());
            this.contributionRecord.setId(UUID.randomUUID());
            updated = this.contributionRecord.insert() == 1;
        }
        return updated;
    }

    @Override
    public Boolean update() {
        return this.update(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public Boolean update(Boolean force) {
        return this.update(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public Integer delete() {
        int count = 0;
        return count += this.contributionRecord.delete();
    }

    private void deleteRemovedCompositions(Collection<UUID> removed) {
        if (removed.isEmpty()) {
            return;
        }
        for (UUID uuid : removed) {
            this.getContext().delete((Table)Tables.COMPOSITION).where(Tables.COMPOSITION.ID.eq((Object)uuid));
            this.log.debug("Deleted composition:" + uuid);
        }
    }

    private void commitAddedCompositions(Collection<UUID> added, Timestamp transactionTime) {
        if (added.isEmpty()) {
            return;
        }
        for (UUID uuid : added) {
            this.compositions.get(uuid).commit(transactionTime);
            this.log.debug("Committed composition:" + uuid);
        }
    }

    private void updateChangedCompositions(Collection<UUID> updated, Timestamp transactionTime, boolean force) {
        if (updated.isEmpty()) {
            return;
        }
        for (UUID uuid : updated) {
            this.compositions.get(uuid).update(transactionTime, force);
            this.log.debug("Updated composition:" + uuid);
        }
    }

    public I_ContributionAccess retrieve(UUID id) {
        return ContributionAccess.retrieveInstance(this, id);
    }

    @Override
    public UUID getContributionId() {
        return this.contributionRecord.getId();
    }

    @Override
    public void setAuditDetailsChangeType(UUID changeType) {
        this.auditDetails.setChangeType(changeType);
    }

    @Override
    public ContributionDataType getContributionDataType() {
        return this.contributionRecord.getContributionType();
    }

    @Override
    public void setContributionDataType(ContributionDataType contributionDataType) {
        this.contributionRecord.setContributionType(contributionDataType);
    }

    @Override
    public void setState(ContributionDef.ContributionState state) {
        if (state != null) {
            this.contributionRecord.setState(ContributionState.valueOf((String)state.getLiteral()));
        }
    }

    @Override
    public void setComplete() {
        this.contributionRecord.setState(ContributionState.valueOf((String)ContributionState.complete.getLiteral()));
    }

    @Override
    public void setIncomplete() {
        this.contributionRecord.setState(ContributionState.valueOf((String)ContributionState.incomplete.getLiteral()));
    }

    @Override
    public void setDeleted() {
        this.contributionRecord.setState(ContributionState.valueOf((String)ContributionState.deleted.getLiteral()));
    }

    @Override
    public void setAuditDetailsValues(UUID committer, UUID system, String description) {
        if (committer == null || system == null) {
            throw new IllegalArgumentException("arguments not optional");
        }
        this.auditDetails.setCommitter(committer);
        this.auditDetails.setSystemId(system);
        if (description != null) {
            this.auditDetails.setDescription(description);
        }
    }

    @Override
    public void setAuditDetailsValues(AuditDetails auditObject) {
        UUID committer = I_PartyIdentifiedAccess.getOrCreateParty(this, (PartyIdentified)auditObject.getCommitter());
        UUID system = I_SystemAccess.createOrRetrieveInstanceId(this, null, auditObject.getSystemId());
        UUID changeType = I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, auditObject.getChangeType().getValue());
        if (committer == null || system == null) {
            throw new IllegalArgumentException("arguments not optional");
        }
        this.auditDetails.setCommitter(committer);
        this.auditDetails.setSystemId(system);
        this.auditDetails.setChangeType(changeType);
        if (auditObject.getDescription() != null) {
            this.auditDetails.setDescription(auditObject.getDescription().getValue());
        }
    }

    @Override
    public UUID getAuditsCommitter() {
        return this.auditDetails.getCommitter();
    }

    @Override
    public UUID getAuditsSystemId() {
        return this.auditDetails.getSystemId();
    }

    @Override
    public String getAuditsDescription() {
        return this.auditDetails.getDescription();
    }

    @Override
    public ContributionDef.ContributionType getContributionType() {
        return ContributionDef.ContributionType.valueOf(this.contributionRecord.getContributionType().getLiteral());
    }

    @Override
    public ContributionDef.ContributionState getContributionState() {
        return ContributionDef.ContributionState.valueOf(this.contributionRecord.getState().getLiteral());
    }

    @Override
    public UUID getEhrId() {
        return this.contributionRecord.getEhrId();
    }

    @Override
    public Set<UUID> getCompositionIds() {
        return this.compositions.keySet();
    }

    @Override
    public I_CompositionAccess getComposition(UUID id) {
        return this.compositions.get(id);
    }

    @Override
    public String getDataType() {
        return this.contributionRecord.getContributionType().getLiteral();
    }

    @Override
    public void setDataType(ContributionDataType contributionDataType) {
        this.contributionRecord.setContributionType(contributionDataType);
    }

    @Override
    public UUID getId() {
        return this.contributionRecord.getId();
    }

    @Override
    public void setEhrId(UUID ehrId) {
        this.contributionRecord.setEhrId(ehrId);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public void setHasAuditDetails(UUID auditId) {
        this.contributionRecord.setHasAudit(auditId);
    }

    @Override
    public UUID getHasAuditDetails() {
        return this.contributionRecord.getHasAudit();
    }
}

