/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_EhrAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.interfaces.I_StatusAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.jooq.StatusAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.records.ContributionRecord;
import org.ehrbase.jooq.pg.tables.records.EhrRecord;
import org.ehrbase.jooq.pg.tables.records.IdentifierRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.jooq.pg.tables.records.StatusHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.StatusRecord;
import org.ehrbase.serialisation.RawJson;
import org.jooq.DSLContext;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;

public class EhrAccess
extends DataAccess
implements I_EhrAccess {
    private static final Logger log = LogManager.getLogger(EhrAccess.class);
    public static final String JSONB = "::jsonb";
    public static final String EXCEPTION = " exception:";
    public static final String COULD_NOT_RETRIEVE_EHR_FOR_ID = "Could not retrieve EHR for id:";
    public static final String COULD_NOT_RETRIEVE_EHR_FOR_PARTY = "Could not retrieve EHR for party:";
    private EhrRecord ehrRecord;
    private boolean isNew = false;
    private ItemStructure otherDetails = null;
    private String otherDetailsTemplateId;
    private I_ContributionAccess contributionAccess = null;
    private I_StatusAccess statusAccess;
    private PARTY_MODE party_identifier = PARTY_MODE.EXTERNAL_REF;

    public EhrAccess(DSLContext context, ServerConfig serverConfig, UUID partyId, UUID systemId, UUID directoryId, UUID accessId, UUID ehrId) {
        super(context, null, null, serverConfig);
        this.ehrRecord = (EhrRecord)context.newRecord((Table)Tables.EHR_);
        if (ehrId != null) {
            this.ehrRecord.setId(ehrId);
        } else {
            this.ehrRecord.setId(UUID.randomUUID());
        }
        if (I_StatusAccess.retrieveInstanceByParty(this.getDataAccess(), partyId) != null) {
            log.warn("This party is already associated to an EHR");
            throw new IllegalArgumentException("Party:" + partyId + " already associated to an EHR, please retrieveInstanceByNamedSubject the associated EHR for updates instead");
        }
        this.statusAccess = new StatusAccess(this, this.ehrRecord.getId());
        this.statusAccess.getStatusRecord().setId(UUID.randomUUID());
        this.statusAccess.getStatusRecord().setIsModifiable(Boolean.valueOf(true));
        this.statusAccess.getStatusRecord().setIsQueryable(Boolean.valueOf(true));
        this.statusAccess.getStatusRecord().setParty(partyId);
        this.statusAccess.getStatusRecord().setEhrId(this.ehrRecord.getId());
        this.ehrRecord.setSystemId(systemId);
        this.ehrRecord.setDirectory(directoryId);
        this.ehrRecord.setAccess(accessId);
        if (this.ehrRecord.getSystemId() == null) {
            this.ehrRecord.setSystemId(I_SystemAccess.createOrRetrieveLocalSystem(this));
        }
        this.isNew = true;
        this.contributionAccess = I_ContributionAccess.getInstance(this, this.ehrRecord.getId());
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
    }

    private EhrAccess(I_DomainAccess domainAccess, UUID ehrId) {
        super(domainAccess);
        this.statusAccess = new StatusAccess(this, ehrId);
        this.contributionAccess = I_ContributionAccess.getInstance(this, ehrId);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
    }

    public static UUID retrieveInstanceBySubject(I_DomainAccess domainAccess, UUID subjectUuid) {
        Record record;
        DSLContext context = domainAccess.getContext();
        try {
            record = context.select((SelectField)Tables.STATUS.EHR_ID).from((TableLike)Tables.STATUS).where(Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)subjectUuid)))).fetchOne();
        }
        catch (Exception e) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectUuid + EXCEPTION + e);
            throw new IllegalArgumentException("Could not retrieve  EHR for party:" + subjectUuid + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectUuid);
            return null;
        }
        return (UUID)record.getValue(0);
    }

    public static UUID retrieveInstanceBySubject(I_DomainAccess domainAccess, String subjectId, String issuerSpace) {
        Record record;
        DSLContext context = domainAccess.getContext();
        IdentifierRecord identifierRecord = (IdentifierRecord)context.fetchOne((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.ID_VALUE.eq((Object)subjectId).and(Tables.IDENTIFIER.ISSUER.eq((Object)issuerSpace)));
        if (identifierRecord == null) {
            throw new IllegalArgumentException("Could not invalidateContent an identified party for code:" + subjectId + " issued by:" + issuerSpace);
        }
        try {
            record = context.select((SelectField)Tables.STATUS.EHR_ID).from((TableLike)Tables.STATUS).where(Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)identifierRecord.getParty())))).fetchOne();
        }
        catch (Exception e) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectId + EXCEPTION + e);
            throw new IllegalArgumentException(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectId + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectId);
            return null;
        }
        return (UUID)record.getValue(0);
    }

    public static UUID retrieveInstanceBySubjectExternalRef(I_DomainAccess domainAccess, String subjectId, String issuerSpace) {
        Record record;
        DSLContext context = domainAccess.getContext();
        try {
            record = context.select((SelectField)Tables.STATUS.EHR_ID).from((TableLike)Tables.STATUS).where(Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.eq((Object)subjectId).and(Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.eq((Object)issuerSpace))))).fetchOne();
        }
        catch (Exception e) {
            log.warn("Could not ehr for party:" + subjectId + EXCEPTION + e);
            throw new IllegalArgumentException(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectId + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn("Could not retrieve ehr for party:" + subjectId);
            return null;
        }
        return (UUID)record.getValue(0);
    }

    public static I_EhrAccess retrieveInstanceByStatus(I_DomainAccess domainAccess, UUID ehrId, UUID status, Integer version) {
        Record record;
        if (version < 1) {
            throw new IllegalArgumentException("Version number must be > 0");
        }
        EhrAccess ehrAccess = new EhrAccess(domainAccess, ehrId);
        I_StatusAccess statusAccess = I_StatusAccess.retrieveInstance(domainAccess, status);
        ehrAccess.setStatusAccess(statusAccess);
        Integer versions = domainAccess.getContext().fetchCount((Table)Tables.STATUS_HISTORY, Tables.STATUS_HISTORY.EHR_ID.eq((Object)ehrAccess.getStatusAccess().getStatusRecord().getEhrId())) + 1;
        if (versions > version && !version.equals(versions)) {
            Result result = domainAccess.getContext().selectFrom((Table)Tables.STATUS_HISTORY).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.asc()).fetch();
            if (result.isEmpty()) {
                throw new InternalServerException("Error retrieving EHR_STATUS");
            }
            StatusHistoryRecord statusHistoryRecord = (StatusHistoryRecord)result.get(version - 1);
            ehrAccess.getStatusAccess().getStatusRecord().setIsQueryable(statusHistoryRecord.getIsQueryable());
            ehrAccess.getStatusAccess().getStatusRecord().setIsModifiable(statusHistoryRecord.getIsModifiable());
            ehrAccess.getStatusAccess().getStatusRecord().setParty(statusHistoryRecord.getParty());
            ehrAccess.getStatusAccess().getStatusRecord().setOtherDetails(statusHistoryRecord.getOtherDetails());
            ehrAccess.getStatusAccess().getStatusRecord().setSysTransaction(statusHistoryRecord.getSysTransaction());
            ehrAccess.getStatusAccess().getStatusRecord().setSysPeriod(statusHistoryRecord.getSysPeriod());
        }
        try {
            record = domainAccess.getContext().selectFrom((Table)Tables.EHR_).where(Tables.EHR_.ID.eq((Object)ehrAccess.getStatusAccess().getStatusRecord().getEhrId())).fetchOne();
        }
        catch (Exception e) {
            log.warn("Could not retrieveInstanceByNamedSubject ehr for status:" + status + EXCEPTION + e);
            throw new IllegalArgumentException("Could not retrieveInstanceByNamedSubject EHR for status:" + status + EXCEPTION + e);
        }
        if (record.size() == 0) {
            log.warn("Could not retrieveInstanceByNamedSubject ehr for status:" + status);
            return null;
        }
        ehrAccess.ehrRecord = (EhrRecord)record;
        ehrAccess.isNew = false;
        return ehrAccess;
    }

    public static I_EhrAccess retrieveInstance(I_DomainAccess domainAccess, UUID ehrId) {
        Record record;
        DSLContext context = domainAccess.getContext();
        EhrAccess ehrAccess = new EhrAccess(domainAccess, ehrId);
        try {
            record = context.selectFrom((Table)Tables.EHR_).where(Tables.EHR_.ID.eq((Object)ehrId)).fetchOne();
        }
        catch (Exception e) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_ID + ehrId + EXCEPTION + e);
            throw new IllegalArgumentException(COULD_NOT_RETRIEVE_EHR_FOR_ID + ehrId + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_ID + ehrId);
            return null;
        }
        ehrAccess.ehrRecord = (EhrRecord)record;
        I_StatusAccess statusAccess = I_StatusAccess.retrieveInstanceByEhrId(domainAccess, ehrAccess.ehrRecord.getId());
        ehrAccess.setStatusAccess(statusAccess);
        if (ehrAccess.getStatusAccess().getStatusRecord().getOtherDetails() != null) {
            ehrAccess.otherDetails = ehrAccess.getStatusAccess().getStatusRecord().getOtherDetails();
        }
        ehrAccess.isNew = false;
        ContributionRecord contributionRecord = (ContributionRecord)context.fetchOne((Table)Tables.CONTRIBUTION, Tables.CONTRIBUTION.EHR_ID.eq((Object)ehrAccess.ehrRecord.getId()).and(Tables.CONTRIBUTION.CONTRIBUTION_TYPE.eq((Object)ContributionDataType.ehr)));
        if (contributionRecord == null) {
            throw new IllegalArgumentException("DB inconsistency: could not find a related contribution for ehr=" + ehrAccess.ehrRecord.getId());
        }
        UUID contributionId = contributionRecord.getId();
        if (contributionId != null) {
            ehrAccess.setContributionAccess(I_ContributionAccess.retrieveInstance(domainAccess, contributionId));
        }
        return ehrAccess;
    }

    public static Map<String, Object> fetchSubjectIdentifiers(I_DomainAccess domainAccess, UUID ehrId) {
        EhrAccess ehrAccess = (EhrAccess)EhrAccess.retrieveInstance(domainAccess, ehrId);
        DSLContext context = domainAccess.getContext();
        if (ehrAccess == null) {
            throw new IllegalArgumentException("No ehr found for id:" + ehrId);
        }
        MultiValueMap idlist = new MultiValueMap();
        context.selectFrom((Table)Tables.IDENTIFIER).where(Tables.IDENTIFIER.PARTY.eq((Object)EhrAccess.getParty(ehrAccess))).fetch().forEach(arg_0 -> EhrAccess.lambda$fetchSubjectIdentifiers$0((Map)idlist, arg_0));
        context.selectFrom((Table)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)EhrAccess.getParty(ehrAccess))).fetch().forEach(arg_0 -> EhrAccess.lambda$fetchSubjectIdentifiers$1((Map)idlist, arg_0));
        return idlist;
    }

    public static Map<String, Map<String, String>> getCompositionList(I_DomainAccess domainAccess, UUID ehrId) {
        EhrAccess ehrAccess = (EhrAccess)EhrAccess.retrieveInstance(domainAccess, ehrId);
        DSLContext context = domainAccess.getContext();
        if (ehrAccess == null) {
            throw new IllegalArgumentException("No ehr found for id:" + ehrId);
        }
        HashMap<String, Map<String, String>> compositionlist = new HashMap<String, Map<String, String>>();
        context.selectFrom((Table)Tables.ENTRY).where(Tables.ENTRY.COMPOSITION_ID.eq((Select)context.select((SelectField)Tables.COMPOSITION.ID).from((TableLike)Tables.COMPOSITION).where(Tables.COMPOSITION.EHR_ID.eq((Object)ehrId)))).fetch().forEach(record -> {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("composition_id", record.getCompositionId().toString());
            details.put("templateId", record.getTemplateId());
            details.put("date", record.getSysTransaction().toString());
            compositionlist.put("details", details);
        });
        return compositionlist;
    }

    private static UUID getParty(EhrAccess ehrAccess) {
        return ehrAccess.getStatusRecord().getParty();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    private String serializeOtherDetails() {
        return new RawJson().marshal((RMObject)this.otherDetails);
    }

    @Override
    public void setAccess(UUID access) {
        this.ehrRecord.setAccess(access);
    }

    @Override
    public void setDirectory(UUID directory) {
        this.ehrRecord.setDirectory(directory);
    }

    @Override
    public void setSystem(UUID system) {
        this.ehrRecord.setSystemId(system);
    }

    @Override
    public void setModifiable(Boolean modifiable) {
        this.getStatusAccess().getStatusRecord().setIsModifiable(modifiable);
    }

    @Override
    public void setQueryable(Boolean queryable) {
        this.getStatusAccess().getStatusRecord().setIsQueryable(queryable);
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.ehrRecord.setDateCreated(transactionTime);
        this.ehrRecord.setDateCreatedTzid(ZonedDateTime.now().getZone().getId());
        this.ehrRecord.store();
        UUID contributionId = this.contributionAccess.commit(transactionTime);
        if (this.isNew && this.getStatusAccess().getStatusRecord() != null) {
            this.statusAccess.setContributionId(contributionId);
            this.statusAccess.commitWithCustomContribution(transactionTime, this.ehrRecord.getId(), this.otherDetails);
        }
        return this.ehrRecord.getId();
    }

    @Override
    @Deprecated
    public UUID commit() {
        throw new InternalServerException("INTERNAL: this commit is not legal");
    }

    @Override
    public UUID commit(UUID committerId, UUID systemId, String description) {
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        this.contributionAccess.setAuditDetailsValues(committerId, systemId, description);
        this.contributionAccess.setDataType(ContributionDataType.ehr);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.contributionAccess.setAuditDetailsChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
        this.statusAccess.setAuditAndContributionAuditValues(systemId, committerId, description);
        return this.commit(timestamp);
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        boolean result = false;
        result = this.statusAccess.update(this.otherDetails, transactionTime, force);
        if (force || this.ehrRecord.changed()) {
            this.ehrRecord.setDateCreated(transactionTime);
            this.ehrRecord.setDateCreatedTzid(ZonedDateTime.now().getZone().getId());
            result |= this.ehrRecord.update() > 0;
        }
        return result;
    }

    @Override
    @Deprecated
    public Boolean update() {
        throw new InternalServerException("INTERNAL: this update is not legal");
    }

    @Override
    @Deprecated
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: this update is not legal");
    }

    @Override
    public Boolean update(UUID committerId, UUID systemId, ContributionDef.ContributionState state, I_ConceptAccess.ContributionChangeType contributionChangeType, String description) {
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        this.contributionAccess.setAuditDetailsValues(committerId, systemId, description);
        this.contributionAccess.setState(state);
        this.contributionAccess.setAuditDetailsChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, contributionChangeType));
        return this.update(timestamp);
    }

    @Override
    @Deprecated
    public Integer delete() {
        throw new InternalServerException("INTERNAL: this delete is not legal");
    }

    @Override
    public UUID reload() {
        Record record;
        try {
            record = this.getContext().selectFrom((Table)Tables.EHR_).where(Tables.EHR_.ID.eq((Object)this.getId())).fetchOne();
        }
        catch (Exception e) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_ID + this.getId() + EXCEPTION + e);
            throw new IllegalArgumentException(COULD_NOT_RETRIEVE_EHR_FOR_ID + this.getId() + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_ID + this.getId());
            return null;
        }
        this.ehrRecord = (EhrRecord)record;
        I_StatusAccess retStatusAccess = I_StatusAccess.retrieveInstanceByEhrId(this.getDataAccess(), this.ehrRecord.getId());
        this.setStatusAccess(retStatusAccess);
        this.isNew = false;
        return this.getId();
    }

    public I_EhrAccess retrieve(UUID id) {
        return EhrAccess.retrieveInstance(this, id);
    }

    @Override
    public EhrRecord getEhrRecord() {
        return this.ehrRecord;
    }

    private StatusRecord getStatusRecord() {
        return this.getStatusAccess().getStatusRecord();
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public UUID getParty() {
        return this.getStatusAccess().getStatusRecord().getParty();
    }

    @Override
    public void setParty(UUID partyId) {
        this.getStatusAccess().getStatusRecord().setParty(partyId);
    }

    @Override
    public UUID getId() {
        return this.ehrRecord.getId();
    }

    @Override
    public Boolean isModifiable() {
        return this.getStatusAccess().getStatusRecord().getIsModifiable();
    }

    @Override
    public Boolean isQueryable() {
        return this.getStatusAccess().getStatusRecord().getIsQueryable();
    }

    @Override
    public UUID getSystemId() {
        return this.ehrRecord.getSystemId();
    }

    @Override
    public UUID getStatusId() {
        return I_StatusAccess.retrieveInstanceByEhrId(this.getDataAccess(), this.getId()).getId();
    }

    @Override
    public UUID getDirectoryId() {
        return this.ehrRecord.getDirectory();
    }

    @Override
    public UUID getAccessId() {
        return this.ehrRecord.getAccess();
    }

    @Override
    public void setOtherDetails(ItemStructure otherDetails, String templateId) {
        this.otherDetails = otherDetails;
        this.otherDetailsTemplateId = Optional.ofNullable(otherDetails).map(Locatable::getArchetypeDetails).map(Archetyped::getTemplateId).map(ObjectId::getValue).orElse(null);
    }

    @Override
    public ItemStructure getOtherDetails() {
        return this.otherDetails;
    }

    public I_ContributionAccess getContributionAccess() {
        return this.contributionAccess;
    }

    @Override
    public void setContributionAccess(I_ContributionAccess contributionAccess) {
        this.contributionAccess = contributionAccess;
    }

    @Override
    public I_StatusAccess getStatusAccess() {
        return this.statusAccess;
    }

    @Override
    public void setStatusAccess(I_StatusAccess statusAccess) {
        this.statusAccess = statusAccess;
    }

    @Override
    public void setStatus(EhrStatus status) {
        this.setModifiable(status.isModifiable());
        this.setQueryable(status.isQueryable());
        this.setOtherDetails(status.getOtherDetails(), null);
        String subjectId = status.getSubject().getExternalRef().getId().getValue();
        String subjectNamespace = status.getSubject().getExternalRef().getNamespace();
        UUID subjectUuid = I_PartyIdentifiedAccess.getOrCreatePartyByExternalRef(this.getDataAccess(), null, subjectId, "DEMOGRAPHIC", subjectNamespace, "PARTY");
        this.setParty(subjectUuid);
    }

    @Override
    public EhrStatus getStatus() {
        EhrStatus status = new EhrStatus();
        status.setModifiable(this.isModifiable().booleanValue());
        status.setQueryable(this.isQueryable().booleanValue());
        if (this.getStatusAccess().getStatusRecord().getOtherDetails() != null) {
            status.setOtherDetails(this.getStatusAccess().getStatusRecord().getOtherDetails());
        }
        status.setUid((UIDBasedId)new HierObjectId(this.getStatusAccess().getStatusRecord().getId().toString()));
        I_PartyIdentifiedAccess party = I_PartyIdentifiedAccess.retrieveInstance(this.getDataAccess(), this.getParty());
        PartySelf partySelf = new PartySelf(new PartyRef((ObjectId)new HierObjectId(party.getPartyRefValue()), party.getPartyRefNamespace(), null));
        status.setSubject(partySelf);
        return status;
    }

    @Override
    public Integer getLastVersionNumberOfStatus(I_DomainAccess domainAccess, UUID ehrStatusId) {
        if (!EhrAccess.hasPreviousVersionOfStatus(domainAccess, ehrStatusId)) {
            return 1;
        }
        int versionCount = domainAccess.getContext().fetchCount((Table)Tables.STATUS_HISTORY, Tables.STATUS_HISTORY.ID.eq((Object)ehrStatusId));
        return versionCount + 1;
    }

    private static boolean hasPreviousVersionOfStatus(I_DomainAccess domainAccess, UUID ehrStatusId) {
        return domainAccess.getContext().fetchExists((Table)Tables.STATUS_HISTORY, Tables.STATUS_HISTORY.ID.eq((Object)ehrStatusId));
    }

    @Override
    public int getEhrStatusVersionFromTimeStamp(Timestamp time) {
        UUID statusUid = this.getStatusId();
        I_StatusAccess retStatusAccess = I_StatusAccess.retrieveInstance(this.getDataAccess(), statusUid);
        Result result = this.getDataAccess().getContext().selectFrom((Table)Tables.STATUS_HISTORY).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.asc()).fetch();
        Collections.reverse(result);
        if (time.after(retStatusAccess.getStatusRecord().getSysTransaction())) {
            return this.getLastVersionNumberOfStatus(this.getDataAccess(), statusUid);
        }
        for (int i = 0; i < result.size(); ++i) {
            if (result.get(i) instanceof StatusHistoryRecord) {
                if (!time.after(((StatusHistoryRecord)result.get(i)).getSysTransaction())) continue;
                return result.size() - i;
            }
            throw new InternalServerException("Problem comparing timestamps of EHR_STATUS versions");
        }
        throw new ObjectNotFoundException("EHR_STATUS", "Could not find EHR_STATUS version matching given timestamp");
    }

    @Override
    public Timestamp getInitialTimeOfVersionedEhrStatus() {
        Result result = this.getDataAccess().getContext().selectFrom((Table)Tables.STATUS_HISTORY).where(Tables.STATUS_HISTORY.EHR_ID.eq((Object)this.ehrRecord.getId())).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.asc()).fetch();
        if (!result.isEmpty()) {
            StatusHistoryRecord statusHistoryRecord = (StatusHistoryRecord)result.get(0);
            return statusHistoryRecord.getSysTransaction();
        }
        return this.getStatusAccess().getStatusRecord().getSysTransaction();
    }

    @Override
    public Integer getNumberOfEhrStatusVersions() {
        return this.getDataAccess().getContext().fetchCount((Table)Tables.STATUS_HISTORY, Tables.STATUS_HISTORY.EHR_ID.eq((Object)this.getStatusAccess().getStatusRecord().getEhrId())) + 1;
    }

    private static /* synthetic */ void lambda$fetchSubjectIdentifiers$1(Map idlist, PartyIdentifiedRecord record) {
        idlist.put("ref_name_space", record.getPartyRefNamespace());
        idlist.put("id_value", record.getPartyRefValue());
        idlist.put("ref_name_scheme", record.getPartyRefScheme());
        idlist.put("ref_party_type", record.getPartyRefType());
    }

    private static /* synthetic */ void lambda$fetchSubjectIdentifiers$0(Map idlist, IdentifierRecord record) {
        idlist.put("identifier_issuer", record.getIssuer());
        idlist.put("identifier_id_value", record.getIdValue());
    }

    public static enum PARTY_MODE {
        IDENTIFIER,
        EXTERNAL_REF;

    }
}

