/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.AdminEntry;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.composition.Section;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContainmentAccess;
import org.ehrbase.dao.access.interfaces.I_ContextAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.jooq.ContainmentAccess;
import org.ehrbase.dao.access.jooq.SystemValue;
import org.ehrbase.dao.access.query.AsyncSqlQuery;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.EntryType;
import org.ehrbase.jooq.pg.tables.records.EntryHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EntryRecord;
import org.ehrbase.jooq.pg.tables.records.TerritoryRecord;
import org.ehrbase.serialisation.RawJson;
import org.ehrbase.service.IntrospectService;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.UpdateQuery;
import org.jooq.impl.DSL;

public class EntryAccess
extends DataAccess
implements I_EntryAccess {
    private static final Logger log = LogManager.getLogger(EntryAccess.class);
    public static final String DB_INCONSISTENCY = "DB inconsistency:";
    private EntryRecord entryRecord;
    private I_ContainmentAccess containmentAccess;
    private Composition composition;

    public EntryAccess(DSLContext context, I_KnowledgeCache knowledge, IntrospectService introspectCache, ServerConfig serverConfig, String templateId, Integer sequence, UUID compositionId, Composition composition) {
        super(context, knowledge, introspectCache, serverConfig);
        this.setFields(templateId, sequence, compositionId, composition);
    }

    public EntryAccess(I_DomainAccess domainAccess, String templateId, Integer sequence, UUID compositionId, Composition composition) {
        super(domainAccess.getContext(), domainAccess.getKnowledgeManager(), domainAccess.getIntrospectService(), domainAccess.getServerConfig());
        this.setFields(templateId, sequence, compositionId, composition);
    }

    private EntryAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public static List<I_EntryAccess> retrieveInstanceInComposition(I_DomainAccess domainAccess, I_CompositionAccess compositionAccess) {
        Result entryRecords = domainAccess.getContext().selectFrom((Table)Tables.ENTRY).where(Tables.ENTRY.COMPOSITION_ID.eq((Object)compositionAccess.getId())).fetch();
        HashMap<SystemValue, Object> values = new HashMap<SystemValue, Object>();
        values.put(SystemValue.COMPOSER, I_PartyIdentifiedAccess.retrievePartyIdentified(domainAccess, compositionAccess.getComposerId()));
        Optional<I_ContextAccess> opContextAccess = compositionAccess.getContextId().map(id -> I_ContextAccess.retrieveInstance(domainAccess, id));
        opContextAccess.ifPresent(context -> values.put(SystemValue.CONTEXT, context.mapRmEventContext()));
        values.put(SystemValue.LANGUAGE, new CodePhrase(new TerminologyId("ISO_639-1"), compositionAccess.getLanguageCode()));
        String territory2letters = ((TerritoryRecord)domainAccess.getContext().fetchOne((Table)Tables.TERRITORY, Tables.TERRITORY.CODE.eq((Object)compositionAccess.getTerritoryCode()))).getTwoletter();
        values.put(SystemValue.TERRITORY, new CodePhrase(new TerminologyId("ISO_3166-1"), territory2letters));
        ArrayList<I_EntryAccess> content = new ArrayList<I_EntryAccess>();
        try {
            EntryAccess entryAccess = new EntryAccess(domainAccess);
            for (EntryRecord record : entryRecords) {
                Integer version = I_CompositionAccess.getLastVersionNumber(domainAccess, compositionAccess.getId());
                values.put(SystemValue.UID, new ObjectVersionId(compositionAccess.getId().toString() + "::" + domainAccess.getServerConfig().getNodename() + "::" + version));
                entryAccess.entryRecord = record;
                String value = record.getEntry().data();
                entryAccess.composition = (Composition)new RawJson().unmarshal(value, Composition.class);
                opContextAccess.map(I_ContextAccess::mapRmEventContext).ifPresent(ec -> values.put(SystemValue.CONTEXT, ec));
                EntryAccess.setCompositionAttributes(entryAccess.composition, values);
                EntryAccess.buildArchetypeDetails(entryAccess);
                content.add(entryAccess);
            }
        }
        catch (Exception e) {
            log.error(DB_INCONSISTENCY + e);
            throw new IllegalArgumentException(DB_INCONSISTENCY + e);
        }
        return content;
    }

    private static void buildArchetypeDetails(EntryAccess entryAccess) {
        Archetyped archetypeDetails = new Archetyped();
        TemplateId templateId = new TemplateId();
        templateId.setValue(entryAccess.getTemplateId());
        archetypeDetails.setTemplateId(templateId);
        archetypeDetails.setArchetypeId(new ArchetypeID(entryAccess.getArchetypeId()));
        entryAccess.composition.setArchetypeDetails(archetypeDetails);
        entryAccess.composition.setCategory(I_ConceptAccess.fetchConceptText(entryAccess, entryAccess.getCategory()));
    }

    public static List<I_EntryAccess> retrieveInstanceInCompositionVersion(I_DomainAccess domainAccess, I_CompositionAccess compositionHistoryAccess, int version) {
        Result entryHistoryRecords = domainAccess.getContext().selectFrom((Table)Tables.ENTRY_HISTORY).where(Tables.ENTRY_HISTORY.COMPOSITION_ID.eq((Object)compositionHistoryAccess.getId())).and(Tables.ENTRY_HISTORY.SYS_TRANSACTION.eq((Object)compositionHistoryAccess.getSysTransaction())).fetch();
        HashMap<SystemValue, Object> values = new HashMap<SystemValue, Object>();
        values.put(SystemValue.COMPOSER, I_PartyIdentifiedAccess.retrievePartyIdentified(domainAccess, compositionHistoryAccess.getComposerId()));
        EventContext context = I_ContextAccess.retrieveHistoricalEventContext(domainAccess, compositionHistoryAccess.getId(), compositionHistoryAccess.getSysTransaction());
        if (context == null) {
            compositionHistoryAccess.getContextId().ifPresent(uuid -> I_ContextAccess.retrieveInstance(domainAccess, uuid).mapRmEventContext());
        }
        values.put(SystemValue.CONTEXT, context);
        values.put(SystemValue.LANGUAGE, new CodePhrase(new TerminologyId("ISO_639-1"), compositionHistoryAccess.getLanguageCode()));
        String territory2letters = ((TerritoryRecord)domainAccess.getContext().fetchOne((Table)Tables.TERRITORY, Tables.TERRITORY.CODE.eq((Object)compositionHistoryAccess.getTerritoryCode()))).getTwoletter();
        values.put(SystemValue.TERRITORY, new CodePhrase(new TerminologyId("ISO_3166-1"), territory2letters));
        ArrayList<I_EntryAccess> content = new ArrayList<I_EntryAccess>();
        try {
            EntryAccess entryAccess = new EntryAccess(domainAccess);
            for (EntryHistoryRecord record : entryHistoryRecords) {
                UUID compositionId = compositionHistoryAccess.getId();
                values.put(SystemValue.UID, new ObjectVersionId(compositionId.toString() + "::" + domainAccess.getServerConfig().getNodename() + "::" + version));
                entryAccess.entryRecord = (EntryRecord)domainAccess.getContext().newRecord((Table)Tables.ENTRY);
                entryAccess.entryRecord.from((Object)record);
                entryAccess.composition = (Composition)new RawJson().unmarshal(record.getEntry().data(), Composition.class);
                EntryAccess.setCompositionAttributes(entryAccess.composition, values);
                EntryAccess.buildArchetypeDetails(entryAccess);
                content.add(entryAccess);
            }
        }
        catch (Exception e) {
            log.error(DB_INCONSISTENCY + e);
            throw new IllegalArgumentException(DB_INCONSISTENCY + e);
        }
        return content;
    }

    public static Map<String, Object> queryJSON(I_DomainAccess domainAccess, String queryString) {
        return new AsyncSqlQuery(domainAccess, queryString).fetch();
    }

    private static void setCompositionAttributes(Composition composition, Map<SystemValue, Object> values) {
        if (values == null) {
            return;
        }
        block8: for (Map.Entry<SystemValue, Object> systemValue : values.entrySet()) {
            switch (systemValue.getKey()) {
                case CATEGORY: {
                    composition.setCategory((DvCodedText)systemValue.getValue());
                    continue block8;
                }
                case LANGUAGE: {
                    composition.setLanguage((CodePhrase)systemValue.getValue());
                    continue block8;
                }
                case TERRITORY: {
                    composition.setTerritory((CodePhrase)systemValue.getValue());
                    continue block8;
                }
                case COMPOSER: {
                    composition.setComposer((PartyProxy)systemValue.getValue());
                    continue block8;
                }
                case UID: {
                    composition.setUid((UIDBasedId)systemValue.getValue());
                    continue block8;
                }
                case CONTEXT: {
                    composition.setContext((EventContext)systemValue.getValue());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Could not handle composition attribute:" + (Object)((Object)systemValue.getKey()));
        }
    }

    private void setCompositionFields(EntryRecord record, Composition composition) {
        Integer categoryId = Integer.parseInt(composition.getCategory().getDefiningCode().getCodeString());
        record.setCategory(I_ConceptAccess.fetchConcept(this, categoryId, "en"));
        if (composition.getContent() != null && !composition.getContent().isEmpty()) {
            Object node = composition.getContent().get(0);
            if (node instanceof Section) {
                record.setItemType(EntryType.valueOf((String)"section"));
            } else if (node instanceof Evaluation || node instanceof Observation || node instanceof Instruction || node instanceof Action) {
                record.setItemType(EntryType.valueOf((String)"care_entry"));
            } else if (node instanceof AdminEntry) {
                record.setItemType(EntryType.valueOf((String)"admin"));
            }
        } else {
            record.setItemType(EntryType.valueOf((String)"admin"));
        }
        record.setArchetypeId(composition.getArchetypeNodeId());
        RawJson rawJson = new RawJson();
        record.setEntry(JSONB.valueOf((String)rawJson.marshal((RMObject)composition)));
        this.containmentAccess = new ContainmentAccess(this.getDataAccess(), record.getId(), record.getArchetypeId(), rawJson.getLtreeMap(), true);
    }

    private void setFields(String templateId, Integer sequence, UUID compositionId, Composition composition) {
        this.entryRecord = (EntryRecord)this.getContext().newRecord((Table)Tables.ENTRY);
        this.entryRecord.setTemplateId(templateId);
        this.entryRecord.setSequence(sequence);
        this.entryRecord.setCompositionId(compositionId);
        this.setCompositionFields(this.entryRecord, composition);
        this.composition = composition;
    }

    @Override
    public Composition getComposition() {
        return this.composition;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        Record result = this.getContext().insertInto((Table)Tables.ENTRY, (Field)Tables.ENTRY.SEQUENCE, (Field)Tables.ENTRY.COMPOSITION_ID, (Field)Tables.ENTRY.TEMPLATE_ID, (Field)Tables.ENTRY.ITEM_TYPE, (Field)Tables.ENTRY.ARCHETYPE_ID, (Field)Tables.ENTRY.CATEGORY, (Field)Tables.ENTRY.ENTRY_, (Field)Tables.ENTRY.SYS_TRANSACTION).values((Field)DSL.val((Integer)this.getSequence()), (Field)DSL.val((UUID)this.getCompositionId()), (Field)DSL.val((String)this.getTemplateId()), (Field)DSL.val((Object)EntryType.valueOf((String)this.getItemType())), (Field)DSL.val((String)this.getArchetypeId()), (Field)DSL.val((UUID)this.getCategory()), (Field)DSL.val((Object)this.getEntryJson()), (Field)DSL.val((Timestamp)transactionTime)).returning(new SelectFieldOrAsterisk[]{Tables.ENTRY.ID}).fetchOne();
        if (this.containmentAccess != null) {
            this.containmentAccess.setCompositionId(this.entryRecord.getCompositionId());
            this.containmentAccess.update();
        }
        return (UUID)result.getValue((Field)Tables.ENTRY.ID);
    }

    @Override
    @Deprecated
    public UUID commit() {
        throw new InternalServerException("INTERNAL: commit without transaction time is not legal");
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        log.debug("updating entry with force flag:" + force + " and changed flag:" + this.entryRecord.changed());
        if (!force && !this.entryRecord.changed()) {
            log.debug("No updateComposition took place, returning...");
            return false;
        }
        this.entryRecord.changed((Field)Tables.ENTRY.SYS_PERIOD, false);
        UpdateQuery updateQuery = this.getContext().updateQuery((Table)Tables.ENTRY);
        updateQuery.addValue((Field)Tables.ENTRY.COMPOSITION_ID, (Object)this.getCompositionId());
        updateQuery.addValue((Field)Tables.ENTRY.SEQUENCE, DSL.field((SelectField)DSL.val((Integer)this.getSequence())));
        updateQuery.addValue((Field)Tables.ENTRY.TEMPLATE_ID, DSL.field((SelectField)DSL.val((String)this.getTemplateId())));
        updateQuery.addValue((Field)Tables.ENTRY.ITEM_TYPE, DSL.field((SelectField)DSL.val((Object)EntryType.valueOf((String)this.getItemType()))));
        updateQuery.addValue((Field)Tables.ENTRY.ARCHETYPE_ID, DSL.field((SelectField)DSL.val((String)this.getArchetypeId())));
        updateQuery.addValue((Field)Tables.ENTRY.CATEGORY, DSL.field((SelectField)DSL.val((UUID)this.getCategory())));
        updateQuery.addValue((Field)Tables.ENTRY.ENTRY_, DSL.field((SelectField)DSL.val((Object)this.getEntryJson())));
        updateQuery.addValue((Field)Tables.ENTRY.SYS_TRANSACTION, DSL.field((SelectField)DSL.val((Timestamp)transactionTime)));
        updateQuery.addConditions(Tables.ENTRY.ID.eq((Object)this.getId()));
        log.debug("Update done...");
        if (this.containmentAccess != null) {
            this.containmentAccess.setCompositionId(this.entryRecord.getCompositionId());
            this.containmentAccess.update();
        }
        return updateQuery.execute() > 0;
    }

    @Override
    @Deprecated
    public Boolean update() {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    @Deprecated
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    public Integer delete() {
        if (this.entryRecord != null) {
            return this.entryRecord.delete();
        }
        return 0;
    }

    @Override
    public UUID getId() {
        return this.entryRecord.getId();
    }

    @Override
    public JSONB getEntryJson() {
        return this.entryRecord.getEntry();
    }

    @Override
    public UUID getCategory() {
        return this.entryRecord.getCategory();
    }

    @Override
    public UUID getCompositionId() {
        return this.entryRecord.getCompositionId();
    }

    @Override
    public void setCompositionId(UUID compositionId) {
        this.entryRecord.setCompositionId(compositionId);
    }

    @Override
    public String getTemplateId() {
        return this.entryRecord.getTemplateId();
    }

    @Override
    public void setTemplateId(String templateId) {
        this.entryRecord.setTemplateId(templateId);
    }

    @Override
    public Integer getSequence() {
        return this.entryRecord.getSequence();
    }

    @Override
    public void setSequence(Integer sequence) {
        this.entryRecord.setSequence(sequence);
    }

    @Override
    public String getArchetypeId() {
        return this.entryRecord.getArchetypeId();
    }

    @Override
    public String getItemType() {
        return this.entryRecord.getItemType().getLiteral();
    }

    @Override
    public void setCompositionData(Composition composition) {
        this.setCompositionFields(this.entryRecord, composition);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

