/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_FolderAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.jooq.binding.OtherDetailsJsonbBinder;
import org.ehrbase.jooq.binding.SysPeriodBinder;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.Folder;
import org.ehrbase.jooq.pg.tables.FolderHierarchy;
import org.ehrbase.jooq.pg.tables.records.FolderHierarchyRecord;
import org.ehrbase.jooq.pg.tables.records.FolderItemsRecord;
import org.ehrbase.jooq.pg.tables.records.FolderRecord;
import org.ehrbase.jooq.pg.tables.records.ObjectRefRecord;
import org.joda.time.DateTime;
import org.jooq.Attachable;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record13;
import org.jooq.Record8;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class FolderAccess
extends DataAccess
implements I_FolderAccess,
Comparable<FolderAccess> {
    private static final Logger log = LogManager.getLogger(FolderAccess.class);
    private ItemStructure details;
    private List<ObjectRef> items = new ArrayList<ObjectRef>();
    private Map<UUID, I_FolderAccess> subfoldersList = new TreeMap<UUID, I_FolderAccess>();
    private I_ContributionAccess contributionAccess;
    private UUID ehrId;
    private FolderRecord folderRecord;

    public FolderAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
        this.folderRecord = (FolderRecord)this.getContext().newRecord((Table)Folder.FOLDER);
        this.contributionAccess = I_ContributionAccess.getInstance(this, this.ehrId);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
    }

    public FolderAccess(I_DomainAccess domainAccess, UUID ehrId, I_ContributionAccess contributionAccess) {
        super(domainAccess);
        this.ehrId = ehrId;
        this.folderRecord = (FolderRecord)this.getContext().newRecord((Table)Folder.FOLDER);
        this.contributionAccess = contributionAccess;
        if (contributionAccess == null) {
            this.contributionAccess = I_ContributionAccess.getInstance(this, this.ehrId);
        }
        UUID ehrIdLoc = this.contributionAccess.getEhrId();
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, true);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        UUID old_contribution = this.folderRecord.getInContribution();
        UUID new_contribution = this.folderRecord.getInContribution();
        UUID ehrId = this.contributionAccess.getEhrId();
        if (this.contributionAccess.getEhrId() == null) {
            Record1 result1 = (Record1)this.getContext().select((SelectField)Tables.CONTRIBUTION.EHR_ID).from((TableLike)Tables.CONTRIBUTION).where(Tables.CONTRIBUTION.ID.eq((Object)old_contribution)).fetch().get(0);
            ehrId = (UUID)result1.value1();
        }
        this.contributionAccess.setEhrId(ehrId);
        this.contributionAccess.commit(transactionTime, null, null, ContributionDataType.folder, ContributionDef.ContributionState.COMPLETE, I_ConceptAccess.ContributionChangeType.MODIFICATION, null);
        this.getFolderRecord().setInContribution(this.contributionAccess.getId());
        new_contribution = this.folderRecord.getInContribution();
        this.delete(this.folderRecord.getId());
        return this.update(transactionTime, true, true, null, old_contribution, new_contribution);
    }

    private Boolean update(Timestamp transactionTime, boolean force, boolean rootFolder, UUID parentFolder, UUID oldContribution, UUID newContribution) {
        boolean result = false;
        DSLContext dslContext = this.getContext();
        dslContext.attach(new Attachable[]{this.folderRecord});
        this.setInContribution(newContribution);
        FolderRecord updatedFolderRecord = new FolderRecord();
        if (rootFolder) {
            updatedFolderRecord.setId(this.getFolderId());
        }
        updatedFolderRecord.setInContribution(newContribution);
        updatedFolderRecord.setName(this.getFolderName());
        updatedFolderRecord.setArchetypeNodeId(this.getFolderArchetypeNodeId());
        updatedFolderRecord.setActive(Boolean.valueOf(this.isFolderActive()));
        updatedFolderRecord.setDetails(this.getFolderDetails());
        updatedFolderRecord.setSysTransaction(transactionTime);
        updatedFolderRecord.setSysPeriod(this.getFolderSysPeriod());
        dslContext.attach(new Attachable[]{updatedFolderRecord});
        result = updatedFolderRecord.store() > 0;
        UUID updatedFolderId = updatedFolderRecord.getId();
        this.saveFolderItems(updatedFolderId, oldContribution, newContribution, transactionTime, this.getContext());
        if (!rootFolder) {
            FolderHierarchyRecord updatedFhR = new FolderHierarchyRecord();
            updatedFhR.setParentFolder(parentFolder);
            updatedFhR.setChildFolder(updatedFolderId);
            updatedFhR.setInContribution(newContribution);
            updatedFhR.setSysTransaction(transactionTime);
            updatedFhR.setSysPeriod(this.folderRecord.getSysPeriod());
            dslContext.attach(new Attachable[]{updatedFhR});
            updatedFhR.store();
        }
        boolean anySubfolderModified = this.getSubfoldersList().values().stream().map(subfolder -> ((FolderAccess)subfolder).update(transactionTime, force, false, updatedFolderId, oldContribution, newContribution)).reduce((b1, b2) -> b1 != false || b2 != false).orElse(false);
        this.folderRecord = updatedFolderRecord;
        return result || anySubfolderModified;
    }

    private void saveFolderItems(UUID folderId, UUID old_contribution, UUID new_contribution, Timestamp transactionTime, DSLContext context) {
        for (ObjectRef or : this.getItems()) {
            ObjectRefRecord orr = new ObjectRefRecord(or.getNamespace(), or.getType(), UUID.fromString(or.getId().getValue()), new_contribution, transactionTime, this.folderRecord.getSysPeriod());
            context.attach(new Attachable[]{orr});
            orr.store();
            FolderItemsRecord fir = new FolderItemsRecord(folderId, UUID.fromString(or.getId().getValue()), new_contribution, transactionTime, this.folderRecord.getSysPeriod());
            context.attach(new Attachable[]{fir});
            fir.store();
        }
    }

    @Override
    public Boolean update() {
        return this.update(new Timestamp(DateTime.now().getMillis()), true);
    }

    @Override
    public Boolean update(Boolean force) {
        return this.update(new Timestamp(DateTime.now().getMillis()), force);
    }

    @Override
    public Integer delete() {
        return this.delete(this.getFolderId());
    }

    @Override
    public UUID commit() {
        Timestamp timestamp = new Timestamp(DateTime.now().getMillis());
        return this.commit(timestamp);
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.contributionAccess.commit(transactionTime, null, null, ContributionDataType.folder, ContributionDef.ContributionState.COMPLETE, I_ConceptAccess.ContributionChangeType.CREATION, null);
        return this.commit(transactionTime, this.contributionAccess.getContributionId());
    }

    @Override
    public UUID commit(Timestamp transactionTime, UUID contributionId) {
        this.getFolderRecord().setInContribution(contributionId);
        this.getFolderRecord().store();
        this.saveFolderItems(this.getFolderRecord().getId(), contributionId, contributionId, transactionTime, this.getContext());
        this.getSubfoldersList().values().forEach(child -> {
            child.commit(transactionTime, contributionId);
            FolderHierarchyRecord fhRecord = this.buildFolderHierarchyRecord(this.getFolderRecord().getId(), ((FolderAccess)child).getFolderRecord().getId(), contributionId, transactionTime, null);
            fhRecord.store();
        });
        return this.getFolderRecord().getId();
    }

    public static I_FolderAccess retrieveInstanceForExistingFolder(I_DomainAccess domainAccess, UUID folderId) {
        FolderHierarchy sf = Tables.FOLDER_HIERARCHY.as("sf");
        Table sf_table = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY));
        Table folder_table = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER)).as("t_folder1");
        Table folder_table2 = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER)).as("t_folder2");
        Table initial_table = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY).where(Tables.FOLDER_HIERARCHY.PARENT_FOLDER.eq((Object)folderId)));
        Field subfolderChildFolder = DSL.field((String)"subfolders.{0}", (DataType)Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getDataType(), (QueryPart[])new QueryPart[]{Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getUnqualifiedName()});
        Field subfolderParentFolderRef = DSL.field((Name)DSL.name((String[])new String[]{"subfolders", "parent_folder"}), UUID.class);
        Result folderSelectedRecordSub = domainAccess.getContext().withRecursive("subfolders").as((Select)DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])ArrayUtils.addAll((Object[])initial_table.fields(), (Object[])folder_table.fields()))).from((TableLike)initial_table).leftJoin((TableLike)folder_table).on(initial_table.field("parent_folder", Tables.FOLDER_HIERARCHY.PARENT_FOLDER.getType()).eq(folder_table.field("id", Tables.FOLDER.ID.getType()))).union((Select)DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])ArrayUtils.addAll((Object[])sf_table.fields(), (Object[])folder_table2.fields()))).from((TableLike)sf_table).innerJoin("subfolders").on(sf_table.field("parent_folder", Tables.FOLDER_HIERARCHY.PARENT_FOLDER.getType()).eq(subfolderChildFolder)).leftJoin((TableLike)folder_table2).on(folder_table2.field("id", Tables.FOLDER.ID.getType()).eq(subfolderChildFolder)))).select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((Name)DSL.name((String)"subfolders"))).fetch();
        TreeMap<UUID, Map<UUID, I_FolderAccess>> fHierarchyMap = new TreeMap<UUID, Map<UUID, I_FolderAccess>>();
        for (Record record : folderSelectedRecordSub) {
            if (!fHierarchyMap.containsKey((UUID)record.getValue("parent_folder"))) {
                fHierarchyMap.put((UUID)record.getValue("parent_folder"), new TreeMap());
            }
            ((Map)fHierarchyMap.get(record.getValue("parent_folder"))).put((UUID)record.getValue("child_folder"), FolderAccess.buildFolderAccessFromFolderId((UUID)record.getValue("child_folder"), domainAccess, (Result<Record>)folderSelectedRecordSub));
        }
        return FolderAccess.buildFolderAccessHierarchy(fHierarchyMap, folderId, null, (Result<Record>)folderSelectedRecordSub, domainAccess);
    }

    public static I_FolderAccess getNewFolderAccessInstance(I_DomainAccess domainAccess, com.nedap.archie.rm.directory.Folder folder, DateTime dateTime, UUID ehrId) {
        return FolderAccess.buildFolderAccessTreeRecursively(domainAccess, folder, null, dateTime, ehrId, null);
    }

    private Integer delete(UUID folderId) {
        if (folderId == null) {
            throw new IllegalArgumentException("The folder UID provided for performing a delete operation cannot be null.");
        }
        Table sf_table = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY));
        Table initial_table = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY).where(Tables.FOLDER_HIERARCHY.PARENT_FOLDER.eq((Object)folderId)));
        Field subfolderChildFolder = DSL.field((String)"subfolders.{0}", (DataType)Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getDataType(), (QueryPart[])new QueryPart[]{Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getUnqualifiedName()});
        int result = this.getContext().delete((Table)Tables.FOLDER).where(Tables.FOLDER.ID.in((Collection)this.getContext().withRecursive("subfolders").as((Select)DSL.select((SelectFieldOrAsterisk[])initial_table.fields()).from((TableLike)initial_table).union((Select)DSL.select((SelectFieldOrAsterisk[])sf_table.fields()).from((TableLike)sf_table).innerJoin("subfolders").on(sf_table.field("parent_folder", Tables.FOLDER_HIERARCHY.PARENT_FOLDER.getType()).eq(subfolderChildFolder)))).select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((Name)DSL.name((String)"subfolders"))).fetch().getValues(DSL.field((Name)DSL.name((String)"child_folder"))))).or(Tables.FOLDER.ID.eq((Object)folderId)).execute();
        return result;
    }

    private static I_FolderAccess buildFolderAccessHierarchy(Map<UUID, Map<UUID, I_FolderAccess>> fHierarchyMap, UUID currentFolder, I_FolderAccess parentFa, Result<Record> folderSelectedRecordSub, I_DomainAccess domainAccess) {
        if (parentFa != null && parentFa.getSubfoldersList().keySet().contains(currentFolder)) {
            return parentFa.getSubfoldersList().get(currentFolder);
        }
        FolderAccess folderAccess = FolderAccess.buildFolderAccessFromFolderId(currentFolder, domainAccess, folderSelectedRecordSub);
        if (parentFa != null) {
            parentFa.getSubfoldersList().put(currentFolder, folderAccess);
        }
        if (fHierarchyMap.get(currentFolder) != null) {
            for (UUID newChild : fHierarchyMap.get(currentFolder).keySet()) {
                FolderAccess.buildFolderAccessHierarchy(fHierarchyMap, newChild, folderAccess, folderSelectedRecordSub, domainAccess);
            }
        }
        return folderAccess;
    }

    private static FolderAccess buildFolderAccessFromGenericRecord(Record record_, I_DomainAccess domainAccess) {
        Record13 record = (Record13)record_;
        FolderAccess folderAccess = new FolderAccess(domainAccess);
        folderAccess.folderRecord = new FolderRecord();
        folderAccess.setFolderId((UUID)record.value1());
        folderAccess.setInContribution((UUID)record.value7());
        folderAccess.setFolderName((String)record.value8());
        folderAccess.setFolderNArchetypeNodeId((String)record.value9());
        folderAccess.setIsFolderActive((Boolean)record.value10());
        folderAccess.setFolderDetails((ItemStructure)new OtherDetailsJsonbBinder().converter().from((Object)((JSONB)record.value11())));
        folderAccess.setFolderSysTransaction((Timestamp)record.value12());
        folderAccess.setFolderSysPeriod((AbstractMap.SimpleEntry)new SysPeriodBinder().converter().from(record.value13()));
        folderAccess.getItems().addAll(FolderAccess.retrieveItemsByFolderAndContributionId((UUID)record.value1(), (UUID)record.value7(), domainAccess));
        return folderAccess;
    }

    private static FolderAccess buildFolderAccessFromFolderRecord(FolderRecord record_, I_DomainAccess domainAccess) {
        FolderRecord record = record_;
        FolderAccess folderAccess = new FolderAccess(domainAccess);
        folderAccess.folderRecord = new FolderRecord();
        folderAccess.setFolderId(record.getId());
        folderAccess.setInContribution(record.getInContribution());
        folderAccess.setFolderName(record.getName());
        folderAccess.setFolderNArchetypeNodeId(record.getArchetypeNodeId());
        folderAccess.setIsFolderActive(record.getActive());
        folderAccess.setFolderDetails(record.getDetails());
        folderAccess.setFolderSysTransaction(record.getSysTransaction());
        folderAccess.setFolderSysPeriod(record.getSysPeriod());
        folderAccess.getItems().addAll(FolderAccess.retrieveItemsByFolderAndContributionId(record.getId(), record.getInContribution(), domainAccess));
        return folderAccess;
    }

    private static FolderAccess buildFolderAccessFromFolderId(UUID id, I_DomainAccess domainAccess, Result<Record> folderSelectedRecordSub) {
        for (Record record : folderSelectedRecordSub) {
            if (!record.getValue("parent_folder").equals(id)) continue;
            return FolderAccess.buildFolderAccessFromGenericRecord(record, domainAccess);
        }
        FolderRecord folderSelectedRecord = (FolderRecord)domainAccess.getContext().selectFrom((Table)Tables.FOLDER).where(Tables.FOLDER.ID.eq((Object)id)).fetchOne();
        if (folderSelectedRecord == null || folderSelectedRecord.size() < 1) {
            throw new ObjectNotFoundException("folder", "Folder with id " + id + " could not be found");
        }
        return FolderAccess.buildFolderAccessFromFolderRecord(folderSelectedRecord, domainAccess);
    }

    public static I_FolderAccess buildPlainFolderAccess(I_DomainAccess domainAccess, com.nedap.archie.rm.directory.Folder folder, DateTime dateTime, UUID ehrId, I_ContributionAccess contributionAccess) {
        FolderAccess folderAccessInstance = new FolderAccess(domainAccess, ehrId, contributionAccess);
        folderAccessInstance.setEhrId(ehrId);
        if (folder.getUid() != null) {
            folderAccessInstance.setFolderId(UUID.fromString(folder.getUid().getValue()));
        }
        folderAccessInstance.setInContribution(folderAccessInstance.getContributionAccess().getId());
        folderAccessInstance.setFolderName(folder.getName().getValue());
        folderAccessInstance.setFolderNArchetypeNodeId(folder.getArchetypeNodeId());
        folderAccessInstance.setIsFolderActive(true);
        if (folder.getDetails() != null) {
            folderAccessInstance.setFolderDetails(folder.getDetails());
        }
        if (folder.getItems() != null && !folder.getItems().isEmpty()) {
            folderAccessInstance.getItems().addAll(folder.getItems());
        }
        folderAccessInstance.setFolderSysTransaction(new Timestamp(DateTime.now().getMillis()));
        return folderAccessInstance;
    }

    private static List<ObjectRef> retrieveItemsByFolderAndContributionId(UUID folderId, UUID in_contribution, I_DomainAccess domainAccess) {
        Result retrievedRecords = domainAccess.getContext().with("folderItemsSelect").as((Select)DSL.select((SelectField)Tables.FOLDER_ITEMS.OBJECT_REF_ID.as("object_ref_id"), (SelectField)Tables.FOLDER_ITEMS.IN_CONTRIBUTION.as("item_in_contribution")).from((TableLike)Tables.FOLDER_ITEMS).where(Tables.FOLDER_ITEMS.FOLDER_ID.eq((Object)folderId))).select(new SelectFieldOrAsterisk[0]).from(new TableLike[]{Tables.OBJECT_REF, DSL.table((Name)DSL.name((String)"folderItemsSelect"))}).where(DSL.field((Name)DSL.name((String)"object_ref_id"), (Class)Tables.FOLDER_ITEMS.OBJECT_REF_ID.getType()).eq((Field)Tables.OBJECT_REF.ID).and(DSL.field((Name)DSL.name((String)"item_in_contribution"), (Class)Tables.FOLDER_ITEMS.IN_CONTRIBUTION.getType()).eq((Field)Tables.OBJECT_REF.IN_CONTRIBUTION))).fetch();
        ArrayList<ObjectRef> result = new ArrayList<ObjectRef>();
        for (Record recordRecord : retrievedRecords) {
            Record8 recordParam = (Record8)recordRecord;
            ObjectRefRecord objectRef = new ObjectRefRecord();
            objectRef.setIdNamespace((String)recordParam.value1());
            objectRef.setType((String)recordParam.value2());
            objectRef.setId((UUID)recordParam.value3());
            objectRef.setInContribution((UUID)recordParam.value4());
            objectRef.setSysTransaction((Timestamp)recordParam.value5());
            objectRef.setSysPeriod((AbstractMap.SimpleEntry)new SysPeriodBinder().converter().from(recordParam.value6()));
            objectRef.setId((UUID)recordParam.value7());
            result.add(FolderAccess.parseObjectRefRecordIntoObjectRef(objectRef, domainAccess));
        }
        return result;
    }

    private static ObjectRef parseObjectRefRecordIntoObjectRef(ObjectRefRecord objectRefRecord, I_DomainAccess domainAccess) {
        ObjectRef result = new ObjectRef();
        ObjectRefId oref = new FolderAccess(domainAccess).new ObjectRefId(objectRefRecord.getId().toString());
        result.setId((ObjectId)new ObjectVersionId(oref.getValue()));
        result.setType(objectRefRecord.getType());
        result.setNamespace(objectRefRecord.getIdNamespace());
        return result;
    }

    private static I_FolderAccess buildFolderAccessTreeRecursively(I_DomainAccess domainAccess, com.nedap.archie.rm.directory.Folder current, FolderAccess parent, DateTime dateTime, UUID ehrId, I_ContributionAccess contributionAccess) {
        I_FolderAccess folderAccess = null;
        if (parent != null && parent.getSubfoldersList().containsKey(UUID.fromString(current.getUid().getValue()))) {
            return parent.getSubfoldersList().get(current.getUid());
        }
        folderAccess = FolderAccess.buildPlainFolderAccess(domainAccess, current, DateTime.now(), ehrId, contributionAccess);
        if (parent != null) {
            parent.getSubfoldersList().put(((FolderAccess)folderAccess).getFolderRecord().getId(), folderAccess);
        }
        for (com.nedap.archie.rm.directory.Folder child : current.getFolders()) {
            FolderAccess.buildFolderAccessTreeRecursively(domainAccess, child, (FolderAccess)folderAccess, dateTime, ehrId, ((FolderAccess)folderAccess).getContributionAccess());
        }
        return folderAccess;
    }

    public static I_FolderAccess buildNewFolderAccessHierarchy(I_DomainAccess domainAccess, com.nedap.archie.rm.directory.Folder folder, DateTime timeStamp, UUID ehrId, I_ContributionAccess contributionAccess) {
        I_FolderAccess folderAccess = FolderAccess.buildPlainFolderAccess(domainAccess, folder, timeStamp, ehrId, contributionAccess);
        if (folder.getFolders() != null && !folder.getFolders().isEmpty()) {
            folder.getFolders().forEach(child -> {
                I_FolderAccess childFolderAccess = FolderAccess.buildNewFolderAccessHierarchy(domainAccess, child, timeStamp, ehrId, contributionAccess);
                folderAccess.getSubfoldersList().put(UUID.randomUUID(), childFolderAccess);
            });
        }
        return folderAccess;
    }

    private final FolderHierarchyRecord buildFolderHierarchyRecord(UUID parentFolder, UUID childFolder, UUID inContribution, Timestamp sysTransaction, Timestamp sysPeriod) {
        FolderHierarchyRecord fhRecord = (FolderHierarchyRecord)this.getContext().newRecord((Table)FolderHierarchy.FOLDER_HIERARCHY);
        fhRecord.setParentFolder(parentFolder);
        fhRecord.setChildFolder(childFolder);
        fhRecord.setInContribution(inContribution);
        fhRecord.setSysTransaction(sysTransaction);
        return fhRecord;
    }

    public static Integer getLastVersionNumber(I_DomainAccess domainAccess, UUID folderId) {
        if (!FolderAccess.hasPreviousVersion(domainAccess, folderId)) {
            return 1;
        }
        int versionCount = domainAccess.getContext().fetchCount((Table)Tables.FOLDER_HISTORY, Tables.FOLDER_HISTORY.ID.eq((Object)folderId));
        return versionCount + 1;
    }

    public static boolean hasPreviousVersion(I_DomainAccess domainAccess, UUID folderId) {
        return domainAccess.getContext().fetchExists((Table)Tables.FOLDER_HISTORY, Tables.FOLDER_HISTORY.ID.eq((Object)folderId));
    }

    public UUID getEhrId() {
        return this.ehrId;
    }

    public void setEhrId(UUID ehrId) {
        this.ehrId = ehrId;
    }

    public I_ContributionAccess getContributionAccess() {
        return this.contributionAccess;
    }

    public void setContributionAccess(I_ContributionAccess contributionAccess) {
        this.contributionAccess = contributionAccess;
    }

    FolderRecord getFolderRecord() {
        return this.folderRecord;
    }

    public void setSubfoldersList(Map<UUID, I_FolderAccess> subfolders) {
        this.subfoldersList = subfolders;
    }

    @Override
    public Map<UUID, I_FolderAccess> getSubfoldersList() {
        return this.subfoldersList;
    }

    @Override
    public void setDetails(ItemStructure details) {
        this.details = details;
    }

    @Override
    public ItemStructure getDetails() {
        return null;
    }

    @Override
    public List<ObjectRef> getItems() {
        return this.items;
    }

    @Override
    public UUID getFolderId() {
        return this.folderRecord.getId();
    }

    @Override
    public void setFolderId(UUID folderId) {
        this.folderRecord.setId(folderId);
    }

    @Override
    public UUID getInContribution() {
        return this.folderRecord.getInContribution();
    }

    @Override
    public void setInContribution(UUID inContribution) {
        this.folderRecord.setInContribution(inContribution);
    }

    @Override
    public String getFolderName() {
        return this.folderRecord.getName();
    }

    @Override
    public void setFolderName(String folderName) {
        this.folderRecord.setName(folderName);
    }

    @Override
    public String getFolderArchetypeNodeId() {
        return this.folderRecord.getArchetypeNodeId();
    }

    @Override
    public void setFolderNArchetypeNodeId(String folderArchetypeNodeId) {
        this.folderRecord.setArchetypeNodeId(folderArchetypeNodeId);
    }

    @Override
    public boolean isFolderActive() {
        return this.folderRecord.getActive();
    }

    @Override
    public void setIsFolderActive(boolean folderActive) {
        this.folderRecord.setActive(Boolean.valueOf(folderActive));
    }

    @Override
    public ItemStructure getFolderDetails() {
        return this.folderRecord.getDetails();
    }

    @Override
    public void setFolderDetails(ItemStructure folderDetails) {
        this.folderRecord.setDetails(folderDetails);
    }

    @Override
    public void setFolderSysTransaction(Timestamp folderSysTransaction) {
        this.folderRecord.setSysTransaction(folderSysTransaction);
    }

    @Override
    public Timestamp getFolderSysTransaction() {
        return this.folderRecord.getSysTransaction();
    }

    @Override
    public AbstractMap.SimpleEntry<OffsetDateTime, OffsetDateTime> getFolderSysPeriod() {
        return this.folderRecord.getSysPeriod();
    }

    @Override
    public void setFolderSysPeriod(AbstractMap.SimpleEntry<OffsetDateTime, OffsetDateTime> folderSysPeriod) {
        this.folderRecord.setSysPeriod(folderSysPeriod);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public int compareTo(FolderAccess o) {
        return o.getFolderRecord().getId().compareTo(this.folderRecord.getId());
    }

    private class ObjectRefId
    extends ObjectId {
        public ObjectRefId(String value) {
            super(value);
        }
    }
}

