/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.jooq.rmdatavalue.JooqDvCodedText;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.PartyType;
import org.ehrbase.jooq.pg.tables.records.IdentifierRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Result;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;

public class PartyIdentifiedAccess
extends DataAccess
implements I_PartyIdentifiedAccess {
    private static Logger log = LogManager.getLogger(PartyIdentifiedAccess.class);
    private PartyIdentifiedRecord partyIdentifiedRecord;
    private Map<String, IdentifierRecord> identifiers;

    public PartyIdentifiedAccess(DSLContext context, ServerConfig serverConfig, String partyName) {
        super(context, null, null, serverConfig);
        this.partyIdentifiedRecord = (PartyIdentifiedRecord)context.newRecord((Table)Tables.PARTY_IDENTIFIED);
        this.partyIdentifiedRecord.setName(partyName);
    }

    private PartyIdentifiedAccess(DSLContext context, ServerConfig serverConfig) {
        super(context, null, null, serverConfig);
    }

    public static I_PartyIdentifiedAccess retrieveInstance(I_DomainAccess domainAccess, UUID id) {
        DSLContext context = domainAccess.getContext();
        PartyIdentifiedRecord record = (PartyIdentifiedRecord)context.fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)id));
        if (record == null) {
            return null;
        }
        PartyIdentifiedAccess partyIdentifiedAccess = new PartyIdentifiedAccess(context, domainAccess.getServerConfig());
        partyIdentifiedAccess.partyIdentifiedRecord = record;
        Result identifierRecords = context.fetch((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.PARTY.eq((Object)partyIdentifiedAccess.partyIdentifiedRecord.getId()));
        for (IdentifierRecord identifierRecord : identifierRecords) {
            if (partyIdentifiedAccess.identifiers == null) {
                partyIdentifiedAccess.identifiers = new HashMap<String, IdentifierRecord>();
            }
            partyIdentifiedAccess.identifiers.put(PartyIdentifiedAccess.makeMapKey(identifierRecord.getIdValue(), identifierRecord.getIssuer()), identifierRecord);
        }
        return partyIdentifiedAccess;
    }

    public static UUID retrievePartyIdByPartyName(I_DomainAccess domainAccess, String partyName) {
        if (domainAccess.getContext().fetchExists((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.NAME.eq((Object)partyName))) {
            UUID uuid = ((PartyIdentifiedRecord)domainAccess.getContext().fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.NAME.eq((Object)partyName))).getId();
            return uuid;
        }
        return null;
    }

    private static String makeMapKey(String s1, String s2) {
        return s1 + ":" + s2;
    }

    public static UUID getOrCreateParty(I_DomainAccess domainAccess, String name, String idCode, String issuer, String assigner, String typeName) {
        DSLContext context1 = domainAccess.getContext();
        if (context1.fetchExists((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.ID_VALUE.eq((Object)idCode).and(Tables.IDENTIFIER.ISSUER.eq((Object)issuer)))) {
            return ((IdentifierRecord)context1.fetchOne((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.ID_VALUE.eq((Object)idCode).and(Tables.IDENTIFIER.ISSUER.eq((Object)issuer)))).getParty();
        }
        if (context1.fetchExists((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.NAME.eq((Object)name))) {
            UUID partyIdentifiedUuid = ((PartyIdentifiedRecord)context1.fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.NAME.eq((Object)name))).getId();
            if (idCode != null && issuer != null) {
                context1.insertInto((Table)Tables.IDENTIFIER, (Field)Tables.IDENTIFIER.PARTY, (Field)Tables.IDENTIFIER.ID_VALUE, (Field)Tables.IDENTIFIER.ISSUER, (Field)Tables.IDENTIFIER.ASSIGNER, (Field)Tables.IDENTIFIER.TYPE_NAME).values((Object)partyIdentifiedUuid, (Object)idCode, (Object)issuer, (Object)assigner, (Object)typeName).execute();
            }
            return partyIdentifiedUuid;
        }
        UUID partyIdentifiedUuid = ((PartyIdentifiedRecord)context1.insertInto((Table)Tables.PARTY_IDENTIFIED, (Field)Tables.PARTY_IDENTIFIED.NAME).values((Object)name).returning(new SelectFieldOrAsterisk[]{Tables.PARTY_IDENTIFIED.ID}).fetchOne()).getId();
        if (idCode != null && issuer != null) {
            context1.insertInto((Table)Tables.IDENTIFIER, (Field)Tables.IDENTIFIER.PARTY, (Field)Tables.IDENTIFIER.ID_VALUE, (Field)Tables.IDENTIFIER.ISSUER, (Field)Tables.IDENTIFIER.ASSIGNER, (Field)Tables.IDENTIFIER.TYPE_NAME).values((Object)partyIdentifiedUuid, (Object)idCode, (Object)issuer, (Object)assigner, (Object)typeName).execute();
        }
        return partyIdentifiedUuid;
    }

    public static UUID findIdentifiedParty(DSLContext context, List<DvIdentifier> identifierList) {
        if (identifierList == null) {
            return null;
        }
        for (DvIdentifier identifier : identifierList) {
            if (!context.fetchExists((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.ID_VALUE.eq((Object)identifier.getId()).and(Tables.IDENTIFIER.ISSUER.eq((Object)identifier.getIssuer())))) continue;
            return ((IdentifierRecord)context.fetchOne((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.ID_VALUE.eq((Object)identifier.getId()).and(Tables.IDENTIFIER.ISSUER.eq((Object)identifier.getIssuer())))).getParty();
        }
        return null;
    }

    public static UUID findReferencedParty(DSLContext context, PartyRef partyRef) {
        if (partyRef == null) {
            return null;
        }
        ObjectId ref = partyRef.getId();
        if (ref instanceof GenericId) {
            GenericId genericID = (GenericId)ref;
            if (context.fetchExists((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.eq((Object)partyRef.getNamespace()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.eq((Object)genericID.getValue())))) {
                return ((PartyIdentifiedRecord)context.fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.eq((Object)partyRef.getNamespace()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.eq((Object)genericID.getValue())))).getId();
            }
        }
        return null;
    }

    public static UUID findPartySelf(DSLContext context) {
        if (context.fetchExists((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_TYPE.eq((Object)PartyType.party_self))) {
            return ((PartyIdentifiedRecord)context.fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_TYPE.eq((Object)PartyType.party_self))).getId();
        }
        return null;
    }

    public static UUID getOrCreateParty(I_DomainAccess domainAccess, PartyIdentified partyIdentified) {
        DSLContext context1 = domainAccess.getContext();
        UUID identifiedParty = null;
        PartyRef externalRef = partyIdentified.getExternalRef();
        List identifierList = partyIdentified.getIdentifiers();
        GenericId genericID = null;
        if (externalRef != null) {
            ObjectId ref = externalRef.getId();
            if (ref instanceof GenericId) {
                genericID = (GenericId)ref;
            } else if (ref instanceof HierObjectId) {
                genericID = null;
            } else {
                log.warn("Passed partyIdentified does not contain a GenericID in external ref:" + partyIdentified.toString());
            }
        }
        if (externalRef != null) {
            identifiedParty = PartyIdentifiedAccess.findReferencedParty(domainAccess.getContext(), externalRef);
        } else if (identifierList != null && !identifierList.isEmpty()) {
            identifiedParty = PartyIdentifiedAccess.findIdentifiedParty(domainAccess.getContext(), (List<DvIdentifier>)identifierList);
        }
        if (identifiedParty != null) {
            return identifiedParty;
        }
        UUID partyIdentifiedUuid = ((PartyIdentifiedRecord)context1.insertInto((Table)Tables.PARTY_IDENTIFIED, (Field)Tables.PARTY_IDENTIFIED.NAME, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_TYPE).values((Object)partyIdentified.getName(), (Object)(externalRef != null ? externalRef.getNamespace() : null), (Object)(genericID != null ? genericID.getValue() : null), (Object)(genericID != null ? genericID.getScheme() : null), (Object)(externalRef != null ? externalRef.getType() : null)).returning(new SelectFieldOrAsterisk[]{Tables.PARTY_IDENTIFIED.ID}).fetchOne()).getId();
        if (identifierList != null) {
            for (DvIdentifier identifier : identifierList) {
                if (identifier.getId() == null || identifier.getIssuer() == null) continue;
                context1.insertInto((Table)Tables.IDENTIFIER, (Field)Tables.IDENTIFIER.PARTY, (Field)Tables.IDENTIFIER.ID_VALUE, (Field)Tables.IDENTIFIER.ISSUER, (Field)Tables.IDENTIFIER.ASSIGNER, (Field)Tables.IDENTIFIER.TYPE_NAME).values((Object)partyIdentifiedUuid, (Object)identifier.getId(), (Object)identifier.getIssuer(), (Object)identifier.getAssigner(), (Object)identifier.getType()).execute();
            }
        }
        return partyIdentifiedUuid;
    }

    public static UUID getOrCreatePartySelf(I_DomainAccess domainAccess) {
        DSLContext context1 = domainAccess.getContext();
        UUID partySelf = PartyIdentifiedAccess.findPartySelf(domainAccess.getContext());
        if (partySelf != null) {
            return partySelf;
        }
        UUID partySelfUuid = ((PartyIdentifiedRecord)context1.insertInto((Table)Tables.PARTY_IDENTIFIED, (Field)Tables.PARTY_IDENTIFIED.PARTY_TYPE).values((Object)PartyType.party_self).returning(new SelectFieldOrAsterisk[]{Tables.PARTY_IDENTIFIED.ID}).fetchOne()).getId();
        return partySelfUuid;
    }

    public static PartyProxy retrievePartyProxy(I_DomainAccess domainAccess, UUID id) {
        PartySelf partyProxy;
        if (!domainAccess.getContext().fetchExists((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)id))) {
            partyProxy = null;
        } else {
            PartyIdentifiedRecord identifiedRecord = (PartyIdentifiedRecord)domainAccess.getContext().fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)id));
            if (identifiedRecord.getPartyType().equals((Object)PartyType.party_self)) {
                partyProxy = new PartySelf();
            } else if (identifiedRecord.getPartyType().equals((Object)PartyType.party_identified)) {
                partyProxy = PartyIdentifiedAccess.retrievePartyIdentified(domainAccess, id, identifiedRecord);
            } else if (identifiedRecord.getPartyType().equals((Object)PartyType.party_related)) {
                partyProxy = PartyIdentifiedAccess.retrievePartyRelated(domainAccess, id, identifiedRecord);
            } else {
                throw new InternalServerException("Inconsistent Party type detected:" + identifiedRecord.getPartyRefType());
            }
        }
        return partyProxy;
    }

    private static PartyIdentified retrievePartyIdentified(I_DomainAccess domainAccess, UUID id, PartyIdentifiedRecord identifiedRecord) {
        PartyRef partyRef = null;
        ArrayList identifierList = new ArrayList();
        domainAccess.getContext().fetch((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.PARTY.eq((Object)id)).forEach(record -> {
            DvIdentifier identifier = new DvIdentifier();
            identifier.setIssuer(record.getIssuer());
            identifier.setAssigner(record.getAssigner());
            identifier.setId(record.getIdValue());
            identifier.setType(record.getTypeName());
            identifierList.add(identifier);
        });
        if (identifiedRecord.getPartyRefType() != null) {
            if (identifiedRecord.getPartyRefValue() != null && identifiedRecord.getPartyRefScheme() != null) {
                GenericId genericID = new GenericId(identifiedRecord.getPartyRefValue(), identifiedRecord.getPartyRefScheme());
                partyRef = new PartyRef((ObjectId)genericID, identifiedRecord.getPartyRefNamespace(), identifiedRecord.getPartyRefType());
            } else {
                HierObjectId objectID = new HierObjectId("ref");
                partyRef = new PartyRef((ObjectId)objectID, identifiedRecord.getPartyRefNamespace(), identifiedRecord.getPartyRefType());
            }
        }
        PartyIdentified partyIdentified = new PartyIdentified(partyRef, identifiedRecord.getName(), identifierList.isEmpty() ? null : identifierList);
        return partyIdentified;
    }

    private static PartyProxy retrievePartyRelated(I_DomainAccess domainAccess, UUID id, PartyIdentifiedRecord identifiedRecord) {
        PartyIdentified partyIdentified = PartyIdentifiedAccess.retrievePartyIdentified(domainAccess, id, identifiedRecord);
        PartyRelated partyRelated = new PartyRelated();
        partyRelated.setExternalRef(partyIdentified.getExternalRef());
        partyRelated.setName(partyIdentified.getName());
        partyRelated.setIdentifiers(partyIdentified.getIdentifiers());
        partyRelated.setRelationship(new JooqDvCodedText(identifiedRecord.getRelationship()).toRmInstance());
        return partyRelated;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.partyIdentifiedRecord.store();
        if (this.identifiers != null) {
            for (IdentifierRecord identifierRecord : this.identifiers.values()) {
                identifierRecord.setParty(this.partyIdentifiedRecord.getId());
                this.getContext().insertInto((Table)Tables.IDENTIFIER, (Field)Tables.IDENTIFIER.PARTY, (Field)Tables.IDENTIFIER.ID_VALUE, (Field)Tables.IDENTIFIER.ISSUER, (Field)Tables.IDENTIFIER.ASSIGNER, (Field)Tables.IDENTIFIER.TYPE_NAME).values((Object)identifierRecord.getParty(), (Object)identifierRecord.getIdValue(), (Object)identifierRecord.getIssuer(), (Object)identifierRecord.getAssigner(), (Object)identifierRecord.getTypeName()).execute();
                log.debug("Create identifier for party:" + identifierRecord.getParty());
            }
        }
        log.debug("created party:" + this.partyIdentifiedRecord.getId());
        return this.partyIdentifiedRecord.getId();
    }

    @Override
    public UUID commit() {
        return this.commit(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        int count = 0;
        if (this.partyIdentifiedRecord.changed()) {
            count += this.partyIdentifiedRecord.update();
        }
        for (IdentifierRecord identifierRecord : this.identifiers.values()) {
            if (this.getContext().fetchExists((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.ID_VALUE.eq((Object)identifierRecord.getIdValue()).and(Tables.IDENTIFIER.ISSUER.eq((Object)identifierRecord.getIssuer())))) {
                count += this.getContext().update((Table)Tables.IDENTIFIER).set((Field)Tables.IDENTIFIER.ID_VALUE, (Object)identifierRecord.getIdValue()).set((Field)Tables.IDENTIFIER.ASSIGNER, (Object)identifierRecord.getAssigner()).set((Field)Tables.IDENTIFIER.ISSUER, (Object)identifierRecord.getIssuer()).where(Tables.IDENTIFIER.ID_VALUE.eq((Object)identifierRecord.getIdValue()).and(Tables.IDENTIFIER.ISSUER.eq((Object)identifierRecord.getIssuer()))).execute();
                continue;
            }
            count += this.getContext().insertInto((Table)Tables.IDENTIFIER, (Field)Tables.IDENTIFIER.PARTY, (Field)Tables.IDENTIFIER.ID_VALUE, (Field)Tables.IDENTIFIER.ISSUER, (Field)Tables.IDENTIFIER.ASSIGNER, (Field)Tables.IDENTIFIER.TYPE_NAME).values((Object)this.partyIdentifiedRecord.getId(), (Object)identifierRecord.getIdValue(), (Object)identifierRecord.getIssuer(), (Object)identifierRecord.getAssigner(), (Object)identifierRecord.getTypeName()).execute();
        }
        return count > 0;
    }

    @Override
    @Deprecated
    public Boolean update(Timestamp transactionTime, boolean force) {
        throw new InternalServerException("INTERNAL: Invalid update call, this signature is not supported in PartyIdentifiedAccess");
    }

    @Override
    public Boolean update() {
        return this.update(Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    @Deprecated
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: Invalid update call, this signature is not supported in PartyIdentifiedAccess");
    }

    @Override
    public Integer delete() {
        int count = 0;
        if (this.identifiers != null) {
            for (IdentifierRecord identifierRecord : this.identifiers.values()) {
                count += this.getContext().delete((Table)Tables.IDENTIFIER).where(Tables.IDENTIFIER.PARTY.eq((Object)this.partyIdentifiedRecord.getId())).execute();
            }
        }
        return count += this.partyIdentifiedRecord.delete();
    }

    @Override
    public Integer addIdentifier(String value, String issuer, String assigner, String type) {
        IdentifierRecord identifierRecord = (IdentifierRecord)this.getContext().newRecord((Table)Tables.IDENTIFIER);
        identifierRecord.setIdValue(value);
        identifierRecord.setIssuer(issuer);
        identifierRecord.setAssigner(assigner);
        identifierRecord.setTypeName(type);
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, IdentifierRecord>();
        }
        this.identifiers.put(PartyIdentifiedAccess.makeMapKey(value, issuer), identifierRecord);
        return this.identifiers.size();
    }

    @Override
    public Integer deleteIdentifier(String idCode, String issuer) {
        String key = PartyIdentifiedAccess.makeMapKey(idCode, issuer);
        this.identifiers.remove(key);
        return this.getContext().delete((Table)Tables.IDENTIFIER).where(Tables.IDENTIFIER.PARTY.eq((Object)this.partyIdentifiedRecord.getId()).and(Tables.IDENTIFIER.ID_VALUE.eq((Object)idCode)).and(Tables.IDENTIFIER.ISSUER.eq((Object)issuer))).execute();
    }

    @Override
    public String getPartyName() {
        return this.partyIdentifiedRecord.getName();
    }

    @Override
    public void setPartyName(String name) {
        this.partyIdentifiedRecord.setName(name);
    }

    @Override
    public String getPartyRefValue() {
        return this.partyIdentifiedRecord.getPartyRefValue();
    }

    @Override
    public String getPartyRefNamespace() {
        return this.partyIdentifiedRecord.getPartyRefNamespace();
    }

    @Override
    public String[] getIdentifiersKeySet() {
        return this.identifiers.keySet().toArray(new String[this.identifiers.size()]);
    }

    @Override
    public UUID getId() {
        return this.partyIdentifiedRecord.getId();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

