/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datastructures.ItemStructure;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_StatusAccess;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.StatusRecord;
import org.jooq.DSLContext;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;

public class StatusAccess
extends DataAccess
implements I_StatusAccess {
    private static final Logger log = LogManager.getLogger(StatusAccess.class);
    private StatusRecord statusRecord = (StatusRecord)this.getContext().newRecord((Table)Tables.STATUS);
    private I_ContributionAccess contributionAccess;
    private I_AuditDetailsAccess auditDetailsAccess;

    public StatusAccess(I_DomainAccess domainAccess, UUID ehrId) {
        super(domainAccess);
        this.contributionAccess = I_ContributionAccess.getInstance(this, ehrId);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.auditDetailsAccess = I_AuditDetailsAccess.getInstance(this.getDataAccess());
    }

    public static I_StatusAccess retrieveInstance(I_DomainAccess domainAccess, UUID statusId) {
        StatusRecord record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.ID.eq((Object)statusId));
        if (record == null) {
            return null;
        }
        return StatusAccess.createStatusAccessForRetrieval(domainAccess, record);
    }

    public static I_StatusAccess retrieveInstanceByNamedSubject(I_DomainAccess domainAccess, String partyName) {
        DSLContext context = domainAccess.getContext();
        StatusRecord record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.NAME.eq((Object)partyName))));
        if (record == null) {
            return null;
        }
        return StatusAccess.createStatusAccessForRetrieval(domainAccess, record);
    }

    public static I_StatusAccess retrieveInstanceByParty(I_DomainAccess domainAccess, UUID partyIdentified) {
        DSLContext context = domainAccess.getContext();
        StatusRecord record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)partyIdentified))));
        if (record == null) {
            return null;
        }
        return StatusAccess.createStatusAccessForRetrieval(domainAccess, record);
    }

    public static I_StatusAccess retrieveInstanceByEhrId(I_DomainAccess domainAccess, UUID ehrId) {
        StatusRecord record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.EHR_ID.eq((Object)ehrId));
        if (record == null) {
            return null;
        }
        return StatusAccess.createStatusAccessForRetrieval(domainAccess, record);
    }

    private static I_StatusAccess createStatusAccessForRetrieval(I_DomainAccess domainAccess, StatusRecord record) {
        StatusAccess statusAccess = new StatusAccess(domainAccess, record.getEhrId());
        statusAccess.setStatusRecord(record);
        I_AuditDetailsAccess auditAccess = new AuditDetailsAccess(domainAccess.getDataAccess()).retrieveInstance(domainAccess.getDataAccess(), statusAccess.getAuditDetailsId());
        statusAccess.setAuditDetailsAccess(auditAccess);
        I_ContributionAccess retContributionAccess = I_ContributionAccess.retrieveInstance(domainAccess, record.getInContribution());
        statusAccess.setContributionAccess(retContributionAccess);
        return statusAccess;
    }

    @Override
    public UUID getId() {
        return this.statusRecord.getId();
    }

    @Override
    @Deprecated
    public UUID commit(Timestamp transactionTime) {
        throw new InternalServerException("INTERNAL: commit is not valid");
    }

    @Override
    @Deprecated
    public UUID commit() {
        throw new InternalServerException("INTERNAL: commit without transaction time is not legal");
    }

    @Override
    public UUID commit(Timestamp transactionTime, UUID ehrId, ItemStructure otherDetails) {
        this.contributionAccess.setAuditDetailsChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
        if (this.contributionAccess.getAuditsCommitter() == null || this.contributionAccess.getAuditsSystemId() == null) {
            throw new InternalServerException("Illegal to commit the contribution's AuditDetailsAccess without setting mandatory fields.");
        }
        UUID contributionId = this.contributionAccess.commit();
        this.setContributionId(contributionId);
        return this.internalCommit(transactionTime, ehrId, otherDetails);
    }

    @Override
    public UUID commitWithCustomContribution(Timestamp transactionTime, UUID ehrId, ItemStructure otherDetails) {
        return this.internalCommit(transactionTime, ehrId, otherDetails);
    }

    private UUID internalCommit(Timestamp transactionTime, UUID ehrId, ItemStructure otherDetails) {
        this.auditDetailsAccess.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
        if (this.auditDetailsAccess.getChangeType() == null || this.auditDetailsAccess.getSystemId() == null || this.auditDetailsAccess.getCommitter() == null) {
            throw new InternalServerException("Illegal to commit AuditDetailsAccess without setting mandatory fields.");
        }
        UUID auditId = this.auditDetailsAccess.commit();
        this.statusRecord.setHasAudit(auditId);
        this.statusRecord.setEhrId(ehrId);
        if (otherDetails != null) {
            this.statusRecord.setOtherDetails(otherDetails);
        }
        this.statusRecord.setSysTransaction(transactionTime);
        this.statusRecord.setHasAudit(auditId);
        if (this.statusRecord.store() == 0) {
            throw new InvalidApiParameterException("Input EHR couldn't be stored; Storing EHR_STATUS failed");
        }
        return this.statusRecord.getId();
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(null, transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        return this.update(null, transactionTime, force);
    }

    @Override
    public Boolean update(Boolean force) {
        return this.update(null, Timestamp.valueOf(LocalDateTime.now()), force);
    }

    @Override
    public Boolean update(ItemStructure otherDetails, Timestamp transactionTime, boolean force) {
        if (force || this.statusRecord.changed()) {
            this.contributionAccess.update(transactionTime, null, null, null, null, I_ConceptAccess.ContributionChangeType.MODIFICATION, null);
            this.statusRecord.setInContribution(this.contributionAccess.getId());
            this.auditDetailsAccess.update(null, null, I_ConceptAccess.ContributionChangeType.MODIFICATION, null);
            this.statusRecord.setHasAudit(this.auditDetailsAccess.getId());
            if (otherDetails != null) {
                this.statusRecord.setOtherDetails(otherDetails);
            }
            this.statusRecord.setSysTransaction(transactionTime);
            try {
                return this.statusRecord.update() > 0;
            }
            catch (RuntimeException e) {
                throw new InvalidApiParameterException("Couldn't marshall given EHR_STATUS / OTHER_DETAILS, content probably breaks RM rules");
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public Boolean update() {
        throw new InternalServerException("INTERNAL: this update signature is not valid");
    }

    @Override
    public Integer delete() {
        return this.statusRecord.delete();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public void setStatusRecord(StatusRecord record) {
        this.statusRecord = record;
    }

    @Override
    public StatusRecord getStatusRecord() {
        return this.statusRecord;
    }

    @Override
    public void setAuditDetailsAccess(I_AuditDetailsAccess auditDetailsAccess) {
        this.auditDetailsAccess = auditDetailsAccess;
    }

    @Override
    public void setContributionAccess(I_ContributionAccess contributionAccess) {
        this.contributionAccess = contributionAccess;
    }

    @Override
    public I_AuditDetailsAccess getAuditDetailsAccess() {
        return this.auditDetailsAccess;
    }

    @Override
    public UUID getAuditDetailsId() {
        return this.statusRecord.getHasAudit();
    }

    @Override
    public void setContributionId(UUID contribution) {
        this.statusRecord.setInContribution(contribution);
    }

    @Override
    public UUID getContributionId() {
        return this.statusRecord.getInContribution();
    }

    @Override
    public void setAuditAndContributionAuditValues(UUID systemId, UUID committerId, String description) {
        if (systemId != null) {
            this.auditDetailsAccess.setSystemId(systemId);
        }
        if (committerId != null) {
            this.auditDetailsAccess.setCommitter(committerId);
        }
        if (description != null) {
            this.auditDetailsAccess.setDescription(description);
        }
        this.contributionAccess.setAuditDetailsValues(committerId, systemId, description);
    }
}

