/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.sql.Timestamp;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.SystemRecord;
import org.joda.time.DateTime;
import org.jooq.Table;

public class SystemAccess
extends DataAccess
implements I_SystemAccess {
    private static final Logger log = LogManager.getLogger(SystemAccess.class);
    private SystemRecord systemRecord;

    public SystemAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public SystemAccess(I_DomainAccess domainAccess, String description, String settings) {
        super(domainAccess);
        this.systemRecord = (SystemRecord)domainAccess.getContext().newRecord((Table)Tables.SYSTEM);
        this.systemRecord.setDescription(description);
        this.systemRecord.setSettings(settings);
    }

    public static UUID createOrRetrieveLocalSystem(I_DomainAccess domainAccess) {
        String settings = domainAccess.getServerConfig().getNodename();
        UUID res = SystemAccess.retrieveInstanceId(domainAccess, settings);
        if (res == null) {
            return new SystemAccess(domainAccess, "DEFAULT RUNNING SYSTEM", settings).commit();
        }
        return res;
    }

    public static UUID createOrRetrieveInstanceId(I_DomainAccess domainAccess, String description, String settings) {
        UUID res = SystemAccess.retrieveInstanceId(domainAccess, settings);
        if (res == null) {
            if (description == null) {
                description = "default";
            }
            return new SystemAccess(domainAccess, description, settings).commit();
        }
        return res;
    }

    public static UUID retrieveInstanceId(I_DomainAccess domainAccess, String settings) {
        UUID uuid;
        try {
            uuid = Optional.ofNullable((SystemRecord)domainAccess.getContext().fetchOne((Table)Tables.SYSTEM, Tables.SYSTEM.SETTINGS.eq((Object)settings))).map(SystemRecord::getId).orElse(null);
            if (uuid == null) {
                return null;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not getNewFolderAccessInstance settings:" + settings + " Exception:" + e);
        }
        return uuid;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.systemRecord.store();
        return this.systemRecord.getId();
    }

    @Override
    public UUID commit() {
        return this.commit(new Timestamp(DateTime.now().getMillis()));
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        if (this.systemRecord.changed()) {
            return this.systemRecord.update() > 0;
        }
        return false;
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        return this.update(transactionTime);
    }

    @Override
    @Deprecated
    public Boolean update() {
        throw new InternalServerException("INTERNAL: this update signature is not valid");
    }

    @Override
    @Deprecated
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: this update signature is not valid");
    }

    @Override
    public Integer delete() {
        return this.systemRecord.delete();
    }

    public static I_SystemAccess retrieveInstance(I_DomainAccess domainAccess, UUID id) {
        SystemAccess systemAccess = new SystemAccess(domainAccess);
        systemAccess.systemRecord = (SystemRecord)domainAccess.getContext().fetchOne((Table)Tables.SYSTEM, Tables.SYSTEM.ID.eq((Object)id));
        return systemAccess;
    }

    @Override
    public UUID getId() {
        return this.systemRecord.getId();
    }

    @Override
    public String getSettings() {
        return this.systemRecord.getSettings();
    }

    @Override
    public String getDescription() {
        return this.systemRecord.getDescription();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

