/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.util.HashMap;
import java.util.Map;

public enum SystemValue {
    LANGUAGE("language"),
    CHARSET("charset"),
    ENCODING("encoding"),
    TERMINOLOGY_SERVICE("terminologyService"),
    MEASUREMENT_SERVICE("measurementService"),
    SUBJECT("subject"),
    PROVIDER("provider"),
    COMPOSER("composer"),
    TERRITORY("territory"),
    CONTEXT("context"),
    CATEGORY("category"),
    UID("uid");

    private final String id;
    private static final Map<String, SystemValue> idMap;

    private SystemValue(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public static SystemValue fromId(String id) {
        return idMap.get(id);
    }

    static {
        SystemValue[] list = new SystemValue[]{LANGUAGE, CHARSET, TERMINOLOGY_SERVICE, MEASUREMENT_SERVICE, SUBJECT, PROVIDER, COMPOSER, TERRITORY, CONTEXT, CATEGORY, UID};
        idMap = new HashMap<String, SystemValue>();
        for (SystemValue value : list) {
            idMap.put(value.id(), value);
        }
    }
}

