/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.opt.LocatablePath;
import org.ehrbase.opt.NodeChildren;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValueItem;
import org.ehrbase.opt.mapper.Boolean;
import org.ehrbase.opt.mapper.CodePhrase;
import org.ehrbase.opt.mapper.CodedText;
import org.ehrbase.opt.mapper.Constants;
import org.ehrbase.opt.mapper.Count;
import org.ehrbase.opt.mapper.Date;
import org.ehrbase.opt.mapper.DateTime;
import org.ehrbase.opt.mapper.Duration;
import org.ehrbase.opt.mapper.Element;
import org.ehrbase.opt.mapper.EventContextAttributes;
import org.ehrbase.opt.mapper.Interval;
import org.ehrbase.opt.mapper.IsmTransition;
import org.ehrbase.opt.mapper.NodeMap;
import org.ehrbase.opt.mapper.Ordinal;
import org.ehrbase.opt.mapper.Parsable;
import org.ehrbase.opt.mapper.Proportion;
import org.ehrbase.opt.mapper.Quantity;
import org.ehrbase.opt.mapper.Structural;
import org.ehrbase.opt.mapper.Time;
import org.ehrbase.opt.mapper.ValueType;
import org.openehr.schemas.v1.ARCHETYPESLOT;
import org.openehr.schemas.v1.ARCHETYPETERM;
import org.openehr.schemas.v1.CARCHETYPEROOT;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCODEPHRASE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CDOMAINTYPE;
import org.openehr.schemas.v1.CDVORDINAL;
import org.openehr.schemas.v1.CDVQUANTITY;
import org.openehr.schemas.v1.CMULTIPLEATTRIBUTE;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CPRIMITIVE;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.RESOURCEDESCRIPTIONITEM;
import org.openehr.schemas.v1.StringDictionaryItem;

public class OptVisitor {
    Logger log = LogManager.getLogger(OptVisitor.class);
    private Map<String, Map<String, TermDefinition>> termTable = new HashMap<String, Map<String, TermDefinition>>();
    private Map<String, List<Map<String, Object>>> childrenNodeMap = new HashMap<String, List<Map<String, Object>>>();

    private Map traversePrimitiveTypeObject(CPRIMITIVEOBJECT cpo) {
        CPRIMITIVE cp = cpo.getItem();
        return null;
    }

    private Map traverseDomainTypeObject(CDOMAINTYPE cpo, Map<String, TermDefinition> termDef, String path) throws Exception {
        String name = new LocatablePath(path).attribute();
        if (cpo instanceof CDVQUANTITY) {
            return new Quantity((CDVQUANTITY)cpo, termDef).toMap(name);
        }
        if (cpo instanceof CCODEPHRASE) {
            return new CodePhrase((CCODEPHRASE)cpo, termDef).toMap(name);
        }
        if (cpo instanceof CDVORDINAL) {
            return new Ordinal((CDVORDINAL)cpo, termDef).toMap(name);
        }
        throw new RuntimeException("unsupported c_domain_type: " + cpo.getClass());
    }

    public Map traverse(OPERATIONALTEMPLATE opt) throws Exception {
        CARCHETYPEROOT def = opt.getDefinition();
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("template_id", opt.getTemplateId().getValue());
        rootMap.put("default_language", opt.getLanguage().getCodeString());
        ArrayList<String> languages = new ArrayList<String>();
        for (RESOURCEDESCRIPTIONITEM resourcedescriptionitem : opt.getDescription().getDetailsArray()) {
            if (resourcedescriptionitem.getLanguage() == null) continue;
            languages.add(resourcedescriptionitem.getLanguage().getCodeString());
        }
        if (languages.size() > 0) {
            rootMap.put("languages", languages);
        }
        rootMap.put("uid", opt.getUid().getValue());
        rootMap.put("concept", opt.getConcept());
        Map map = this.handleArchetypeRoot(opt, def, null, "");
        rootMap.put("tree", map);
        return rootMap;
    }

    private Map handleArchetypeRoot(OPERATIONALTEMPLATE opt, CARCHETYPEROOT def, String name, String path) throws Exception {
        HashMap archetypeRootMap = new HashMap();
        HashMap<String, TermDefinition> termDef = new HashMap<String, TermDefinition>();
        for (ARCHETYPETERM term : def.getTermDefinitionsArray()) {
            String code = term.getCode();
            String value = null;
            String description = null;
            for (StringDictionaryItem item : term.getItemsArray()) {
                if ("text".equals(item.getId())) {
                    value = item.getStringValue();
                }
                if (!"description".equals(item.getId())) continue;
                description = item.getStringValue();
            }
            termDef.put(code, new TermDefinition(code, value, description));
        }
        this.log.debug("CARCHETYPEROOT path=" + path);
        this.termTable.put(path, termDef);
        return this.handleComplexObject(opt, (CCOMPLEXOBJECT)def, termDef, name, path);
    }

    private Map handleComplexObject(OPERATIONALTEMPLATE opt, CCOMPLEXOBJECT ccobj, Map<String, TermDefinition> termDef, String name, String path) throws Exception {
        Object structural;
        int max;
        Map<Object, Object> nodeMap = new HashMap();
        String nodeId = ccobj.getNodeId();
        String rmTypeName = ccobj.getRmTypeName();
        this.log.debug("rmTypeName=" + rmTypeName + ":nodeId=" + nodeId + ":ccobj=" + ccobj);
        String archetypeNodeId = null;
        int min = ccobj.getOccurrences().getLowerUnbounded() ? -1 : ccobj.getOccurrences().getLower();
        int n = max = ccobj.getOccurrences().getUpperUnbounded() ? -1 : ccobj.getOccurrences().getUpper();
        if (nodeId != null && nodeId.trim().length() > 0 && ccobj instanceof CARCHETYPEROOT) {
            this.log.debug("set archetype_node_id=" + ((CARCHETYPEROOT)ccobj).getArchetypeId().getValue());
            archetypeNodeId = ((CARCHETYPEROOT)ccobj).getArchetypeId().getValue();
        }
        CATTRIBUTE[] cattributes = ccobj.getAttributesArray();
        ArrayList<Map<String, Object>> childrenList = new ArrayList<Map<String, Object>>();
        if (cattributes != null && cattributes.length > 0) {
            for (CATTRIBUTE attr : cattributes) {
                Map cobjectMap;
                String pathloop = path + "/" + attr.getRmAttributeName();
                COBJECT[] children = attr.getChildrenArray();
                String attrName = attr.getRmAttributeName();
                if (attr instanceof CSINGLEATTRIBUTE) {
                    if (children == null || children.length <= 0) continue;
                    try {
                        for (COBJECT cobj : children) {
                            cobjectMap = this.handleCObject(opt, cobj, termDef, attrName, pathloop);
                            if (cobjectMap == null) continue;
                            if (cobj.getRmTypeName().equals("ITEM_TREE") && !pathloop.endsWith("]")) {
                                pathloop = pathloop + "[" + cobj.getNodeId() + "]";
                            }
                            cobjectMap.put("aql_path", pathloop);
                            childrenList.add(cobjectMap);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error("Cannot create attribute name " + attrName + " on path " + pathloop, (Throwable)e);
                        continue;
                    }
                }
                if (!(attr instanceof CMULTIPLEATTRIBUTE)) continue;
                for (COBJECT cobj : children) {
                    try {
                        cobjectMap = this.handleCObject(opt, cobj, termDef, attrName, pathloop);
                    }
                    catch (Exception e) {
                        this.log.error("Cannot create attribute name " + attrName + " on path " + pathloop, (Throwable)e);
                    }
                }
                this.log.debug("valueMap.put " + attr.getRmAttributeName());
            }
        } else {
            this.log.debug("leaf..");
        }
        if ("DV_TEXT".equals(rmTypeName)) {
            nodeMap = new ValueType(ccobj, termDef).toMap(rmTypeName, name);
        } else if ("DV_CODED_TEXT".equals(rmTypeName)) {
            nodeMap = new CodedText(ccobj, termDef).toMap(name);
        } else if ("DV_URI".equals(rmTypeName) || "DV_EHR_URI".equals(rmTypeName)) {
            nodeMap = new ValueType(ccobj, termDef).toMap(rmTypeName, name);
        } else if (rmTypeName.startsWith("DV_INTERVAL")) {
            nodeMap = new Interval(ccobj, termDef).toMap(name);
        } else if ("DV_DATE_TIME".equals(rmTypeName)) {
            nodeMap = new DateTime(ccobj, termDef).toMap(name);
        } else if ("DV_DATE".equals(rmTypeName)) {
            nodeMap = new Date(ccobj, termDef).toMap(name);
        } else if ("DV_TIME".equals(rmTypeName)) {
            nodeMap = new Time(ccobj, termDef).toMap(name);
        } else if ("DV_PARSABLE".equals(rmTypeName)) {
            nodeMap = new Parsable(ccobj, termDef).toMap(rmTypeName);
        } else if ("DV_MULTIMEDIA".equals(rmTypeName)) {
            nodeMap = new ValueType(ccobj, termDef).toMap(rmTypeName, name);
        } else if ("DV_BOOLEAN".equals(rmTypeName)) {
            nodeMap = new Boolean(ccobj, termDef).toMap(name);
        } else if ("DV_COUNT".equals(rmTypeName)) {
            nodeMap = new Count(ccobj, termDef).toMap(name);
        } else if ("DV_DURATION".equals(rmTypeName)) {
            nodeMap = new Duration(ccobj, termDef).toMap(name);
        } else if ("DV_IDENTIFIER".equals(rmTypeName)) {
            nodeMap = new ValueType(ccobj, termDef).toMap(rmTypeName, name);
        } else if ("DV_PROPORTION".equals(rmTypeName)) {
            nodeMap = new Proportion(ccobj, termDef).toMap(name);
        } else if ("ISM_TRANSITION".equals(rmTypeName)) {
            nodeMap = new IsmTransition(ccobj, termDef).toMap(name);
        } else if (rmTypeName.matches("COMPOSITION|SECTION|CLUSTER|ITEM_TREE|ACTION|INSTRUCTION|ACTIVITY|EVALUATION|OBSERVATION|SECTION|EVENT|HISTORY|EVENT_CONTEXT|ADMIN_ENTRY|POINT_EVENT|INTERVAL_EVENT")) {
            structural = new Structural(rmTypeName, archetypeNodeId, path, nodeId, ccobj, termDef, this.childrenNodeMap);
            nodeMap = ((Structural)structural).toMap();
            if ("COMPOSITION".matches(rmTypeName)) {
                boolean hasContext = false;
                for (Map child : (List)nodeMap.get("children")) {
                    if (!child.containsKey("context")) continue;
                    hasContext = true;
                }
                if (!hasContext) {
                    ((List)nodeMap.get("children")).add(new EventContextAttributes().toMap());
                }
            }
            this.childrenNodeMap = ((Structural)structural).trim();
        } else if ("ELEMENT".equals(rmTypeName)) {
            nodeMap = new Element(ccobj, termDef).toMap(nodeId, path, new NodeChildren(this.childrenNodeMap).include(path));
            if (!childrenList.isEmpty()) {
                nodeMap.put(Constants.CONSTRAINTS, childrenList);
                structural = new ValueItem(childrenList).path();
            }
            if (childrenList.size() > 1 && this.heterogeneousTypes(childrenList) && this.heterogeneousTypes(childrenList)) {
                nodeMap.put("type", Constants.MULTIPLE);
            }
            this.childrenNodeMap = new NodeChildren(this.childrenNodeMap).exclude(path);
        } else {
            throw new IllegalArgumentException("Could not handle type:" + rmTypeName);
        }
        if (nodeMap != null && nodeMap.size() == 0) {
            nodeMap.putAll(new NodeMap(termDef, nodeId).toMap(min, max, path, archetypeNodeId, rmTypeName));
        }
        if (nodeMap != null) {
            if (this.childrenNodeMap.containsKey(path)) {
                this.childrenNodeMap.get(path).add(nodeMap);
            } else {
                ArrayList<Map<Object, Object>> children = new ArrayList<Map<Object, Object>>();
                children.add(nodeMap);
                this.childrenNodeMap.put(path, children);
            }
        }
        return nodeMap;
    }

    private Map handleCObject(OPERATIONALTEMPLATE opt, COBJECT cobj, Map<String, TermDefinition> termDef, String attrName, String path) throws Exception {
        this.log.debug("cobj=" + cobj.getClass() + ":" + cobj.getRmTypeName());
        String rmTypeName = cobj.getRmTypeName();
        if (cobj instanceof CARCHETYPEROOT) {
            if (!((CARCHETYPEROOT)cobj).getArchetypeId().getValue().isEmpty()) {
                path = (String)path + "[" + ((CARCHETYPEROOT)cobj).getArchetypeId().getValue() + "]";
            }
            this.log.debug("CARCHETYPEROOT path=" + (String)path);
            return this.handleArchetypeRoot(opt, (CARCHETYPEROOT)cobj, attrName, (String)path);
        }
        if (cobj instanceof CDOMAINTYPE) {
            return this.traverseDomainTypeObject((CDOMAINTYPE)cobj, termDef, (String)path);
        }
        if (cobj instanceof CCOMPLEXOBJECT) {
            if ("/category".equalsIgnoreCase((String)path)) {
                return null;
            }
            if ("/context".equalsIgnoreCase((String)path)) {
                return this.handleComplexObject(opt, (CCOMPLEXOBJECT)cobj, termDef, attrName, (String)path);
            }
            if (!((CCOMPLEXOBJECT)cobj).getNodeId().isEmpty()) {
                path = (String)path + "[" + ((CCOMPLEXOBJECT)cobj).getNodeId() + "]";
            }
            this.log.debug("CONTEXT path=" + (String)path);
            return this.handleComplexObject(opt, (CCOMPLEXOBJECT)cobj, termDef, attrName, (String)path);
        }
        if (cobj instanceof ARCHETYPESLOT) {
            if (!((ARCHETYPESLOT)cobj).getNodeId().isEmpty()) {
                path = (String)path + "[" + ((ARCHETYPESLOT)cobj).getNodeId() + "]";
            }
            ARCHETYPESLOT slot = (ARCHETYPESLOT)cobj;
            this.log.debug("ARCHETYPESLOT path=" + (String)path);
            return null;
        }
        if (cobj instanceof CPRIMITIVEOBJECT) {
            return this.traversePrimitiveTypeObject((CPRIMITIVEOBJECT)cobj);
        }
        if (cobj.getNodeId() == null) {
            this.log.debug("NodeId is null : " + cobj);
            return null;
        }
        this.log.debug("Some value cannot process because is not CARCHETYPEROOT or CCOMPLEXOBJECT : " + cobj);
        return null;
    }

    private String getCompName(String nodeId, String name) {
        if (name != null && !name.isEmpty()) {
            if (nodeId != null && !nodeId.isEmpty()) {
                return name + "[" + nodeId + "]";
            }
            return name;
        }
        return nodeId;
    }

    private List<Map> simpleInputList(String type) {
        ArrayList<Map> inputList = new ArrayList<Map>();
        HashMap<String, String> inputMap = new HashMap<String, String>();
        inputMap.put("type", type);
        inputList.add(inputMap);
        return inputList;
    }

    private boolean heterogeneousTypes(List<Map<String, Object>> childrenList) {
        String foundType = null;
        for (Map<String, Object> child : childrenList) {
            if (foundType == null) {
                foundType = (String)child.get("type");
                continue;
            }
            if (foundType.equals((String)child.get("type"))) continue;
            return true;
        }
        return false;
    }
}

