/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ehrbase.opt.AttributeDef;
import org.ehrbase.opt.Generic;
import org.ehrbase.opt.mapper.MandatoryAttributes;

public class ValuePoint {
    String rmTypeName;

    public ValuePoint(String rmTypeName) {
        this.rmTypeName = new Generic(rmTypeName).specialize();
    }

    public List<Map<String, String>> attributes(String ... attributes) {
        if (attributes.length % 2 != 0) {
            throw new IllegalArgumentException("INTERNAL: Wrong number of arguments in value point definition");
        }
        ArrayList<Map<String, String>> definitionList = new ArrayList<Map<String, String>>();
        HashMap<String, String> attributeSpec = new HashMap<String, String>();
        for (int i = 0; i < attributes.length; ++i) {
            if (i % 2 == 0) {
                attributeSpec.putAll(new AttributeDef(attributes[i]).naming());
                continue;
            }
            attributeSpec.put("type", attributes[i]);
            definitionList.add(attributeSpec);
            attributeSpec = new HashMap();
        }
        return definitionList;
    }

    public List<Map<String, String>> attributes() {
        Map<String, Object> attributes = new MandatoryAttributes(this.rmTypeName).toMap();
        if (attributes.isEmpty()) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> definitionList = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            HashMap<String, String> attributeSpec = new HashMap<String, String>();
            attributeSpec.putAll(new AttributeDef(attribute.getKey()).naming());
            attributeSpec.put("type", String.valueOf(((Map)attribute.getValue()).get("type")));
            definitionList.add(attributeSpec);
        }
        return definitionList;
    }
}

