/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ehrbase.ehr.encode.wrappers.SnakeCase;
import org.ehrbase.opt.AttributeDef;
import org.ehrbase.opt.ValuePoint;
import org.ehrbase.opt.mapper.Constants;

public class AttributeList {
    Map<String, Object> attributes;

    public AttributeList(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public List<Map<String, Object>> toList(String path) {
        ArrayList<Map<String, Object>> attributeList = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            HashMap<String, Object> definition = new HashMap<String, Object>();
            definition.put("category", Constants.LITTERAL_ATTRIBUTE);
            definition.putAll(new AttributeDef(entry.getKey()).naming());
            String type = (String)((Map)entry.getValue()).get("type");
            definition.put("type", type);
            List<Map<String, String>> valuePointList = new ValuePoint(type).attributes();
            if (!valuePointList.isEmpty()) {
                definition.put("mandatory_attributes", valuePointList);
            }
            definition.put("aql_path", path + "/" + new SnakeCase(entry.getKey()).camelToSnake());
            HashMap<String, Object> range = new HashMap<String, Object>();
            definition.put("occurrence", range);
            range.put("min_op", ">=");
            range.put("min", 1);
            range.put("max_op", "<=");
            range.put("max", 1);
            attributeList.add(definition);
        }
        return attributeList;
    }
}

