/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.referencemodels.BuiltinReferenceModels;

public class BmmModelHelper {
    private static final BmmModel MODEL = BuiltinReferenceModels.getBmmRepository().getModel("openehr_rm_1.0.4").getModel();
    private static final String PARTY_PROXY = "PARTY_PROXY";

    private BmmModelHelper() {
    }

    static BmmClass getBmmClassForName(String typeName) {
        return MODEL.getClassDefinition(typeName);
    }

    static Map<String, Object> getRequiredAttributes(BmmClass clazz) {
        if (clazz.getName().equals(PARTY_PROXY) || clazz.getAncestors().values().stream().anyMatch(c -> c.getName().equals(PARTY_PROXY))) {
            clazz = BmmModelHelper.getBmmClassForName("PARTY_REF");
        }
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        ArrayList properties = new ArrayList();
        properties.addAll(clazz.getProperties().values());
        clazz.getAncestors().values().forEach(c -> properties.addAll(c.getProperties().values()));
        for (BmmProperty attr : properties) {
            if (!attr.getMandatory().booleanValue()) continue;
            if (attr.getType().getBaseClass().isPrimitiveType()) {
                HashMap<String, String> defMap = new HashMap<String, String>();
                retmap.put(attr.getName(), defMap);
                defMap.put("type", attr.getType().getBaseClass().getName().toUpperCase());
                continue;
            }
            Map<String, Object> submap = BmmModelHelper.getRequiredAttributes(attr.getType().getBaseClass());
            submap.put("type", attr.getType().getBaseClass().getName());
            retmap.put(attr.getName(), submap);
        }
        return retmap;
    }
}

